/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.util.Processor;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.impl.PhpTypedElementImpl;
import com.jetbrains.php.lang.psi.stubs.PhpNamedStub;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpNamedElementImpl<T extends PhpNamedStub>
extends PhpTypedElementImpl<T>
implements PhpNamedElement {
    public PhpNamedElementImpl(ASTNode node) {
        super(node);
    }

    protected PhpNamedElementImpl(T stub, @NotNull IStubElementType nodeType) {
        if (nodeType == null) {
            PhpNamedElementImpl.$$$reportNull$$$0(0);
        }
        super(stub, nodeType);
    }

    public ItemPresentation getPresentation() {
        return PhpPresentationUtil.getPresentation(this);
    }

    public PsiElement getNameIdentifier() {
        ASTNode node = this.getNameNode();
        return node != null ? node.getPsi() : null;
    }

    @Nullable
    public ASTNode getNameNode() {
        return this.getNode().findChildByType(PhpTokenTypes.IDENTIFIER);
    }

    @NotNull
    public String getName() {
        NamedStub stub = (NamedStub)this.getGreenStub();
        if (stub != null) {
            String stubName = stub.getName();
            String string = stubName != null ? stubName : "";
            if (string == null) {
                PhpNamedElementImpl.$$$reportNull$$$0(1);
            }
            return string;
        }
        ASTNode nameNode = this.getNameNode();
        if (nameNode != null) {
            String name = nameNode.getText();
            String string = name = StringUtil.trimStart((String)name, (String)"PS_UNRESERVE_PREFIX_");
            if (string == null) {
                PhpNamedElementImpl.$$$reportNull$$$0(2);
            }
            return string;
        }
        if ("" == null) {
            PhpNamedElementImpl.$$$reportNull$$$0(3);
        }
        return "";
    }

    @NotNull
    public CharSequence getNameCS() {
        NamedStub stub = (NamedStub)this.getGreenStub();
        if (stub != null) {
            String stubName = stub.getName();
            String string = stubName != null ? stubName : "";
            if (string == null) {
                PhpNamedElementImpl.$$$reportNull$$$0(4);
            }
            return string;
        }
        ASTNode nameNode = this.getNameNode();
        if (nameNode != null) {
            CharSequence name = nameNode.getChars();
            if (StringUtil.startsWith((CharSequence)name, (CharSequence)"PS_UNRESERVE_PREFIX_")) {
                name = name.subSequence("PS_UNRESERVE_PREFIX_".length(), name.length());
            }
            CharSequence charSequence = name;
            if (charSequence == null) {
                PhpNamedElementImpl.$$$reportNull$$$0(5);
            }
            return charSequence;
        }
        if ("" == null) {
            PhpNamedElementImpl.$$$reportNull$$$0(6);
        }
        return "";
    }

    public int getTextOffset() {
        ASTNode nameNode = this.getNameNode();
        if (nameNode != null) {
            return nameNode.getStartOffset();
        }
        return super.getTextOffset();
    }

    @Nullable
    public PhpDocComment getDocComment() {
        return PhpPsiUtil.getDocCommentFor(this);
    }

    public void processDocs(Processor<PhpDocComment> processor) {
        processor.process((Object)this.getDocComment());
    }

    @NotNull
    public String getFQN() {
        String string = this.getNamespaceName() + this.getName();
        if (string == null) {
            PhpNamedElementImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getNamespaceName() {
        String name = ((PhpFile)this.getContainingFile()).getMainNamespaceName();
        if (name == null) {
            PhpNamespace namespace = (PhpNamespace)PhpPsiUtil.getParentByCondition((PsiElement)this, true, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF);
            String string = name = namespace != null ? namespace.getFQN() : "";
        }
        if (!name.endsWith("\\")) {
            name = name + "\\";
        }
        String string = StringUtil.startsWithChar((CharSequence)name, (char)'\\') ? name : "\\" + name;
        if (string == null) {
            PhpNamedElementImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    public boolean isDeprecated() {
        PhpDocTag[] elements;
        PhpNamedStub stub = (PhpNamedStub)this.getGreenStub();
        if (stub != null) {
            return stub.isDeprecated();
        }
        PhpDocComment docComment = this.getDocComment();
        return docComment != null && (elements = docComment.getTagElementsByName("@deprecated")).length > 0;
    }

    public boolean isInternal() {
        PhpNamedStub stub = (PhpNamedStub)this.getGreenStub();
        if (stub != null) {
            return stub.isInternal();
        }
        PhpDocComment docComment = this.getDocComment();
        if (docComment != null) {
            PhpDocTag[] elements;
            for (PhpDocTag element : elements = docComment.getTagElementsByName("@internal")) {
                if (!(element instanceof PhpDocTag) || !StringUtil.isEmpty((String)element.getTagValue())) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpNamedElementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpNamedElementImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameCS";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQN";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

