/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class PhpInternalEntityUsedInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpInternalEntityUsedInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpMethodReference(MethodReference reference) {
                PhpInternalEntityUsedInspection.check((PhpReference)reference, "Method #ref is @internal", holder);
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                PhpInternalEntityUsedInspection.check((PhpReference)reference, "Function #ref is @internal", holder);
            }

            public void visitPhpClassReference(ClassReference reference) {
                PhpInternalEntityUsedInspection.check((PhpReference)reference, "Class #ref is @internal", holder);
            }

            public void visitPhpClassConstantReference(ClassConstantReference reference) {
                PhpInternalEntityUsedInspection.check((PhpReference)reference, "Constant #ref is @internal", holder);
            }

            public void visitPhpFieldReference(FieldReference reference) {
                PhpInternalEntityUsedInspection.check((PhpReference)reference, "Field #ref is @internal", holder);
            }

            public void visitPhpConstantReference(ConstantReference reference) {
                PhpInternalEntityUsedInspection.check((PhpReference)reference, "constant #ref is @internal", holder);
            }
        };
        if (phpElementVisitor == null) {
            PhpInternalEntityUsedInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static void check(PhpReference reference, String desc, ProblemsHolder holder) {
        PsiElement element = reference.resolve();
        if (element instanceof PhpNamedElement) {
            PhpDocTag[] elements;
            if (!((PhpNamedElement)element).isInternal()) {
                return;
            }
            PsiFile referenceFile = reference.getContainingFile();
            PsiFile resolvedElementFile = element.getContainingFile();
            if (resolvedElementFile.equals(referenceFile)) {
                return;
            }
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)holder.getProject()).getFileIndex();
            VirtualFile referenceVirtualFile = referenceFile.getVirtualFile();
            VirtualFile resolvedVirtualFile = resolvedElementFile.getVirtualFile();
            if (Objects.equals(index.getSourceRootForFile(referenceVirtualFile), index.getSourceRootForFile(resolvedVirtualFile))) {
                return;
            }
            if (index.isInTestSourceContent(referenceVirtualFile) && !index.isInLibrary(resolvedVirtualFile)) {
                return;
            }
            PhpDocComment docComment = ((PhpNamedElement)element).getDocComment();
            if (docComment != null && (elements = docComment.getTagElementsByName("@internal")).length > 0) {
                holder.registerProblem((PsiReference)reference, desc, ProblemHighlightType.LIKE_DEPRECATED);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpInternalEntityUsedInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpInternalEntityUsedInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

