/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCatchConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInterruptScriptInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpReturnInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpStatementInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpThrowInstruction;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInconsistentReturnPointsInspection
extends PhpInspection {
    public static final PhpType GENERATOR_TYPE = new PhpType().add("\\Generator");
    public static final PhpType PROBABLY_GENERATOR_TYPE = new PhpType().add("\\Iterator").add("\\Traversable").add("\\iterable");
    public static final PhpType GENERATOR_OR_PROBABLY_GENERATOR_TYPE = new PhpType().add(GENERATOR_TYPE).add(PROBABLY_GENERATOR_TYPE);
    private static final String PROBLEM_1 = PhpBundle.message("inspection.inconsistent.return.points.problem1", new Object[0]);
    private static final String PROBLEM_1_YIELD = PhpBundle.message("inspection.inconsistent.return.points.problem1.yield", new Object[0]);
    private static final String PROBLEM_2 = PhpBundle.message("inspection.inconsistent.return.points.problem2", new Object[0]);
    private static final String PROBLEM_3 = PhpBundle.message("inspection.inconsistent.return.points.problem3", new Object[0]);
    public boolean ALLOW_RETURN_NULL_IN_VOID = true;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpInconsistentReturnPointsInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                PhpInconsistentReturnPointsInspection.this.analyzeScope(function, holder);
            }

            public void visitPhpMethod(Method method) {
                PhpInconsistentReturnPointsInspection.this.analyzeScope((Function)method, holder);
            }
        };
        if (phpElementVisitor == null) {
            PhpInconsistentReturnPointsInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private void analyzeScope(@NotNull Function function, @NotNull ProblemsHolder holder) {
        PhpType declaredType;
        boolean isGenerator;
        if (function == null) {
            PhpInconsistentReturnPointsInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            PhpInconsistentReturnPointsInspection.$$$reportNull$$$0(3);
        }
        final boolean isProbablyGenerator = !(isGenerator = PhpType.intersects((PhpType)GENERATOR_TYPE, (PhpType)(declaredType = PhpInconsistentReturnPointsInspection.getDeclaredType(function)))) && PhpType.intersects((PhpType)PROBABLY_GENERATOR_TYPE, (PhpType)declaredType);
        final boolean isVoid = !isGenerator && !isProbablyGenerator && PhpType.intersects((PhpType)PhpType.VOID, (PhpType)declaredType);
        final Ref yieldIsPresent = new Ref((Object)false);
        final Ref canExitWithoutReturnRef = new Ref((Object)false);
        final List returnWithoutArgument = ContainerUtil.newSmartList();
        final List returnWithArgument = ContainerUtil.newSmartList();
        PhpControlFlowUtil.processPredecessors((PhpInstruction)function.getControlFlow().getExitPoint(), false, new PhpInstructionProcessor(){

            public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                if (!isVoid) {
                    canExitWithoutReturnRef.set((Object)true);
                }
                return false;
            }

            public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                if (!isVoid && instruction.getPredecessors().size() > 0) {
                    if (this.isSkippedStatement(instruction.getStatement())) {
                        return true;
                    }
                    if ((isGenerator || isProbablyGenerator) && this.containsYield(instruction.getStatement())) {
                        yieldIsPresent.set((Object)true);
                        return false;
                    }
                    canExitWithoutReturnRef.set((Object)true);
                }
                return (isGenerator || isProbablyGenerator) && (Boolean)yieldIsPresent.get() == false;
            }

            private boolean isSkippedStatement(@NotNull Statement statement) {
                if (statement == null) {
                    2.$$$reportNull$$$0(0);
                }
                return statement instanceof PhpBreak;
            }

            private boolean containsYield(@NotNull Statement statement) {
                if (statement == null) {
                    2.$$$reportNull$$$0(1);
                }
                final Ref result = Ref.create((Object)false);
                statement.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                    public void visitElement(PsiElement element) {
                        if (element instanceof PhpYield) {
                            result.set((Object)true);
                            this.stopWalking();
                        } else if (!(element instanceof GroupStatement)) {
                            super.visitElement(element);
                        }
                    }
                });
                return (Boolean)result.get();
            }

            public boolean processThrowInstruction(PhpThrowInstruction instruction) {
                return false;
            }

            public boolean processCatchConditionInstruction(PhpCatchConditionInstruction instruction) {
                return instruction.getResult();
            }

            public boolean processInterruptScriptInstruction(PhpInterruptScriptInstruction instruction) {
                return false;
            }

            public boolean processReturnInstruction(PhpReturnInstruction instruction) {
                PhpReturn phpReturn;
                PsiElement argument = instruction.getArgument();
                if (argument != null) {
                    if (!PhpInconsistentReturnPointsInspection.this.ALLOW_RETURN_NULL_IN_VOID || !PhpCodeInsightUtil.isNull(argument)) {
                        returnWithArgument.add(argument);
                    }
                } else if (!isVoid && (phpReturn = this.getPredecessorReturnStatement(instruction)) != null) {
                    returnWithoutArgument.add(phpReturn);
                }
                return isGenerator;
            }

            @Nullable
            public PhpReturn getPredecessorReturnStatement(PhpReturnInstruction instruction) {
                final Ref phpReturn = new Ref(null);
                PhpControlFlowUtil.processPredecessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                    public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                        Statement statement = instruction.getStatement();
                        if (statement instanceof PhpReturn) {
                            phpReturn.set((Object)((PhpReturn)statement));
                            return false;
                        }
                        return true;
                    }
                });
                return (PhpReturn)phpReturn.get();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "statement";
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpInconsistentReturnPointsInspection$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSkippedStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "containsYield";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (isVoid) {
            for (PsiElement phpReturnArgument : returnWithArgument) {
                Object phpReturn = PhpPsiUtil.getParentByCondition(phpReturnArgument, (Condition<? super PsiElement>)PhpReturn.INSTANCEOF);
                if (phpReturn == null) continue;
                holder.registerProblem(phpReturn, PROBLEM_3, new LocalQuickFix[0]);
            }
        } else {
            PsiElement rBrace;
            GroupStatement groupStatement;
            if (returnWithArgument.size() > 0) {
                for (PhpReturn phpReturn : returnWithoutArgument) {
                    holder.registerProblem((PsiElement)phpReturn, PROBLEM_2, new LocalQuickFix[0]);
                }
            }
            if ((returnWithArgument.size() > 0 || function.getReturnType() != null || PhpInconsistentReturnPointsInspection.getReturnTag(function) != null) && ((Boolean)canExitWithoutReturnRef.get() != false && (!isGenerator && !isProbablyGenerator || isProbablyGenerator && (Boolean)yieldIsPresent.get() == false) || isGenerator && !((Boolean)yieldIsPresent.get()).booleanValue() && !PhpInconsistentReturnPointsInspection.returnsGeneratorOrProbablyReturnsGenerator(returnWithArgument)) && (groupStatement = (GroupStatement)PsiTreeUtil.getChildOfType((PsiElement)function, GroupStatement.class)) != null && (rBrace = PhpPsiUtil.getChildOfType((PsiElement)groupStatement, PhpTokenTypes.chRBRACE)) != null) {
                holder.registerProblem(rBrace, !isGenerator ? PROBLEM_1 : PROBLEM_1_YIELD, new LocalQuickFix[0]);
            }
        }
    }

    @Nullable
    private static PhpDocReturnTag getReturnTag(@NotNull Function function) {
        PhpDocComment docComment;
        if (function == null) {
            PhpInconsistentReturnPointsInspection.$$$reportNull$$$0(4);
        }
        return (docComment = function.getDocComment()) != null ? docComment.getReturnTag() : null;
    }

    @NotNull
    private static PhpType getDeclaredType(@NotNull Function function) {
        if (function == null) {
            PhpInconsistentReturnPointsInspection.$$$reportNull$$$0(5);
        }
        PhpType phpType = new PhpType().add(function.getDeclaredType()).add(function.getDocType());
        if (phpType == null) {
            PhpInconsistentReturnPointsInspection.$$$reportNull$$$0(6);
        }
        return phpType;
    }

    private static boolean returnsGeneratorOrProbablyReturnsGenerator(@NotNull List<PsiElement> returnWithArgument) {
        if (returnWithArgument == null) {
            PhpInconsistentReturnPointsInspection.$$$reportNull$$$0(7);
        }
        return returnWithArgument.stream().filter(PhpTypedElement.class::isInstance).map(PhpTypedElement.class::cast).map(PhpTypedElement::getType).anyMatch(type -> PhpType.intersects((PhpType)GENERATOR_OR_PROBABLY_GENERATOR_TYPE, (PhpType)type));
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpInconsistentReturnPointsInspection";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnWithArgument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpInconsistentReturnPointsInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "analyzeScope";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTag";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "returnsGeneratorOrProbablyReturnsGenerator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class OptionsPanel {
        private JPanel myMainPanel;
        private JBCheckBox myAllowReturnNullInVoidCheckBox;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myAllowReturnNullInVoidCheckBox.setSelected(PhpInconsistentReturnPointsInspection.this.ALLOW_RETURN_NULL_IN_VOID);
            this.myAllowReturnNullInVoidCheckBox.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpInconsistentReturnPointsInspection.this.ALLOW_RETURN_NULL_IN_VOID = OptionsPanel.this.myAllowReturnNullInVoidCheckBox.isSelected();
                }
            });
        }

        public JPanel getComponent() {
            return this.myMainPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JBCheckBox jBCheckBox;
            JPanel jPanel;
            this.myMainPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myAllowReturnNullInVoidCheckBox = jBCheckBox = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.inconsistent.return.points.option.treat.return"));
            jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myMainPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

