/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerRunningData;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.actions.ComposerAbstractAction;
import com.jetbrains.php.composer.actions.ComposerActionCommandExecutor;
import com.jetbrains.php.composer.actions.ComposerCommandExecutor;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.configData.PackageComposerConfigClient;
import com.jetbrains.php.composer.statistics.ComposerActionStatistics;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerUpdateAction
extends ComposerAbstractAction {
    @Override
    protected void doPerformAction(@NotNull Project project, @NotNull VirtualFile configFile, @NotNull String placeForStatistics) {
        if (project == null) {
            ComposerUpdateAction.$$$reportNull$$$0(0);
        }
        if (configFile == null) {
            ComposerUpdateAction.$$$reportNull$$$0(1);
        }
        if (placeForStatistics == null) {
            ComposerUpdateAction.$$$reportNull$$$0(2);
        }
        ComposerCommandExecutor commandExecutor = ComposerUpdateAction.createExecutor(project, ComposerDataService.getInstance(project), configFile, "--no-interaction --ansi", placeForStatistics);
        commandExecutor.execute();
    }

    @NotNull
    protected static ComposerCommandExecutor createExecutor(final @NotNull Project project, final @NotNull ComposerRunningData runningData, final @NotNull VirtualFile configFile, final @Nullable String commandLineOptions, @NotNull String placeForStatistics) {
        if (project == null) {
            ComposerUpdateAction.$$$reportNull$$$0(3);
        }
        if (runningData == null) {
            ComposerUpdateAction.$$$reportNull$$$0(4);
        }
        if (configFile == null) {
            ComposerUpdateAction.$$$reportNull$$$0(5);
        }
        if (placeForStatistics == null) {
            ComposerUpdateAction.$$$reportNull$$$0(6);
        }
        ComposerActionStatistics statistics = ComposerActionStatistics.createWithoutOptions("updateAll", placeForStatistics);
        ComposerActionCommandExecutor.WithConfig withConfig = new ComposerActionCommandExecutor.WithConfig(project, runningData, configFile, commandLineOptions, statistics, true, false){

            @Override
            @NotNull
            protected List<String> getBasicCommand() {
                List<String> list = ComposerUtils.getSimpleBasicCommand(runningData, "update");
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            @Override
            protected String getProgressTitle() {
                return PhpBundle.message("framework.composer.update.task.title", new Object[0]);
            }

            @Override
            protected String getActionName() {
                return PhpBundle.message("framework.composer.update.action.name", new Object[0]);
            }

            @Override
            protected void onFinish(boolean success) {
                super.onFinish(success);
                ComposerUtils.refreshVendorDir(configFile);
                ComposerAbstractAction.refreshConfigAndLockFiles(configFile, () -> {
                    if (project == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    PackageComposerConfigClient.updatePackagesSettings(project);
                });
            }

            @Override
            protected ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> getExecutorGenerator() {
                List<String> beginning = this.myRunningData.getComposerCommandBeginning();
                return ComposerUpdateAction.createGenerator(() -> beginning, configFile.getPath(), commandLineOptions);
            }

            @Override
            @Nls(capitalization=Nls.Capitalization.Title)
            @NotNull
            protected String getTaskTitle() {
                if ("Update Composer Packages" == null) {
                    1.$$$reportNull$$$0(1);
                }
                return "Update Composer Packages";
            }

            @Override
            protected ComposerLogMessageBuilder.SummaryMessage createSuccessfulSummary() {
                return new ComposerLogMessageBuilder.SummaryMessage().appendText("All packages for ").appendLink(this.myComposerJson, this.myProject).appendText(" have been updated.");
            }

            @Override
            protected ComposerLogMessageBuilder.SummaryMessage createFailureSummary() {
                return new ComposerLogMessageBuilder.SummaryMessage().appendText("Failed to update packages for  ").appendLink(this.myComposerJson, this.myProject).appendText(".");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/composer/actions/ComposerUpdateAction$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBasicCommand";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTaskTitle";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerUpdateAction$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$onFinish$0";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (withConfig == null) {
            ComposerUpdateAction.$$$reportNull$$$0(7);
        }
        return withConfig;
    }

    @NotNull
    private static ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> createGenerator(ComposerRunningData data, String configFilePath, String commandLineOptions) {
        ThrowableNotNullFunction throwableNotNullFunction = generatorProject -> {
            VirtualFile configFile = LocalFileSystem.getInstance().findFileByPath(configFilePath);
            ComposerCommandExecutor.checkFileExists(configFilePath, configFile);
            return ComposerUpdateAction.createExecutor(generatorProject, data, configFile, commandLineOptions, "ComposerLogRerun");
        };
        if (throwableNotNullFunction == null) {
            ComposerUpdateAction.$$$reportNull$$$0(8);
        }
        return throwableNotNullFunction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeForStatistics";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runningData";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/actions/ComposerUpdateAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerUpdateAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doPerformAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createExecutor";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

