/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.dataFlow.reachingDefinition;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpReachingDefinitionDFAnalyzer;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpReachingDefinitionsDFAnalyzer;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PhpDFAUtil {
    private PhpDFAUtil() {
    }

    public static void union(@NotNull Set<? extends CharSequence> a, @NotNull Set<? extends CharSequence> b, @NotNull Set<? super CharSequence> union) {
        if (a == null) {
            PhpDFAUtil.$$$reportNull$$$0(0);
        }
        if (b == null) {
            PhpDFAUtil.$$$reportNull$$$0(1);
        }
        if (union == null) {
            PhpDFAUtil.$$$reportNull$$$0(2);
        }
        union.addAll(a);
        union.addAll(b);
    }

    public static void intersect(@NotNull Set<? extends CharSequence> a, @NotNull Set<? extends CharSequence> b, @NotNull Set<? super CharSequence> intersection, @NotNull Set<? super CharSequence> aMinusB) {
        if (a == null) {
            PhpDFAUtil.$$$reportNull$$$0(3);
        }
        if (b == null) {
            PhpDFAUtil.$$$reportNull$$$0(4);
        }
        if (intersection == null) {
            PhpDFAUtil.$$$reportNull$$$0(5);
        }
        if (aMinusB == null) {
            PhpDFAUtil.$$$reportNull$$$0(6);
        }
        for (CharSequence charSequence : a) {
            if (b.contains(charSequence)) {
                intersection.add(charSequence);
                continue;
            }
            aMinusB.add(charSequence);
        }
    }

    public static boolean isAndEmpty(Collection ... collections) {
        if (collections == null) {
            PhpDFAUtil.$$$reportNull$$$0(7);
        }
        for (Collection collection : collections) {
            if (collection.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static void performReachingDefinitions(@NotNull PhpInstruction instruction, final @NotNull Ref<Boolean> canBeDefined, final @NotNull Ref<Boolean> canBeUndefined, final @NotNull String name, final @NotNull PhpReachingDefinitionsDFAnalyzer dfAnalyzer) {
        if (instruction == null) {
            PhpDFAUtil.$$$reportNull$$$0(8);
        }
        if (canBeDefined == null) {
            PhpDFAUtil.$$$reportNull$$$0(9);
        }
        if (canBeUndefined == null) {
            PhpDFAUtil.$$$reportNull$$$0(10);
        }
        if (name == null) {
            PhpDFAUtil.$$$reportNull$$$0(11);
        }
        if (dfAnalyzer == null) {
            PhpDFAUtil.$$$reportNull$$$0(12);
        }
        PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges(instruction, false, new PhpInstructionProcessor(){

            public boolean processConditionInstruction(PhpConditionInstruction instruction) {
                PsiElement condition = instruction.getCondition();
                if (condition == null) {
                    return true;
                }
                PhpReachingDefinitionsDFAnalyzer.Result dfaResult = (PhpReachingDefinitionsDFAnalyzer.Result)dfAnalyzer.performDFA(instruction);
                return dfaResult.apply(name, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined);
            }
        });
    }

    public static void performReachingDefinition(@NotNull PhpInstruction instruction, final @NotNull Ref<Boolean> canBeDefined, final @NotNull Ref<Boolean> canBeUndefined, final @NotNull PhpReachingDefinitionDFAnalyzer dfAnalyzer) {
        if (instruction == null) {
            PhpDFAUtil.$$$reportNull$$$0(13);
        }
        if (canBeDefined == null) {
            PhpDFAUtil.$$$reportNull$$$0(14);
        }
        if (canBeUndefined == null) {
            PhpDFAUtil.$$$reportNull$$$0(15);
        }
        if (dfAnalyzer == null) {
            PhpDFAUtil.$$$reportNull$$$0(16);
        }
        PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges(instruction, false, new PhpInstructionProcessor(){

            public boolean processConditionInstruction(PhpConditionInstruction instruction) {
                PsiElement condition = instruction.getCondition();
                if (condition == null) {
                    return true;
                }
                PhpReachingDefinitionDFAnalyzer.Result dfaResult = (PhpReachingDefinitionDFAnalyzer.Result)dfAnalyzer.performDFA(instruction);
                return dfaResult.apply((Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "union";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intersection";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aMinusB";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collections";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canBeDefined";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canBeUndefined";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfAnalyzer";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/codeInsight/dataFlow/reachingDefinition/PhpDFAUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "union";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "intersect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isAndEmpty";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "performReachingDefinitions";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "performReachingDefinition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

