/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.push;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.push.OutgoingCommitsProvider;
import com.intellij.dvcs.push.PushSettings;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.Pusher;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.push.HgOutgoingCommitsProvider;
import org.zmlx.hg4idea.push.HgPushOptionsPanel;
import org.zmlx.hg4idea.push.HgPushSource;
import org.zmlx.hg4idea.push.HgPushTargetPanel;
import org.zmlx.hg4idea.push.HgPusher;
import org.zmlx.hg4idea.push.HgTarget;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgUtil;

public class HgPushSupport
extends PushSupport<HgRepository, HgPushSource, HgTarget> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final HgVcs myVcs;
    @NotNull
    private final HgProjectSettings mySettings;
    @NotNull
    private final PushSettings myCommonPushSettings;

    public HgPushSupport(@NotNull Project project) {
        if (project == null) {
            HgPushSupport.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myVcs = (HgVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)HgVcs.getInstance(this.myProject))));
        this.mySettings = this.myVcs.getProjectSettings();
        this.myCommonPushSettings = (PushSettings)ServiceManager.getService((Project)project, PushSettings.class);
    }

    @NotNull
    public AbstractVcs getVcs() {
        HgVcs hgVcs = this.myVcs;
        if (hgVcs == null) {
            HgPushSupport.$$$reportNull$$$0(1);
        }
        return hgVcs;
    }

    @NotNull
    public Pusher<HgRepository, HgPushSource, HgTarget> getPusher() {
        HgPusher hgPusher = new HgPusher();
        if (hgPusher == null) {
            HgPushSupport.$$$reportNull$$$0(2);
        }
        return hgPusher;
    }

    @NotNull
    public OutgoingCommitsProvider<HgRepository, HgPushSource, HgTarget> getOutgoingCommitsProvider() {
        HgOutgoingCommitsProvider hgOutgoingCommitsProvider = new HgOutgoingCommitsProvider();
        if (hgOutgoingCommitsProvider == null) {
            HgPushSupport.$$$reportNull$$$0(3);
        }
        return hgOutgoingCommitsProvider;
    }

    @Nullable
    public HgTarget getDefaultTarget(@NotNull HgRepository repository) {
        String defaultPushPath;
        if (repository == null) {
            HgPushSupport.$$$reportNull$$$0(4);
        }
        return (defaultPushPath = repository.getRepositoryConfig().getDefaultPushPath()) == null ? null : new HgTarget(defaultPushPath, repository.getCurrentBranchName());
    }

    @NotNull
    public HgPushSource getSource(@NotNull HgRepository repository) {
        if (repository == null) {
            HgPushSupport.$$$reportNull$$$0(5);
        }
        String localBranch = repository.getCurrentBranchName();
        HgPushSource hgPushSource = new HgPushSource(localBranch);
        if (hgPushSource == null) {
            HgPushSupport.$$$reportNull$$$0(6);
        }
        return hgPushSource;
    }

    @NotNull
    public RepositoryManager<HgRepository> getRepositoryManager() {
        HgRepositoryManager hgRepositoryManager = HgUtil.getRepositoryManager(this.myProject);
        if (hgRepositoryManager == null) {
            HgPushSupport.$$$reportNull$$$0(7);
        }
        return hgRepositoryManager;
    }

    @Nullable
    public VcsPushOptionsPanel createOptionsPanel() {
        return new HgPushOptionsPanel();
    }

    @NotNull
    public PushTargetPanel<HgTarget> createTargetPanel(@NotNull HgRepository repository, @Nullable HgTarget defaultTarget) {
        if (repository == null) {
            HgPushSupport.$$$reportNull$$$0(8);
        }
        HgPushTargetPanel hgPushTargetPanel = new HgPushTargetPanel(repository, defaultTarget);
        if (hgPushTargetPanel == null) {
            HgPushSupport.$$$reportNull$$$0(9);
        }
        return hgPushTargetPanel;
    }

    public boolean isForcePushAllowed(@NotNull HgRepository repo, @NotNull HgTarget target) {
        if (repo == null) {
            HgPushSupport.$$$reportNull$$$0(10);
        }
        if (target == null) {
            HgPushSupport.$$$reportNull$$$0(11);
        }
        return true;
    }

    public boolean shouldRequestIncomingChangesForNotCheckedRepositories() {
        return this.mySettings.getSyncSetting() == DvcsSyncSettings.Value.SYNC;
    }

    public void saveSilentForcePushTarget(@NotNull HgTarget target) {
        if (target == null) {
            HgPushSupport.$$$reportNull$$$0(12);
        }
        this.myCommonPushSettings.addForcePushTarget(target.getPresentation(), target.getBranchName());
    }

    public boolean isSilentForcePushAllowed(@NotNull HgTarget target) {
        if (target == null) {
            HgPushSupport.$$$reportNull$$$0(13);
        }
        return this.myCommonPushSettings.containsForcePushTarget(target.getPresentation(), target.getBranchName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/push/HgPushSupport";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repo";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/push/HgPushSupport";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcs";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPusher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutgoingCommitsProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSource";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargetPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTarget";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSource";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTargetPanel";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isForcePushAllowed";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "saveSilentForcePushTarget";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isSilentForcePushAllowed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

