/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.ArrayList;
import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.BlockArgNode;
import org.jrubyparser.ast.IParameter;
import org.jrubyparser.ast.KeywordRestArgNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.RestArgNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgsNode
extends Node {
    private ListNode pre;
    private ListNode optional;
    private ListNode post;
    protected ArgumentNode rest;
    private ListNode keywords;
    private KeywordRestArgNode keywordRest;
    private BlockArgNode block;
    private ListNode shadow;

    public ArgsNode(SourcePosition position, ListNode pre, ListNode optional, RestArgNode rest, ListNode post, ListNode keywords, KeywordRestArgNode keywordRest, BlockArgNode block) {
        super(position);
        this.pre = (ListNode)this.adopt(pre);
        this.optional = (ListNode)this.adopt(optional);
        this.post = (ListNode)this.adopt(post);
        this.rest = (ArgumentNode)this.adopt(rest);
        this.keywords = keywords;
        this.keywordRest = keywordRest;
        this.block = (BlockArgNode)this.adopt(block);
    }

    @Override
    public boolean isSame(Node node) {
        if (!super.isSame(node)) {
            return false;
        }
        List<Node> params = this.getNormativeParameterList();
        List<Node> otherParams = ((ArgsNode)node).getNormativeParameterList();
        if (params.size() != otherParams.size()) {
            return false;
        }
        for (int i = 0; i <= params.size() - 1; ++i) {
            if (params.get(i).isSame(otherParams.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ARGSNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitArgsNode(this);
    }

    public int getPreCount() {
        return this.pre == null ? 0 : this.pre.size();
    }

    public int getOptionalCount() {
        return this.optional == null ? 0 : this.optional.size();
    }

    public int getPostCount() {
        return this.post == null ? 0 : this.post.size();
    }

    public int getRequiredCount() {
        return this.getPreCount() + this.getPostCount();
    }

    public int getMaxArgumentsCount() {
        return this.getRequiredCount() + this.getOptionalCount();
    }

    public ListNode getOptional() {
        return this.optional;
    }

    public ListNode getPost() {
        return this.post;
    }

    public ListNode getPre() {
        return this.pre;
    }

    public ArgumentNode getRest() {
        return this.rest;
    }

    public BlockArgNode getBlock() {
        return this.block;
    }

    public ListNode getShadow() {
        return this.shadow;
    }

    public void setShadow(ListNode shadow) {
        this.shadow = (ListNode)this.adopt(shadow);
    }

    public List<String> getNormativeParameterNameList(boolean namesOnly) {
        ArrayList<String> parameters = new ArrayList<String>();
        if (this.getPreCount() > 0) {
            for (Node preArg : this.getPre().childNodes()) {
                if (!(preArg instanceof IParameter)) continue;
                parameters.add(((IParameter)((Object)preArg)).getName());
            }
        }
        if (this.getOptionalCount() > 0) {
            for (Node optArg : this.getOptional().childNodes()) {
                if (!(optArg instanceof IParameter)) continue;
                parameters.add(((IParameter)((Object)optArg)).getName());
            }
        }
        if (this.getPostCount() > 0) {
            for (Node postArg : this.getPost().childNodes()) {
                if (!(postArg instanceof IParameter)) continue;
                parameters.add(((IParameter)((Object)postArg)).getName());
            }
        }
        if (this.getRest() != null) {
            parameters.add(namesOnly ? this.getRest().getName() : "*" + this.getRest().getName());
        }
        if (this.getBlock() != null) {
            parameters.add(namesOnly ? this.getBlock().getName() : "&" + this.getBlock().getName());
        }
        return parameters;
    }

    public List<Node> getNormativeParameterList() {
        ArrayList<Node> parameters = new ArrayList<Node>();
        if (this.getPreCount() > 0) {
            for (Node preArg : this.getPre().childNodes()) {
                if (!(preArg instanceof IParameter)) continue;
                parameters.add(preArg);
            }
        }
        if (this.getOptionalCount() > 0) {
            for (Node optArg : this.getOptional().childNodes()) {
                if (!(optArg instanceof IParameter)) continue;
                parameters.add(optArg);
            }
        }
        if (this.getPostCount() > 0) {
            for (Node postArg : this.getPost().childNodes()) {
                if (!(postArg instanceof IParameter)) continue;
                parameters.add(postArg);
            }
        }
        if (this.getRest() != null) {
            parameters.add(this.getRest());
        }
        if (this.getBlock() != null) {
            parameters.add(this.getBlock());
        }
        return parameters;
    }
}

