/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vfs;

import com.intellij.database.Dbms;
import com.intellij.openapi.fileTypes.UserBinaryFileType;
import icons.DatabaseIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class DbStorageFileType
extends UserBinaryFileType {
    private final Dbms myDbms;
    private final String myPrefix;

    protected DbStorageFileType(@NotNull Dbms id, @NotNull String prefix) {
        if (id == null) {
            DbStorageFileType.$$$reportNull$$$0(0);
        }
        if (prefix == null) {
            DbStorageFileType.$$$reportNull$$$0(1);
        }
        this.myDbms = id;
        this.myPrefix = prefix;
    }

    @NotNull
    public String getName() {
        String string = this.getDbms().getDisplayName() + " Database";
        if (string == null) {
            DbStorageFileType.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.getDbms().getDisplayName() + " storage";
        if (string == null) {
            DbStorageFileType.$$$reportNull$$$0(3);
        }
        return string;
    }

    public Icon getIcon() {
        return DatabaseIcons.Dbms;
    }

    @NotNull
    public final Dbms getDbms() {
        Dbms dbms = this.myDbms;
        if (dbms == null) {
            DbStorageFileType.$$$reportNull$$$0(4);
        }
        return dbms;
    }

    public boolean isReadOnly() {
        return true;
    }

    @NotNull
    final String getFilePrefix() {
        String string = this.myPrefix;
        if (string == null) {
            DbStorageFileType.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/vfs/DbStorageFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/vfs/DbStorageFileType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class H2Storage
    extends DbStorageFileType {
        public static final H2Storage INSTANCE = new H2Storage();

        private H2Storage() {
            super(Dbms.H2, "-- H2 0.5/B --");
        }

        @NotNull
        public String getDefaultExtension() {
            if ("h2.db" == null) {
                H2Storage.$$$reportNull$$$0(0);
            }
            return "h2.db";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/DbStorageFileType$H2Storage", "getDefaultExtension"));
        }
    }

    public static class SqliteStorage
    extends DbStorageFileType {
        public static final SqliteStorage INSTANCE = new SqliteStorage();

        private SqliteStorage() {
            super(Dbms.SQLITE, "SQLite format ");
        }
    }
}

