/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.DatabaseTargetElementEvaluator;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbViewGotoRelatedProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            DbViewGotoRelatedProvider.$$$reportNull$$$0(0);
        }
        if (!(psiElement instanceof DasObject)) {
            List list = Collections.emptyList();
            if (list == null) {
                DbViewGotoRelatedProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        final ArrayList result2 = ContainerUtil.newArrayList();
        if (psiElement instanceof DasColumn) {
            DasColumn columnInfo = (DasColumn)psiElement;
            if (DasUtil.isForeign((DasColumn)columnInfo)) {
                for (DasForeignKey keyInfo : DasUtil.getForeignKeys((DasTable)columnInfo.getTable())) {
                    MultiRef.It it = keyInfo.getColumnsRef().iterate();
                    while (it.hasNext()) {
                        String next = (String)it.next();
                        if (!Comparing.equal((String)next, (String)columnInfo.getName())) continue;
                        DbViewGotoRelatedProvider.addItem(result2, (DasObject)it.resolve());
                    }
                }
                ArrayList arrayList = result2;
                if (arrayList == null) {
                    DbViewGotoRelatedProvider.$$$reportNull$$$0(2);
                }
                return arrayList;
            }
        } else {
            if (psiElement instanceof DasTableChild) {
                if (psiElement instanceof DasForeignKey) {
                    this.addItems(result2, (MultiRef<? extends DasTypedObject>)((DasForeignKey)psiElement).getRefColumns(), "Referenced");
                }
                if (psiElement instanceof DasConstraint) {
                    String group2 = psiElement instanceof DasForeignKey ? "Referring" : "";
                    this.addItems(result2, (MultiRef<? extends DasTypedObject>)((DasConstraint)psiElement).getColumnsRef(), group2);
                } else if (psiElement instanceof DasIndex) {
                    this.addItems(result2, (MultiRef<? extends DasTypedObject>)((DasIndex)psiElement).getColumnsRef(), "");
                }
                ArrayList arrayList = result2;
                if (arrayList == null) {
                    DbViewGotoRelatedProvider.$$$reportNull$$$0(3);
                }
                return arrayList;
            }
            if (psiElement instanceof DasSynonym) {
                DbViewGotoRelatedProvider.addItem(result2, ((DasSynonym)psiElement).resolveTarget());
                ArrayList arrayList = result2;
                if (arrayList == null) {
                    DbViewGotoRelatedProvider.$$$reportNull$$$0(4);
                }
                return arrayList;
            }
            if (psiElement instanceof DasDataSource) {
                VirtualFile dsRoot;
                String uniqueId = ((DasDataSource)psiElement).getUniqueId();
                if (uniqueId == null) {
                    List list = Collections.emptyList();
                    if (list == null) {
                        DbViewGotoRelatedProvider.$$$reportNull$$$0(5);
                    }
                    return list;
                }
                final DbConsoleRootType rootType = DbConsoleRootType.getInstance();
                VirtualFile root2 = LocalFileSystem.getInstance().findFileByPath(ScratchFileService.getInstance().getRootPath((RootType)rootType));
                VirtualFile virtualFile = dsRoot = root2 != null && root2.isDirectory() ? root2.findChild(uniqueId) : null;
                if (dsRoot != null && dsRoot.isDirectory()) {
                    final PsiManager psiManager = psiElement.getManager();
                    VfsUtilCore.visitChildrenRecursively((VirtualFile)dsRoot, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                        public boolean visitFile(final @NotNull VirtualFile file) {
                            if (file == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (file.isDirectory()) {
                                return true;
                            }
                            PsiFile psiFile = psiManager.findFile(file);
                            if (psiFile instanceof SqlFile) {
                                result2.add(new GotoRelatedItem((PsiElement)psiFile){

                                    @Nullable
                                    public String getCustomName() {
                                        return rootType.substituteName(psiManager.getProject(), file);
                                    }

                                    public String getCustomContainerName() {
                                        return "(" + rootType.getDisplayName() + ")";
                                    }

                                    @Nullable
                                    public Icon getCustomIcon() {
                                        return rootType.substituteIcon(psiManager.getProject(), file);
                                    }
                                });
                            }
                            return true;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/psi/DbViewGotoRelatedProvider$1", "visitFile"));
                        }
                    });
                    ArrayList arrayList = result2;
                    if (arrayList == null) {
                        DbViewGotoRelatedProvider.$$$reportNull$$$0(6);
                    }
                    return arrayList;
                }
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            DbViewGotoRelatedProvider.$$$reportNull$$$0(7);
        }
        return list;
    }

    protected void addItems(List<GotoRelatedItem> result2, MultiRef<? extends DasTypedObject> columns, String title) {
        for (DasTypedObject column2 : columns.resolveObjects()) {
            DbViewGotoRelatedProvider.addItem(result2, (DasObject)column2, title);
        }
    }

    private static void addItem(List<GotoRelatedItem> result2, DasObject target) {
        DbViewGotoRelatedProvider.addItem(result2, target, "");
    }

    private static void addItem(List<GotoRelatedItem> result2, DasObject target, String title) {
        if (target instanceof DbElement) {
            final PsiElement navElement = new DatabaseTargetElementEvaluator().getGotoDeclarationTarget((PsiElement)((DbElement)target), null);
            result2.add(new GotoRelatedItem((PsiElement)((DbElement)target), title){

                public void navigate() {
                    ((Navigatable)ObjectUtils.notNull((Object)((Navigatable)navElement))).navigate(true);
                }
            });
        } else if (target instanceof PsiElement) {
            result2.add(new GotoRelatedItem((PsiElement)target, title));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbViewGotoRelatedProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbViewGotoRelatedProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getItems";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

