/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.diff;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.diff.DbDiffRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.util.Case;
import com.intellij.database.util.QNameUtil;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.ide.diff.AsyncDiffElement;
import com.intellij.ide.diff.DiffElement;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.dir.ComparableDiffElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class DbDiffElement
extends DiffElement<BasicElement>
implements AsyncDiffElement,
ComparableDiffElement {
    private static final Logger LOG = Logger.getInstance(DbDiffElement.class);
    public static final String IGNORE_ORDER = "IGNORE_ORDER";
    public static final String IGNORE_CASE = "IGNORE_CASE";
    public static final String PG_IGNORE_OWNER = "PG_IGNORE_OWNER";
    private final DbDiffRoot myRoot;
    private final BasicElement myElement;
    private final BasicModElement myAltElement;
    private BasicElement myAltCache;

    public DbDiffElement(@NotNull DbDiffRoot root2, @NotNull BasicElement element2, @Nullable BasicModElement altElement) {
        if (root2 == null) {
            DbDiffElement.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            DbDiffElement.$$$reportNull$$$0(1);
        }
        this.myRoot = root2;
        this.myElement = element2;
        this.myAltElement = altElement;
    }

    public void refresh(boolean userInitiated) {
        this.myAltCache = null;
    }

    @NotNull
    public DbDiffRoot getRoot() {
        DbDiffRoot dbDiffRoot = this.myRoot;
        if (dbDiffRoot == null) {
            DbDiffElement.$$$reportNull$$$0(2);
        }
        return dbDiffRoot;
    }

    public String getPresentablePath() {
        return this.myRoot.getDataSource().getName() + ":/" + this.getPath();
    }

    public String getPath() {
        return this.getPath(this.getValue());
    }

    @NotNull
    private String getPath(@Nullable BasicElement value) {
        if (value == null) {
            if ("" == null) {
                DbDiffElement.$$$reportNull$$$0(3);
            }
            return "";
        }
        String name = this.getIdentifierMode().apply(value.getName());
        BasicElement parent2 = value.getParent();
        if (value instanceof DasColumn) {
            String string = this.getPath(parent2) + DbDiffElement.getSeparator() + name;
            if (string == null) {
                DbDiffElement.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (value instanceof DasTable) {
            String string = this.getPath(parent2) + name;
            if (string == null) {
                DbDiffElement.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = name.isEmpty() ? this.getPath(parent2) : name + DbDiffElement.getSeparator();
        if (string == null) {
            DbDiffElement.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String elementName = this.myElement.getName() + ":" + this.myElement.getKind().code();
        String string = this.getIdentifierMode().apply(elementName);
        if (string == null) {
            DbDiffElement.$$$reportNull$$$0(7);
        }
        return string;
    }

    public String getPresentableName() {
        String elementName = this.myElement.getName();
        if (StringUtil.isEmpty((String)elementName)) {
            if (this.myElement instanceof DasForeignKey) {
                elementName = "foreign key";
            } else if (this.myElement instanceof DasTableKey) {
                elementName = ((DasTableKey)this.myElement).isPrimary() ? "primary key" : "key";
            } else if (this.myElement instanceof DasIndex) {
                boolean unique = ((DasIndex)this.myElement).isUnique();
                elementName = unique ? "unique index" : "index";
            }
        }
        return this.getIdentifierMode().apply(elementName);
    }

    public long getSize() {
        return -1L;
    }

    public long getTimeStamp() {
        return -1L;
    }

    public FileType getFileType() {
        return SqlFileType.INSTANCE;
    }

    public boolean isContainer() {
        return !(this.myElement instanceof DasTableChild) && this.myElement.getKind() != ObjectKind.EXTENSION;
    }

    public DiffElement[] getChildren() {
        ArrayList list = ContainerUtil.newArrayList();
        for (Family<? extends BasicElement> family : this.myElement.getFamilies()) {
            ModFamily altF;
            Family family2 = altF = this.myAltElement == null ? null : this.myAltElement.familyOf(((ModFamily)family).getMetaObject().kind);
            if (altF != null) {
                altF.markChildrenAsSyncPending();
            }
            Iterator it = altF == null ? null : altF.iterator();
            for (BasicElement basicElement : family) {
                BasicModElement alt;
                if (basicElement instanceof BasicNamespace && !((BasicNamespace)basicElement).isVisible()) continue;
                if (it != null && !it.hasNext()) {
                    it = null;
                }
                BasicModElement basicModElement = altF == null ? null : (alt = it == null ? (BasicModElement)altF.createNewOne() : (BasicModElement)it.next());
                if (alt != null) {
                    alt.resetSyncPending();
                }
                list.add(new DbDiffElement(this.myRoot, basicElement, alt));
            }
            if (altF == null) continue;
            altF.removeSyncPendingChildren();
        }
        return list.isEmpty() ? EMPTY_ARRAY : list.toArray(DiffElement.EMPTY_ARRAY);
    }

    @NotNull
    public byte[] getContent() throws IOException {
        ScriptingSingleModelTaskBuilder builder = new ScriptingSingleModelTaskBuilder(this.myRoot.getModel(), ScriptCategory.CREATE_COMPLETE);
        builder.getElements().add(this.getValue());
        builder.setOptions(this.myRoot.createOptions());
        ScriptingResult result2 = ScriptGenerators.INSTANCE.makeScript(this.myRoot.getProject(), builder.build());
        CompositeText script = result2.getScript();
        byte[] byArray = script.getText().toString().getBytes(this.getCharset());
        if (byArray == null) {
            DbDiffElement.$$$reportNull$$$0(8);
        }
        return byArray;
    }

    @NotNull
    public DiffContent createDiffContent(@Nullable Project project, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
        if (indicator == null) {
            DbDiffElement.$$$reportNull$$$0(9);
        }
        DiffContent diffContent = (DiffContent)ApplicationManager.getApplication().runReadAction((ThrowableComputable)new ThrowableComputable<DiffContent, DiffRequestProducerException>(){

            public DiffContent compute() throws DiffRequestProducerException {
                try {
                    Project project = DbDiffElement.this.myRoot.getProject();
                    SqlLanguageDialect language = DbDiffElement.this.myRoot.getSqlLanguage();
                    PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project);
                    PsiFile psiFile = psiFileFactory.createFileFromText("a." + DbDiffElement.this.getFileType().getDefaultExtension(), (Language)language, (CharSequence)StringUtil.convertLineSeparators((String)new String(DbDiffElement.this.getContent(), DbDiffElement.this.getCharset())), false, true);
                    VirtualFile virtualFile = psiFile.getViewProvider().getVirtualFile();
                    if (virtualFile instanceof LightVirtualFile) {
                        ((LightVirtualFile)virtualFile).setWritable(false);
                    }
                    Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
                    assert (document != null);
                    DocumentContent content = DiffContentFactory.getInstance().create(project, document, virtualFile);
                    content.putUserData(DiffUserDataKeys.LANGUAGE, (Object)language);
                    return content;
                }
                catch (IOException e) {
                    throw new DiffRequestProducerException((Throwable)e);
                }
            }
        });
        if (diffContent == null) {
            DbDiffElement.$$$reportNull$$$0(10);
        }
        return diffContent;
    }

    @NotNull
    private Case getIdentifierMode() {
        Case case_ = this.isIgnoreCase() ? Case.LOWER : Case.MIXED;
        if (case_ == null) {
            DbDiffElement.$$$reportNull$$$0(11);
        }
        return case_;
    }

    @NotNull
    private Case getKeywordMode() {
        Case case_ = this.isIgnoreCase() ? Case.UPPER : Case.MIXED;
        if (case_ == null) {
            DbDiffElement.$$$reportNull$$$0(12);
        }
        return case_;
    }

    private boolean isIgnoreOrder() {
        return (Boolean)this.myRoot.getSettings().customSettings.get(IGNORE_ORDER);
    }

    private boolean isIgnoreCase() {
        return (Boolean)this.myRoot.getSettings().customSettings.get(IGNORE_CASE);
    }

    @NotNull
    public BasicElement getValue() {
        BasicElement basicElement = this.myElement;
        if (basicElement == null) {
            DbDiffElement.$$$reportNull$$$0(13);
        }
        return basicElement;
    }

    public Icon getIcon() {
        return DbPresentation.getIcon(this.getValue());
    }

    public boolean isOperationsEnabled() {
        return false;
    }

    @NotNull
    public Promise<DiffElement> copyToAsync(@NotNull DiffElement container, @Nullable DiffElement target, @NotNull String relativePath) {
        if (container == null) {
            DbDiffElement.$$$reportNull$$$0(14);
        }
        if (relativePath == null) {
            DbDiffElement.$$$reportNull$$$0(15);
        }
        throw new AssertionError();
    }

    @NotNull
    public Promise<Void> deleteAsync() {
        throw new AssertionError();
    }

    public String toString() {
        return "DbDiffElement{kind=" + this.myElement.getKind() + ", name=" + QNameUtil.getQualifiedName(this.myElement) + '}';
    }

    @Nullable
    public Boolean isContentEqual(@NotNull DiffElement other) {
        DbDiffElement e2;
        if (other == null) {
            DbDiffElement.$$$reportNull$$$0(16);
        }
        if ((e2 = (DbDiffElement)((Object)ObjectUtils.tryCast((Object)other, DbDiffElement.class))) == null) {
            return null;
        }
        if (this.myAltElement == null && e2.myAltElement == null) {
            return this.isEqual(this.getValue(), e2.getValue());
        }
        if (this.myAltElement == null || e2.myAltElement == null) {
            return null;
        }
        return this.isEqual((BasicElement)ObjectUtils.notNull((Object)this.myAltElement), e2.getValue()) && this.isEqual((BasicElement)ObjectUtils.notNull((Object)e2.myAltElement), this.getValue());
    }

    @Nullable
    public BasicModElement getAltElement() {
        return this.myAltElement;
    }

    private void fillAltElement(DbDiffElement other) {
        if (this.myAltElement == null) {
            return;
        }
        if (other != null) {
            DbDiffElement.assignElement(other.getValue(), this.myAltElement);
        }
        BasicMetaUtils.copyMatchedProperties(this.getValue(), this.myAltElement, other == null, true);
    }

    private void fillAltElementUpward(@NotNull DbDiffElement other) {
        if (other == null) {
            DbDiffElement.$$$reportNull$$$0(17);
        }
        if (this.myAltElement == null) {
            return;
        }
        BasicElement alt = this.myAltElement;
        for (BasicElement o = other.getValue(); alt != null && o != null; alt = alt.getParent(), o = o.getParent()) {
            DbDiffElement.assignElement(o, alt);
        }
    }

    public void prepare(@Nullable DiffElement<?> other) {
        DbDiffElement o = (DbDiffElement)((Object)ObjectUtils.tryCast(other, DbDiffElement.class));
        this.fillAltElement(o);
        if (o != null && this.myRoot.getRootElement() == this.getValue()) {
            this.fillAltElementUpward(o);
        }
    }

    public static void assignElement(@NotNull BasicElement from, BasicModElement to) {
        if (from == null) {
            DbDiffElement.$$$reportNull$$$0(18);
        }
        if (to == null) {
            return;
        }
        if (from.getMetaObject() != to.getMetaObject()) {
            BasicMetaUtils.copyMatchedProperties(from, to, true, true);
        } else {
            BasicMetaUtils.copyProperties(from, to, true);
        }
    }

    private boolean isEqual(@NotNull BasicElement o1, @NotNull BasicElement o2) {
        if (o1 == null) {
            DbDiffElement.$$$reportNull$$$0(19);
        }
        if (o2 == null) {
            DbDiffElement.$$$reportNull$$$0(20);
        }
        return ScriptGenerators.INSTANCE.byModel(this.myRoot.getModel()).isEqual(o1, o2, this.myRoot.createOptions());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/diff/DbDiffElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/diff/DbDiffElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffContent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifierMode";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywordMode";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDiffContent";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyToAsync";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isContentEqual";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "fillAltElementUpward";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "assignElement";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isEqual";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

