/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.ui.explorer;

import com.intellij.execution.impl.BaseExecuteBeforeRunDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.phing.PhingBuildTarget;
import com.jetbrains.php.phing.PhingBundle;
import com.jetbrains.php.phing.ui.explorer.PhingBeforeRunTask;
import com.jetbrains.php.phing.ui.explorer.PhingBeforeRunTaskProvider;

public class PhingExecuteBeforeRunDialog
extends BaseExecuteBeforeRunDialog<PhingBeforeRunTask> {
    private final PhingBuildTarget myTarget;

    public PhingExecuteBeforeRunDialog(Project project, PhingBuildTarget target) {
        super(project);
        this.myTarget = target;
        this.init();
    }

    protected String getTargetDisplayString() {
        return PhingBundle.message("phing.target", new Object[0]);
    }

    protected Key<PhingBeforeRunTask> getTaskID() {
        return PhingBeforeRunTaskProvider.ID;
    }

    protected boolean isRunning(PhingBeforeRunTask task) {
        return task.isRunningTarget(this.myTarget);
    }

    protected void update(PhingBeforeRunTask task) {
        VirtualFile f = this.myTarget.getContextFile();
        task.setPhingFileUrl(f != null ? f.getUrl() : null);
        task.setTargetName(f != null ? this.myTarget.getName() : null);
    }

    protected void clear(PhingBeforeRunTask task) {
        task.setPhingFileUrl(null);
        task.setTargetName(null);
    }
}

