/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.ui.explorer;

import com.intellij.execution.BeforeRunTask;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.phing.PhingBuildTarget;
import com.jetbrains.php.phing.ui.explorer.PhingBeforeRunTaskProvider;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhingBeforeRunTask
extends BeforeRunTask<PhingBeforeRunTask> {
    @NonNls
    private static final String PHING_FILE_ATTRIBUTE = "phingFile";
    @NonNls
    private static final String TARGET_ATTRIBUTE = "target";
    private String myTargetName;
    private String myPhingFileUrl;

    public PhingBeforeRunTask() {
        super(PhingBeforeRunTaskProvider.ID);
    }

    public String getPhingFileUrl() {
        return this.myPhingFileUrl;
    }

    public void setPhingFileUrl(@Nullable String url) {
        this.myPhingFileUrl = url;
    }

    public String getTargetName() {
        return this.myTargetName;
    }

    public void setTargetName(@Nullable String targetName) {
        this.myTargetName = targetName;
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            PhingBeforeRunTask.$$$reportNull$$$0(0);
        }
        super.writeExternal(element);
        if (this.myPhingFileUrl != null && this.myTargetName != null) {
            element.setAttribute(PHING_FILE_ATTRIBUTE, this.myPhingFileUrl);
            element.setAttribute(TARGET_ATTRIBUTE, this.myTargetName);
        }
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            PhingBeforeRunTask.$$$reportNull$$$0(1);
        }
        super.readExternal(element);
        String url = element.getAttributeValue(PHING_FILE_ATTRIBUTE);
        String targetName = element.getAttributeValue(TARGET_ATTRIBUTE);
        if (url != null && targetName != null) {
            this.myPhingFileUrl = url;
            this.myTargetName = targetName;
        }
    }

    public boolean isRunningTarget(PhingBuildTarget target) {
        VirtualFile vFile = target.getContextFile();
        if (vFile == null) {
            return false;
        }
        if (this.myPhingFileUrl == null || !FileUtil.pathsEqual((String)this.myPhingFileUrl, (String)vFile.getUrl())) {
            return false;
        }
        return Comparing.equal((String)this.myTargetName, (String)target.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PhingBeforeRunTask that = (PhingBeforeRunTask)((Object)o);
        if (this.myPhingFileUrl != null ? !this.myPhingFileUrl.equals(that.myPhingFileUrl) : that.myPhingFileUrl != null) {
            return false;
        }
        return !(this.myTargetName != null ? !this.myTargetName.equals(that.myTargetName) : that.myTargetName != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myTargetName != null ? this.myTargetName.hashCode() : 0);
        result = 31 * result + (this.myPhingFileUrl != null ? this.myPhingFileUrl.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/jetbrains/php/phing/ui/explorer/PhingBeforeRunTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

