/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.ui;

import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;

public interface Options {
    public static final Options ADD_ACTION = new Options(){

        @Override
        public boolean isToBeShown(Project project) {
            return CvsVcs2.getInstance(project).getAddOptions().getValue();
        }

        @Override
        public void setToBeShown(boolean value, Project project, boolean onOk) {
            CvsVcs2.getInstance(project).getAddOptions().setValue(value);
        }
    };
    public static final Options ON_FILE_ADDING = new Options(){

        @Override
        public boolean isToBeShown(Project project) {
            return CvsVcs2.getInstance(project).getAddConfirmation().getValue() == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION;
        }

        @Override
        public void setToBeShown(boolean value, Project project, boolean onOk) {
            CvsVcs2.getInstance(project).getAddConfirmation().setValue(CvsConfiguration.convertToEnumValue(value, onOk));
        }
    };
    public static final Options ON_FILE_REMOVING = new Options(){

        @Override
        public boolean isToBeShown(Project project) {
            return CvsVcs2.getInstance(project).getRemoveConfirmation().getValue() == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION;
        }

        @Override
        public void setToBeShown(boolean value, Project project, boolean onOk) {
            CvsVcs2.getInstance(project).getRemoveConfirmation().setValue(CvsConfiguration.convertToEnumValue(value, onOk));
        }
    };
    public static final Options REMOVE_ACTION = new Options(){

        @Override
        public boolean isToBeShown(Project project) {
            return CvsVcs2.getInstance(project).getRemoveOptions().getValue();
        }

        @Override
        public void setToBeShown(boolean value, Project project, boolean onOk) {
            CvsVcs2.getInstance(project).getRemoveOptions().setValue(value);
        }
    };
    public static final Options NULL = new Options(){

        @Override
        public boolean isToBeShown(Project project) {
            return true;
        }

        @Override
        public void setToBeShown(boolean value, Project project, boolean onOk) {
        }
    };

    public boolean isToBeShown(Project var1);

    public void setToBeShown(boolean var1, Project var2, boolean var3);
}

