/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.config;

import com.intellij.javascript.nodejs.util.JSLinterPackage;
import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.PathHolder;
import com.intellij.lang.javascript.linter.SharedConfigurationPaths;
import com.intellij.lang.javascript.linter.tslint.config.TsLintState;
import com.intellij.lang.javascript.linter.tslint.highlight.TsLintInspection;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="TsLintConfiguration", storages={@Storage(value="jsLinters/tslint.xml")})
public class TsLintConfiguration
extends JSLinterConfiguration<TsLintState> {
    private static final String TSLINT_ELEMENT_NAME = "tslint";
    private static final String IS_CUSTOM_CONFIG_FILE_USED_ATTRIBUTE_NAME = "use-custom-config-file";
    private static final String CUSTOM_CONFIG_FILE_PATH_ATTRIBUTE_NAME = "custom-config-file-path";
    private static final String RULES = "rules";
    private static final String ALLOW_JS = "allowJs";
    private final PathHolder myPathHolder;
    private final JSLinterPackage myPackage;
    private TsLintState DEFAULT_STATE;

    public TsLintConfiguration(@NotNull Project project, @NotNull SharedConfigurationPaths paths) {
        if (project == null) {
            TsLintConfiguration.$$$reportNull$$$0(0);
        }
        if (paths == null) {
            TsLintConfiguration.$$$reportNull$$$0(1);
        }
        super(project);
        this.myPathHolder = paths.createPathHolder(new Runnable(){

            @Override
            public void run() {
                ExtendedLinterState state = TsLintConfiguration.this.getExtendedState();
                ((TsLintState)state.getState()).setCustomConfigFilePath(TsLintConfiguration.this.myPathHolder.getPath());
                TsLintConfiguration.this.setExtendedState(state);
            }
        });
        this.myPackage = new JSLinterPackage(project, TSLINT_ELEMENT_NAME);
    }

    @NotNull
    public static TsLintConfiguration getInstance(@NotNull Project project) {
        if (project == null) {
            TsLintConfiguration.$$$reportNull$$$0(2);
        }
        TsLintConfiguration tsLintConfiguration = (TsLintConfiguration)JSLinterConfiguration.getInstance((Project)project, TsLintConfiguration.class);
        if (tsLintConfiguration == null) {
            TsLintConfiguration.$$$reportNull$$$0(3);
        }
        return tsLintConfiguration;
    }

    protected void savePrivateSettings(@NotNull TsLintState state) {
        if (state == null) {
            TsLintConfiguration.$$$reportNull$$$0(4);
        }
        this.myPathHolder.setPath(StringUtil.notNullize((String)state.getCustomConfigFilePath()));
        this.storeLinterLocalPaths(state);
    }

    @NotNull
    protected TsLintState loadPrivateSettings(@NotNull TsLintState state) {
        if (state == null) {
            TsLintConfiguration.$$$reportNull$$$0(5);
        }
        this.myPathHolder.setPath(StringUtil.notNullize((String)state.getCustomConfigFilePath()));
        TsLintState.Builder builder = new TsLintState.Builder(state);
        this.restoreLinterLocalPaths(builder);
        TsLintState tsLintState = builder.build();
        if (tsLintState == null) {
            TsLintConfiguration.$$$reportNull$$$0(6);
        }
        return tsLintState;
    }

    public boolean isAllowJs() {
        return ((TsLintState)this.getMyStateWithoutPrivateSettings()).isAllowJs();
    }

    @NotNull
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        if (TsLintInspection.class == null) {
            TsLintConfiguration.$$$reportNull$$$0(7);
        }
        return TsLintInspection.class;
    }

    @Nullable
    protected Element toXml(@NotNull TsLintState state) {
        String rulesDirectory;
        String customConfigFilePath;
        if (state == null) {
            TsLintConfiguration.$$$reportNull$$$0(8);
        }
        Element root = new Element(TSLINT_ELEMENT_NAME);
        if (state.isCustomConfigFileUsed()) {
            root.setAttribute(IS_CUSTOM_CONFIG_FILE_USED_ATTRIBUTE_NAME, Boolean.TRUE.toString());
        }
        if (!StringUtil.isEmptyOrSpaces((String)(customConfigFilePath = state.getCustomConfigFilePath()))) {
            root.setAttribute(CUSTOM_CONFIG_FILE_PATH_ATTRIBUTE_NAME, FileUtil.toSystemIndependentName((String)customConfigFilePath));
        }
        if (!StringUtil.isEmptyOrSpaces((String)(rulesDirectory = state.getRulesDirectory()))) {
            root.setAttribute(RULES, FileUtil.toSystemIndependentName((String)rulesDirectory));
        }
        if (state.isAllowJs()) {
            root.setAttribute(ALLOW_JS, String.valueOf(true));
        }
        this.storeLinterLocalPaths(state);
        return root;
    }

    @NotNull
    protected TsLintState fromXml(@NotNull Element element) {
        if (element == null) {
            TsLintConfiguration.$$$reportNull$$$0(9);
        }
        TsLintState.Builder builder = new TsLintState.Builder();
        builder.setCustomConfigFileUsed(Boolean.parseBoolean(element.getAttributeValue(IS_CUSTOM_CONFIG_FILE_USED_ATTRIBUTE_NAME)));
        String customConfigFilePath = StringUtil.notNullize((String)element.getAttributeValue(CUSTOM_CONFIG_FILE_PATH_ATTRIBUTE_NAME));
        builder.setCustomConfigFilePath(FileUtil.toSystemDependentName((String)customConfigFilePath));
        String rulesDirectory = element.getAttributeValue(RULES);
        if (!StringUtil.isEmptyOrSpaces((String)rulesDirectory)) {
            builder.setRulesDirectory(rulesDirectory);
        }
        builder.setAllowJs(Boolean.parseBoolean(element.getAttributeValue(ALLOW_JS)));
        this.restoreLinterLocalPaths(builder);
        TsLintState tsLintState = builder.build();
        if (tsLintState == null) {
            TsLintConfiguration.$$$reportNull$$$0(10);
        }
        return tsLintState;
    }

    private void restoreLinterLocalPaths(TsLintState.Builder builder) {
        this.myPackage.readOrDetect();
        builder.setNodePath(this.myPackage.getInterpreter());
        builder.setPackagePath(StringUtil.notNullize((String)this.myPackage.getPackagePath()));
    }

    private void storeLinterLocalPaths(TsLintState state) {
        this.myPackage.force(state.getInterpreterRef(), state.getPackagePath());
    }

    @NotNull
    protected TsLintState getDefaultState() {
        TsLintState state = this.DEFAULT_STATE;
        if (state != null) {
            TsLintState tsLintState = state;
            if (tsLintState == null) {
                TsLintConfiguration.$$$reportNull$$$0(11);
            }
            return tsLintState;
        }
        TsLintState.Builder builder = new TsLintState.Builder();
        builder.setCustomConfigFileUsed(false);
        this.DEFAULT_STATE = state = builder.build();
        TsLintState tsLintState = state;
        if (tsLintState == null) {
            TsLintConfiguration.$$$reportNull$$$0(12);
        }
        return tsLintState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/tslint/config/TsLintConfiguration";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/tslint/config/TsLintConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPrivateSettings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionClass";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "fromXml";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "savePrivateSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadPrivateSettings";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toXml";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fromXml";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

