/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.view;

import com.intellij.openapi.util.Pair;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.Predicate;
import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.calculation.CallTreeType;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLine;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import com.jetbrains.nodejs.run.profile.cpu.view.FilteredByPercent;
import com.jetbrains.nodejs.run.profile.cpu.view.LineColorProvider;
import com.jetbrains.nodejs.run.profile.cpu.view.TreeTableModelWithCustomRenderer;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ColumnForNumbers;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfileLineTreeCellRenderer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8TreeTableModel
implements FilteredByPercent,
TreeTableModelWithCustomRenderer {
    public static final int SELF_THRESHOLD = 100;
    public static final int TOTAL_THRESHOLD = 100;
    private final V8ProfileLine myRoot;
    @NotNull
    private final CallTreeType myCallTreeType;
    private final ColumnInfo[] myColumns;
    private final V8ProfileLineTreeCellRenderer<V8ProfileLine> myZeroCellRenderer;
    private V8ProfileLine myFiltered;
    private int myTensPercentLevelInclusive;

    private static List<ColumnInfo> createBottomUpColumns(@NotNull Processor<V8ProfileLine> processor, @NotNull V8ProfileLineTreeCellRenderer renderer) {
        if (processor == null) {
            V8TreeTableModel.$$$reportNull$$$0(0);
        }
        if (renderer == null) {
            V8TreeTableModel.$$$reportNull$$$0(1);
        }
        ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
        list.add(new V8ProfileLineV8ProfileLineColumnInfo(renderer));
        V8ColumnForNumbers<V8ProfileLine> ticks = new V8ColumnForNumbers<V8ProfileLine>("Ticks", processor){

            @Nullable
            public String valueOf(V8ProfileLine line) {
                return String.valueOf(line.getTotalTicks());
            }
        };
        V8ColumnForNumbers<V8ProfileLine> ofParent = new V8ColumnForNumbers<V8ProfileLine>("of parent", processor){

            @Nullable
            public String valueOf(V8ProfileLine line) {
                return V8Utils.formatPercent(line.getTotalTensPercent());
            }
        };
        list.add(ticks);
        list.add(ofParent);
        return list;
    }

    private static List<ColumnInfo> createTopDownColumns(@NotNull Processor<V8ProfileLine> processor, @NotNull V8ProfileLineTreeCellRenderer renderer) {
        if (processor == null) {
            V8TreeTableModel.$$$reportNull$$$0(2);
        }
        if (renderer == null) {
            V8TreeTableModel.$$$reportNull$$$0(3);
        }
        ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
        list.add(new V8ProfileLineV8ProfileLineColumnInfo(renderer));
        V8ColumnForNumbers<V8ProfileLine> totalPercent = new V8ColumnForNumbers<V8ProfileLine>("Total %", processor){

            @Nullable
            public String valueOf(V8ProfileLine line) {
                return V8Utils.formatPercent(line.getTotalTensPercent());
            }
        };
        V8ColumnForNumbers<V8ProfileLine> self = new V8ColumnForNumbers<V8ProfileLine>("Self %", processor){

            @Nullable
            public String valueOf(V8ProfileLine line) {
                return V8Utils.formatPercent(line.getSelfTensPercent());
            }
        };
        V8ColumnForNumbers<V8ProfileLine> total = new V8ColumnForNumbers<V8ProfileLine>("Total", processor){

            @Nullable
            public String valueOf(V8ProfileLine line) {
                return String.valueOf(line.getTotalTicks());
            }
        };
        V8ColumnForNumbers<V8ProfileLine> selfTicks = new V8ColumnForNumbers<V8ProfileLine>("Self", processor){

            @Nullable
            public String valueOf(V8ProfileLine line) {
                return String.valueOf(line.getSelfTicks());
            }
        };
        list.add(total);
        list.add(totalPercent);
        list.add(selfTicks);
        list.add(self);
        return list;
    }

    public V8TreeTableModel(@NotNull V8ProfileLine root, @NotNull CallTreeType callTreeType, @NotNull LineColorProvider fileColors) {
        if (root == null) {
            V8TreeTableModel.$$$reportNull$$$0(4);
        }
        if (callTreeType == null) {
            V8TreeTableModel.$$$reportNull$$$0(5);
        }
        if (fileColors == null) {
            V8TreeTableModel.$$$reportNull$$$0(6);
        }
        this.myTensPercentLevelInclusive = 0;
        this.myRoot = root;
        this.myCallTreeType = callTreeType;
        Processor processor = value -> V8TreeTableModel.v8LineIsAboveThresholds(value) && (CallTreeType.topDown.equals((Object)this.myCallTreeType) || value.getParent() != null && value.getParent().getParent() == null);
        this.myZeroCellRenderer = new V8ProfileLineTreeCellRenderer<V8ProfileLine>(processor, fileColors){

            @Override
            protected V8CpuLogCall getCall(Object object) {
                if (!(object instanceof V8ProfileLine)) {
                    return null;
                }
                return ((V8ProfileLine)object).getCall();
            }
        };
        List<ColumnInfo> listColumns = CallTreeType.bottomUp.equals((Object)callTreeType) ? V8TreeTableModel.createBottomUpColumns((Processor<V8ProfileLine>)processor, this.myZeroCellRenderer) : V8TreeTableModel.createTopDownColumns((Processor<V8ProfileLine>)processor, this.myZeroCellRenderer);
        this.myColumns = listColumns.toArray(ColumnInfo.EMPTY_ARRAY);
    }

    public V8ProfileLineTreeCellRenderer getZeroCellRenderer() {
        return this.myZeroCellRenderer;
    }

    @Override
    public boolean isFiltered() {
        return this.myFiltered != null;
    }

    @Override
    public int getTensPercentLevelInclusive() {
        return this.myTensPercentLevelInclusive;
    }

    @Override
    public void clearFilter() {
        this.myTensPercentLevelInclusive = 0;
        this.myFiltered = null;
    }

    @Override
    public void filterByLevel(int tensPercentLevelInclusive) {
        this.myTensPercentLevelInclusive = tensPercentLevelInclusive;
        Predicate predicate = input -> input.getTotalTensPercent() >= tensPercentLevelInclusive;
        this.myFiltered = new V8ProfileLine(-1, -1, -1, -1, null, 0, "", -1L);
        ArrayDeque<Pair> queue = new ArrayDeque<Pair>();
        for (V8ProfileLine line : this.myRoot.getChildren()) {
            if (!predicate.apply((Object)line)) continue;
            queue.add(Pair.create((Object)this.myFiltered, (Object)line));
        }
        while (!queue.isEmpty()) {
            Pair pair = (Pair)queue.removeFirst();
            if (!predicate.apply(pair.getSecond())) continue;
            V8ProfileLine copy = ((V8ProfileLine)pair.getSecond()).cloneWithoutChildren((V8ProfileLine)pair.getFirst());
            List<V8ProfileLine> children = ((V8ProfileLine)pair.getSecond()).getChildren();
            for (V8ProfileLine child : children) {
                queue.add(Pair.create((Object)copy, (Object)child));
            }
        }
    }

    public List<V8ProfileLine> search(@NotNull String s, boolean caseSensitive) {
        if (s == null) {
            V8TreeTableModel.$$$reportNull$$$0(7);
        }
        ArrayList<V8ProfileLine> list = new ArrayList<V8ProfileLine>();
        ArrayDeque<V8ProfileLine> queue = new ArrayDeque<V8ProfileLine>();
        queue.add(this.myRoot);
        while (!queue.isEmpty()) {
            boolean matches;
            V8ProfileLine line = (V8ProfileLine)queue.removeFirst();
            String presentation = line.getPresentation(false);
            boolean bl = matches = caseSensitive ? presentation.contains(s) : presentation.toLowerCase().contains(s.toLowerCase());
            if (matches) {
                list.add(line);
            }
            queue.addAll(line.getChildren());
        }
        return list;
    }

    public int getColumnCount() {
        return this.myColumns.length;
    }

    public String getColumnName(int column) {
        return this.myColumns[column].getName();
    }

    @Override
    public TableCellRenderer getCustomizedRenderer(int column, Object o, TableCellRenderer renderer) {
        return this.myColumns[column].getCustomizedRenderer(o, renderer);
    }

    public Class getColumnClass(int column) {
        return column == 0 ? TreeTableModel.class : String.class;
    }

    public Object getValueAt(Object node, int column) {
        return this.myColumns[column].valueOf(node);
    }

    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    public void setValueAt(Object aValue, Object node, int column) {
        throw new UnsupportedOperationException();
    }

    public void setTree(JTree tree) {
    }

    public Object getRoot() {
        return this.myFiltered != null ? this.myFiltered : this.myRoot;
    }

    public Object getChild(Object parent, int index) {
        return ((V8ProfileLine)parent).getChildren().get(index);
    }

    public int getChildCount(Object parent) {
        return ((V8ProfileLine)parent).getChildren().size();
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        List<V8ProfileLine> children = ((V8ProfileLine)parent).getChildren();
        for (int i = 0; i < children.size(); ++i) {
            V8ProfileLine current = children.get(i);
            if (!child.equals(current)) continue;
            return i;
        }
        return 0;
    }

    public void addTreeModelListener(TreeModelListener l) {
    }

    public void removeTreeModelListener(TreeModelListener l) {
    }

    @Nullable
    public TreePath createSelectionPathForStackTrace(@NotNull List<Long> stack) {
        List<Object> nodesList;
        if (stack == null) {
            V8TreeTableModel.$$$reportNull$$$0(8);
        }
        if ((nodesList = V8TreeTableModel.findPath(stack, (V8ProfileLine)this.getRoot())).size() <= stack.size() && this.myFiltered != null && (nodesList = V8TreeTableModel.findPath(stack, this.myRoot)).size() > 1) {
            this.clearFilter();
        }
        if (nodesList.size() == 1) {
            return null;
        }
        return new TreePath(ArrayUtil.toObjectArray(nodesList));
    }

    @NotNull
    private static List<Object> findPath(@NotNull List<Long> stack, V8ProfileLine root) {
        if (stack == null) {
            V8TreeTableModel.$$$reportNull$$$0(9);
        }
        ArrayList<Object> nodesList = new ArrayList<Object>();
        V8ProfileLine line = root;
        nodesList.add(line);
        for (Long stringId : stack) {
            List<V8ProfileLine> children = line.getChildren();
            V8ProfileLine found = null;
            for (V8ProfileLine child : children) {
                if (child.getCall().getStringId() != stringId.longValue()) continue;
                line = found = child;
                break;
            }
            if (found == null) break;
            nodesList.add(found);
        }
        ArrayList<Object> arrayList = nodesList;
        if (arrayList == null) {
            V8TreeTableModel.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    static boolean v8LineIsAboveThresholds(V8ProfileLine line) {
        return line.getSelfTensPercent() >= 100 || line.getTotalTensPercent() >= 100;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callTreeType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileColors";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stack";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/cpu/view/V8TreeTableModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/view/V8TreeTableModel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createBottomUpColumns";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTopDownColumns";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "search";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createSelectionPathForStackTrace";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findPath";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class V8ProfileLineV8ProfileLineColumnInfo
    extends ColumnInfo<V8ProfileLine, V8ProfileLine> {
        private final ColoredTreeCellRenderer myRenderer;

        public V8ProfileLineV8ProfileLineColumnInfo(@NotNull V8ProfileLineTreeCellRenderer renderer) {
            if (renderer == null) {
                V8ProfileLineV8ProfileLineColumnInfo.$$$reportNull$$$0(0);
            }
            super("Calls");
            this.myRenderer = renderer;
        }

        @Nullable
        public V8ProfileLine valueOf(V8ProfileLine line) {
            return line;
        }

        public TableCellRenderer getCustomizedRenderer(V8ProfileLine line, TableCellRenderer renderer) {
            if (renderer instanceof TreeTableCellRenderer) {
                ((TreeTableCellRenderer)renderer).setCellRenderer((TreeCellRenderer)this.myRenderer);
            }
            return renderer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/jetbrains/nodejs/run/profile/cpu/view/V8TreeTableModel$V8ProfileLineV8ProfileLineColumnInfo", "<init>"));
        }
    }
}

