/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.diff;

import com.jetbrains.nodejs.run.profile.cpu.CallHolder;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class DiffNode
implements CallHolder {
    private final V8CpuLogCall myCall;
    @Nullable
    private final Ticks myBefore;
    @Nullable
    private final Ticks myAfter;
    private final List<DiffNode> myChildren;

    public DiffNode(V8CpuLogCall call, @Nullable Ticks before, @Nullable Ticks after) {
        this.myCall = call;
        this.myBefore = before;
        this.myAfter = after;
        this.myChildren = new ArrayList<DiffNode>();
    }

    public boolean isAdded() {
        return this.myBefore == null;
    }

    public boolean isDeleted() {
        return this.myAfter == null;
    }

    public void addChild(DiffNode child) {
        this.myChildren.add(child);
    }

    @Override
    public V8CpuLogCall getCall() {
        return this.myCall;
    }

    @Nullable
    public Ticks getBefore() {
        return this.myBefore;
    }

    @Nullable
    public Ticks getAfter() {
        return this.myAfter;
    }

    public List<DiffNode> getChildren() {
        return this.myChildren;
    }

    public String toString() {
        return this.myCall.getPresentation();
    }

    public static class Ticks {
        private final int myTotal;
        private final int mySelf;
        private int myNumParentTicks;

        public Ticks(int total, int self) {
            this.myTotal = total;
            this.mySelf = self;
        }

        public int getTotal() {
            return this.myTotal;
        }

        public int getSelf() {
            return this.mySelf;
        }

        public int getNumParentTicks() {
            return this.myNumParentTicks;
        }

        public void setNumParentTicks(int numParentTicks) {
            this.myNumParentTicks = numParentTicks;
        }
    }
}

