/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.roots.VcsRootProblemNotifier;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Alarm;
import com.intellij.vfs.AsyncVfsEventsListener;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class VcsRootScanner
implements AsyncVfsEventsListener {
    @NotNull
    private final VcsRootProblemNotifier myRootProblemNotifier;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectRootManager myProjectManager;
    @NotNull
    private final List<VcsRootChecker> myCheckers;
    @NotNull
    private final Alarm myAlarm;
    private static final long WAIT_BEFORE_SCAN = TimeUnit.SECONDS.toMillis(1L);

    public static void start(@NotNull Project project, @NotNull List<VcsRootChecker> checkers) {
        if (project == null) {
            VcsRootScanner.$$$reportNull$$$0(0);
        }
        if (checkers == null) {
            VcsRootScanner.$$$reportNull$$$0(1);
        }
        new VcsRootScanner(project, checkers).scheduleScan();
    }

    private VcsRootScanner(@NotNull Project project, @NotNull List<VcsRootChecker> checkers) {
        if (project == null) {
            VcsRootScanner.$$$reportNull$$$0(2);
        }
        if (checkers == null) {
            VcsRootScanner.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myProjectManager = ProjectRootManager.getInstance((Project)project);
        this.myRootProblemNotifier = VcsRootProblemNotifier.getInstance(project);
        this.myCheckers = checkers;
        AsyncVfsEventsPostProcessor.getInstance().addListener((AsyncVfsEventsListener)this, (Disposable)project);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project);
    }

    public void filesChanged(@NotNull List<VFileEvent> events) {
        if (events == null) {
            VcsRootScanner.$$$reportNull$$$0(4);
        }
        for (VFileEvent event : events) {
            VirtualFile file2 = event.getFile();
            if (file2 == null || !file2.isDirectory()) continue;
            VcsRootScanner.visitDirsRecursivelyWithoutExcluded(this.myProject, this.myProjectManager, file2, dir -> {
                if (this.isVcsDir(dir.getName())) {
                    this.scheduleScan();
                    return VirtualFileVisitor.skipTo((VirtualFile)file2);
                }
                return VirtualFileVisitor.CONTINUE;
            });
        }
    }

    static void visitDirsRecursivelyWithoutExcluded(final @NotNull Project project, @NotNull ProjectRootManager projectRootManager, @NotNull VirtualFile root, final @NotNull Function<? super VirtualFile, ? extends VirtualFileVisitor.Result> dirFound) {
        if (project == null) {
            VcsRootScanner.$$$reportNull$$$0(5);
        }
        if (projectRootManager == null) {
            VcsRootScanner.$$$reportNull$$$0(6);
        }
        if (root == null) {
            VcsRootScanner.$$$reportNull$$$0(7);
        }
        if (dirFound == null) {
            VcsRootScanner.$$$reportNull$$$0(8);
        }
        final ProjectFileIndex fileIndex = projectRootManager.getFileIndex();
        VirtualFileVisitor.Option depthLimit = VirtualFileVisitor.limit((int)Registry.intValue((String)"vcs.root.detector.folder.depth"));
        VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS, depthLimit}){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                if (!file2.isDirectory()) {
                    VirtualFileVisitor.Result result2 = CONTINUE;
                    if (result2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return result2;
                }
                VirtualFileVisitor.Result result3 = (VirtualFileVisitor.Result)dirFound.apply(file2);
                if (result3 != CONTINUE) {
                    VirtualFileVisitor.Result result4 = result3;
                    if (result4 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return result4;
                }
                if (((Boolean)ReadAction.compute(() -> {
                    if (project == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    if (file2 == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    return project.isDisposed() || !file2.equals(project.getBaseDir()) && !fileIndex.isInContent(file2);
                })).booleanValue()) {
                    VirtualFileVisitor.Result result5 = SKIP_CHILDREN;
                    if (result5 == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return result5;
                }
                VirtualFileVisitor.Result result6 = CONTINUE;
                if (result6 == null) {
                    1.$$$reportNull$$$0(4);
                }
                return result6;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/roots/VcsRootScanner$1";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/roots/VcsRootScanner$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$visitFileEx$0";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private boolean isVcsDir(@NotNull String filePath) {
        if (filePath == null) {
            VcsRootScanner.$$$reportNull$$$0(9);
        }
        return this.myCheckers.stream().anyMatch(it -> {
            if (filePath == null) {
                VcsRootScanner.$$$reportNull$$$0(10);
            }
            return it.isVcsDir(filePath);
        });
    }

    private void scheduleScan() {
        if (this.myAlarm.isDisposed()) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.myAlarm, () -> this.myRootProblemNotifier.rescanAndNotifyIfNeeded()), WAIT_BEFORE_SCAN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkers";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirFound";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/roots/VcsRootScanner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "start";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "filesChanged";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDirsRecursivelyWithoutExcluded";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isVcsDir";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$isVcsDir$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

