/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesPreprocess;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.WaitForProgressToShow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class RevertCommittedStuffAbstractAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.actions.RevertCommittedStuffAbstractAction");

    RevertCommittedStuffAbstractAction() {
    }

    @Nullable
    protected abstract Change[] getChanges(@NotNull AnActionEvent var1, boolean var2);

    public void actionPerformed(@NotNull AnActionEvent e) {
        ChangeListChooser chooser;
        if (e == null) {
            RevertCommittedStuffAbstractAction.$$$reportNull$$$0(0);
        }
        final Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        final VirtualFile baseDir = project.getBaseDir();
        assert (baseDir != null);
        Change[] changes2 = this.getChanges(e, false);
        if (changes2 == null || changes2.length == 0) {
            return;
        }
        final ArrayList changesList = new ArrayList();
        Collections.addAll(changesList, changes2);
        FileDocumentManager.getInstance().saveAllDocuments();
        String defaultName = null;
        ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        if (changeLists != null && changeLists.length > 0) {
            defaultName = VcsBundle.message((String)"revert.changes.default.name", (Object[])new Object[]{changeLists[0].getName()});
        }
        if (!(chooser = new ChangeListChooser(project, ChangeListManager.getInstance((Project)project).getChangeListsCopy(), null, "Select Target Changelist", defaultName)).showAndGet()) {
            return;
        }
        final ArrayList patches2 = new ArrayList();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, VcsBundle.message((String)"revert.changes.title", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    List<Change> preprocessed = ChangesPreprocess.preprocessChangesRemoveDeletedForDuplicateMoved(changesList);
                    patches2.addAll(IdeaTextPatchBuilder.buildPatch(project, preprocessed, baseDir.getPresentableUrl(), true));
                }
                catch (VcsException ex) {
                    WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((Project)project, (String)("Failed to revert changes: " + ex.getMessage()), (String)VcsBundle.message((String)"revert.changes.title", (Object[])new Object[0])), null, (Project)this.myProject);
                    indicator.cancel();
                }
            }

            public void onSuccess() {
                new PatchApplier(project, baseDir, patches2, chooser.getSelectedList(), null).execute();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/actions/RevertCommittedStuffAbstractAction$1", "run"));
            }
        });
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RevertCommittedStuffAbstractAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(this.isEnabled(e));
    }

    protected boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            RevertCommittedStuffAbstractAction.$$$reportNull$$$0(2);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Change[] changes2 = this.getChanges(e, true);
        return project != null && changes2 != null && changes2.length > 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/RevertCommittedStuffAbstractAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

