/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.internal.statistic.eventLog.EventLogExternalSettingsService;
import com.intellij.internal.statistic.service.fus.beans.FSContent;
import com.intellij.internal.statistic.service.fus.beans.FSSession;
import com.intellij.internal.statistic.service.fus.collectors.FUStatisticsAggregator;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FUStatisticsPersistence {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.internal.statistic.service.fus.collectors.FUStatisticsPersistence");
    private static final String FILE_EXTENSION = "json";
    private static final String LEGACY_PERSISTENCE_STATE_FILE = "fus-previous-state.data";
    private static final String PERSISTENCE_STATE_FILE = "fus-state.data";
    private static final String SENT_DATA_FILE = "fus-sent-data.json";
    public static final String FUS_CACHE_PATH = "fus-sessions";

    public static void persistProjectUsages(@NotNull Project project) {
        if (project == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(0);
        }
        FUStatisticsPersistence.recordProjectUsages(project);
    }

    private static void recordProjectUsages(@NotNull Project project) {
        Set<String> groups;
        if (project == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(1);
        }
        if (!(groups = EventLogExternalSettingsService.getInstance().getApprovedGroups()).isEmpty() || ApplicationManagerEx.getApplicationEx().isInternal()) {
            FUStatisticsAggregator.create(true).getProjectUsages(project, groups);
        }
    }

    @NotNull
    public static Set<FSSession> getPersistedSessions() {
        File[] children2;
        HashSet persistedSessions = ContainerUtil.newHashSet();
        File statisticsCacheDir = FUStatisticsPersistence.getStatisticsCacheDirectory();
        if (statisticsCacheDir != null && (children2 = statisticsCacheDir.listFiles()) != null) {
            for (File child2 : children2) {
                if (PERSISTENCE_STATE_FILE.equals(child2.getName()) || SENT_DATA_FILE.equals(child2.getName()) || !FUStatisticsPersistence.isSessionCacheName(child2.getName())) continue;
                try {
                    FUStatisticsPersistence.mergeContent(persistedSessions, FileUtil.loadFile((File)child2));
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
        HashSet hashSet = persistedSessions;
        if (hashSet == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    public static void clearSessionPersistence(long dataTime) {
        File[] children2;
        File statisticsCacheDir = FUStatisticsPersistence.getStatisticsCacheDirectory();
        if (statisticsCacheDir != null && (children2 = statisticsCacheDir.listFiles()) != null) {
            for (File child2 : children2) {
                if (PERSISTENCE_STATE_FILE.equals(child2.getName()) || SENT_DATA_FILE.equals(child2.getName())) continue;
                try {
                    BasicFileAttributes attr = Files.readAttributes(child2.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    if (dataTime <= attr.creationTime().toMillis()) continue;
                    child2.delete();
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
    }

    public static void clearLegacyStates() {
        FUStatisticsPersistence.deleteCaches(FUStatisticsPersistence.getSentDataFile());
        FUStatisticsPersistence.deleteCaches(FUStatisticsPersistence.getLegacyStateFile());
        FUStatisticsPersistence.deleteCaches(FUStatisticsPersistence.getPersistenceStateFile());
        FUStatisticsPersistence.deleteCaches(FUStatisticsPersistence.getStatisticsCacheDirectory());
        FUStatisticsPersistence.deleteCaches(FUStatisticsPersistence.getStatisticsLegacyCacheDirectory());
    }

    private static void deleteCaches(@Nullable File dir) {
        if (dir != null && dir.exists()) {
            try {
                boolean delete = FileUtil.delete((File)dir);
                if (!delete) {
                    LOG.info("Failed deleting legacy caches");
                }
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
        }
    }

    @Nullable
    public static File getStatisticsCacheDirectory() {
        return Paths.get(PathManager.getConfigPath(), new String[0]).resolve("fus-sessions/").toFile();
    }

    @Nullable
    public static File getStatisticsLegacyCacheDirectory() {
        return Paths.get(PathManager.getSystemPath(), new String[0]).resolve(FUS_CACHE_PATH).toFile();
    }

    private static void mergeContent(@NotNull Set<FSSession> allSessions, @Nullable String content) {
        if (allSessions == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmptyOrSpaces((String)content)) {
            return;
        }
        try {
            FSContent sessionContent = FSContent.fromJson(content);
            if (sessionContent == null) {
                return;
            }
            Set<FSSession> sessions = sessionContent.getSessions();
            if (sessions != null) {
                allSessions.addAll(sessions);
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
    }

    @NotNull
    public static File getPersistenceStateFile() {
        File file2 = FUStatisticsPersistence.getFileInStatisticsCacheDirectory(PERSISTENCE_STATE_FILE);
        if (file2 == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(4);
        }
        return file2;
    }

    @NotNull
    private static File getLegacyStateFile() {
        File file2 = FUStatisticsPersistence.getFileInStatisticsCacheDirectory(LEGACY_PERSISTENCE_STATE_FILE);
        if (file2 == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(5);
        }
        return file2;
    }

    @NotNull
    private static File getFileInStatisticsCacheDirectory(@NotNull String fileName) {
        if (fileName == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(6);
        }
        File file2 = new File(FUStatisticsPersistence.getStatisticsCacheDirectory(), "/" + fileName);
        if (file2 == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(7);
        }
        return file2;
    }

    @NotNull
    public static File getSentDataFile() {
        File file2 = FUStatisticsPersistence.getFileInStatisticsCacheDirectory(SENT_DATA_FILE);
        if (file2 == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(8);
        }
        return file2;
    }

    @Nullable
    public static String getPreviousStateContent() {
        return FUStatisticsPersistence.getStateContent(PERSISTENCE_STATE_FILE);
    }

    @Nullable
    public static String getLegacyStateContent() {
        return FUStatisticsPersistence.getStateContent(LEGACY_PERSISTENCE_STATE_FILE);
    }

    @Nullable
    private static String getStateContent(@NotNull String fileName) {
        if (fileName == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(9);
        }
        return null;
    }

    private static boolean isSessionCacheName(@NotNull String fileName) {
        if (fileName == null) {
            FUStatisticsPersistence.$$$reportNull$$$0(10);
        }
        return FILE_EXTENSION.equals(FileUtilRt.getExtension((String)fileName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/service/fus/collectors/FUStatisticsPersistence";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allSessions";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/service/fus/collectors/FUStatisticsPersistence";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistedSessions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceStateFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLegacyStateFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileInStatisticsCacheDirectory";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSentDataFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "persistProjectUsages";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "recordProjectUsages";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mergeContent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFileInStatisticsCacheDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getStateContent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isSessionCacheName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

