/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.errorTreeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.OccurenceNavigatorSupport;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.ide.actions.ExportToTextFileToolbarAction;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorTreeNodeDescriptor;
import com.intellij.ide.errorTreeView.ErrorViewStructure;
import com.intellij.ide.errorTreeView.ErrorViewTreeBuilder;
import com.intellij.ide.errorTreeView.HotfixData;
import com.intellij.ide.errorTreeView.NavigatableErrorTreeElement;
import com.intellij.ide.errorTreeView.NewErrorTreeRenderer;
import com.intellij.ide.errorTreeView.SimpleErrorData;
import com.intellij.ide.errorTreeView.impl.ErrorTreeViewConfiguration;
import com.intellij.ide.errorTreeView.impl.ErrorViewTextExporter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.MessageView;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MutableErrorTreeView;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewErrorTreeViewPanel
extends JPanel
implements DataProvider,
OccurenceNavigator,
MutableErrorTreeView,
CopyProvider {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.errorTreeView.NewErrorTreeViewPanel");
    private volatile String myProgressText = "";
    private volatile float myFraction;
    private final boolean myCreateExitAction;
    private final ErrorViewStructure myErrorViewStructure;
    private final ErrorViewTreeBuilder myBuilder;
    private final Alarm myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private volatile boolean myIsDisposed;
    private final ErrorTreeViewConfiguration myConfiguration;
    private ActionToolbar myLeftToolbar;
    private final TreeExpander myTreeExpander = new MyTreeExpander();
    private final ExporterToTextFile myExporterToTextFile;
    protected Project myProject;
    private final String myHelpId;
    protected Tree myTree;
    private final JPanel myMessagePanel;
    private ProcessController myProcessController;
    private JLabel myProgressLabel;
    private JPanel myProgressPanel;
    private final AutoScrollToSourceHandler myAutoScrollToSourceHandler;
    private final MyOccurrenceNavigatorSupport myOccurrenceNavigatorSupport;

    public NewErrorTreeViewPanel(Project project, String helpId) {
        this(project, helpId, true);
    }

    public NewErrorTreeViewPanel(Project project, String helpId, boolean createExitAction) {
        this(project, helpId, createExitAction, true);
    }

    public NewErrorTreeViewPanel(Project project, String helpId, boolean createExitAction, boolean createToolbar) {
        this(project, helpId, createExitAction, createToolbar, null);
    }

    public NewErrorTreeViewPanel(Project project, String helpId, boolean createExitAction, boolean createToolbar, @Nullable Runnable rerunAction) {
        this.myProject = project;
        this.myHelpId = helpId;
        this.myCreateExitAction = createExitAction;
        this.myConfiguration = ErrorTreeViewConfiguration.getInstance(project);
        this.setLayout(new BorderLayout());
        this.myAutoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return NewErrorTreeViewPanel.this.myConfiguration.isAutoscrollToSource();
            }

            protected void setAutoScrollMode(boolean state) {
                NewErrorTreeViewPanel.this.myConfiguration.setAutoscrollToSource(state);
            }
        };
        this.myMessagePanel = new JPanel(new BorderLayout());
        this.myErrorViewStructure = this.createErrorViewStructure(project, this.canHideWarnings());
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        root.setUserObject(this.myErrorViewStructure.createDescriptor(this.myErrorViewStructure.getRootElement(), null));
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.myTree = this.createTree(treeModel);
        this.myTree.getEmptyText().setText(IdeBundle.message((String)"errortree.noMessages", (Object[])new Object[0]));
        this.myBuilder = new ErrorViewTreeBuilder((JTree)this.myTree, treeModel, this.myErrorViewStructure);
        this.myExporterToTextFile = new ErrorViewTextExporter(this.myErrorViewStructure);
        this.myOccurrenceNavigatorSupport = new MyOccurrenceNavigatorSupport(this.myTree);
        this.myAutoScrollToSourceHandler.install((JTree)this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        UIUtil.setLineStyleAngled((JTree)this.myTree);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setLargeModel(true);
        JScrollPane scrollPane = NewErrorTreeRenderer.install((JTree)this.myTree);
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)1));
        this.myMessagePanel.add((Component)scrollPane, "Center");
        if (createToolbar) {
            this.add((Component)this.createToolbarPanel(rerunAction), "West");
        }
        this.add((Component)this.myMessagePanel, "Center");
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    NewErrorTreeViewPanel.this.navigateToSource(false);
                }
            }
        });
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                NewErrorTreeViewPanel.this.popupInvoked(comp, x, y);
            }
        });
        EditSourceOnDoubleClickHandler.install((JTree)this.myTree);
    }

    @NotNull
    protected Tree createTree(@NotNull DefaultTreeModel treeModel) {
        if (treeModel == null) {
            NewErrorTreeViewPanel.$$$reportNull$$$0(0);
        }
        Tree tree = new Tree(treeModel){

            public void setRowHeight(int i) {
                super.setRowHeight(0);
            }
        };
        if (tree == null) {
            NewErrorTreeViewPanel.$$$reportNull$$$0(1);
        }
        return tree;
    }

    protected ErrorViewStructure createErrorViewStructure(Project project, boolean canHideWarnings) {
        return new ErrorViewStructure(project, canHideWarnings);
    }

    public void dispose() {
        this.myIsDisposed = true;
        this.myErrorViewStructure.clear();
        this.myUpdateAlarm.cancelAllRequests();
        Disposer.dispose((Disposable)this.myUpdateAlarm);
        Disposer.dispose((Disposable)this.myBuilder);
    }

    public void performCopy(@NotNull DataContext dataContext) {
        List<ErrorTreeNodeDescriptor> descriptors;
        if (dataContext == null) {
            NewErrorTreeViewPanel.$$$reportNull$$$0(2);
        }
        if (!(descriptors = this.getSelectedNodeDescriptors()).isEmpty()) {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(StringUtil.join(descriptors, descriptor -> {
                ErrorTreeElement element = descriptor.getElement();
                return NewErrorTreeRenderer.calcPrefix(element) + StringUtil.join((String[])element.getText(), (String)"\n");
            }, (String)"\n")));
        }
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NewErrorTreeViewPanel.$$$reportNull$$$0(3);
        }
        return !this.getSelectedNodeDescriptors().isEmpty();
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NewErrorTreeViewPanel.$$$reportNull$$$0(4);
        }
        return true;
    }

    @NotNull
    public StatusText getEmptyText() {
        StatusText statusText = this.myTree.getEmptyText();
        if (statusText == null) {
            NewErrorTreeViewPanel.$$$reportNull$$$0(5);
        }
        return statusText;
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            NewErrorTreeViewPanel.$$$reportNull$$$0(6);
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            NavigatableErrorTreeElement selectedMessageElement = this.getSelectedNavigatableElement();
            return selectedMessageElement != null ? selectedMessageElement.getNavigatable() : null;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.myHelpId;
        }
        if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
            return this.myTreeExpander;
        }
        if (PlatformDataKeys.EXPORTER_TO_TEXT_FILE.is(dataId)) {
            return this.myExporterToTextFile;
        }
        if (CURRENT_EXCEPTION_DATA_KEY.is(dataId)) {
            ErrorTreeElement selectedMessageElement = this.getSelectedErrorTreeElement();
            return selectedMessageElement != null ? selectedMessageElement.getData() : null;
        }
        return null;
    }

    public void selectFirstMessage() {
        ErrorTreeElement firstError = this.myErrorViewStructure.getFirstMessage(ErrorTreeElementKind.ERROR);
        if (firstError != null) {
            this.selectElement(firstError, () -> {
                if (this.shouldShowFirstErrorInEditor()) {
                    TransactionGuard.submitTransaction((Disposable)this.myBuilder, () -> this.navigateToSource(false));
                }
            });
        } else {
            ErrorTreeElement firstWarning = this.myErrorViewStructure.getFirstMessage(ErrorTreeElementKind.WARNING);
            if (firstWarning == null) {
                firstWarning = this.myErrorViewStructure.getFirstMessage(ErrorTreeElementKind.NOTE);
            }
            if (firstWarning != null) {
                this.selectElement(firstWarning, null);
            } else {
                TreeUtil.selectFirstNode((JTree)this.myTree);
            }
        }
    }

    private void selectElement(ErrorTreeElement element, Runnable onDone) {
        this.myBuilder.select(element, onDone);
    }

    protected boolean shouldShowFirstErrorInEditor() {
        return false;
    }

    public void updateTree() {
        if (!this.myIsDisposed) {
            this.myBuilder.updateTree();
        }
    }

    public void addMessage(int type, @NotNull String[] text, @Nullable VirtualFile file2, int line, int column, @Nullable Object data) {
        if (text == null) {
            NewErrorTreeViewPanel.$$$reportNull$$$0(7);
        }
        this.addMessage(type, text, null, file2, line, column, data);
    }

    public void addMessage(int type, @NotNull String[] text, @Nullable VirtualFile underFileGroup, @Nullable VirtualFile file2, int line, int column, @Nullable Object data) {
        if (text == null) {
            NewErrorTreeViewPanel.$$$reportNull$$$0(8);
        }
        if (this.myIsDisposed) {
            return;
        }
        this.myErrorViewStructure.addMessage(ErrorTreeElementKind.convertMessageFromCompilerErrorType((int)type), text, underFileGroup, file2, line, column, data);
        this.myBuilder.updateTree();
    }

    public void addMessage(int type, @NotNull String[] text, @Nullable String groupName, @NotNull Navigatable navigatable, @Nullable String exportTextPrefix, @Nullable String rendererTextPrefix, @Nullable Object data) {
        VirtualFile file2;
        if (text == null) {
            NewErrorTreeViewPanel.$$$reportNull$$$0(9);
        }
        if (navigatable == null) {
            NewErrorTreeViewPanel.$$$reportNull$$$0(10);
        }
        if (this.myIsDisposed) {
            return;
        }
        VirtualFile virtualFile = file2 = data instanceof VirtualFile ? (VirtualFile)data : null;
        if (file2 == null && navigatable instanceof OpenFileDescriptor) {
            file2 = ((OpenFileDescriptor)navigatable).getFile();
        }
        String exportPrefix = exportTextPrefix == null ? "" : exportTextPrefix;
        String renderPrefix = rendererTextPrefix == null ? "" : rendererTextPrefix;
        ErrorTreeElementKind kind = ErrorTreeElementKind.convertMessageFromCompilerErrorType((int)type);
        this.myErrorViewStructure.addNavigatableMessage(groupName, navigatable, kind, text, data, exportPrefix, renderPrefix, file2);
        this.myBuilder.updateTree();
    }

    public ErrorViewStructure getErrorViewStructure() {
        return this.myErrorViewStructure;
    }

    public static String createExportPrefix(int line) {
        return line < 0 ? "" : IdeBundle.message((String)"errortree.prefix.line", (Object[])new Object[]{line});
    }

    public static String createRendererPrefix(int line, int column) {
        if (line < 0) {
            return "";
        }
        if (column < 0) {
            return "(" + line + ")";
        }
        return "(" + line + ", " + column + ")";
    }

    @NotNull
    public JComponent getComponent() {
        NewErrorTreeViewPanel newErrorTreeViewPanel = this;
        if (newErrorTreeViewPanel == null) {
            NewErrorTreeViewPanel.$$$reportNull$$$0(11);
        }
        return newErrorTreeViewPanel;
    }

    @Nullable
    private NavigatableErrorTreeElement getSelectedNavigatableElement() {
        ErrorTreeElement selectedElement = this.getSelectedErrorTreeElement();
        return selectedElement instanceof NavigatableErrorTreeElement ? (NavigatableErrorTreeElement)((Object)selectedElement) : null;
    }

    @Nullable
    public ErrorTreeElement getSelectedErrorTreeElement() {
        ErrorTreeNodeDescriptor treeNodeDescriptor = this.getSelectedNodeDescriptor();
        return treeNodeDescriptor == null ? null : treeNodeDescriptor.getElement();
    }

    @Nullable
    public ErrorTreeNodeDescriptor getSelectedNodeDescriptor() {
        List<ErrorTreeNodeDescriptor> descriptors = this.getSelectedNodeDescriptors();
        return descriptors.size() == 1 ? descriptors.get(0) : null;
    }

    private List<ErrorTreeNodeDescriptor> getSelectedNodeDescriptors() {
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            return Collections.emptyList();
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (TreePath path : paths) {
            DefaultMutableTreeNode lastPathNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = lastPathNode.getUserObject();
            if (!(userObject instanceof ErrorTreeNodeDescriptor)) continue;
            result2.add((ErrorTreeNodeDescriptor)((Object)userObject));
        }
        return result2;
    }

    private void navigateToSource(boolean focusEditor) {
        NavigatableErrorTreeElement element = this.getSelectedNavigatableElement();
        if (element == null) {
            return;
        }
        Navigatable navigatable = element.getNavigatable();
        if (navigatable.canNavigate()) {
            navigatable.navigate(focusEditor);
        }
    }

    public static String getQualifiedName(VirtualFile file2) {
        return file2.getPresentableUrl();
    }

    private void popupInvoked(Component component, int x, int y) {
        TreePath path = this.myTree.getLeadSelectionPath();
        if (path == null) {
            return;
        }
        DefaultActionGroup group = new DefaultActionGroup();
        if (this.getData(CommonDataKeys.NAVIGATABLE.getName()) != null) {
            group.add(ActionManager.getInstance().getAction("EditSource"));
        }
        group.add(ActionManager.getInstance().getAction("$Copy"));
        group.add((AnAction)this.myAutoScrollToSourceHandler.createToggleAction());
        this.addExtraPopupMenuActions(group);
        group.addSeparator();
        group.add(CommonActionsManager.getInstance().createExpandAllAction(this.myTreeExpander, (JComponent)this));
        group.add(CommonActionsManager.getInstance().createCollapseAllAction(this.myTreeExpander, (JComponent)this));
        group.addSeparator();
        group.add((AnAction)new ExportToTextFileToolbarAction(this.myExporterToTextFile));
        ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("CompilerMessagesPopup", (ActionGroup)group);
        menu.getComponent().show(component, x, y);
    }

    protected void addExtraPopupMenuActions(DefaultActionGroup group) {
    }

    public void setProcessController(ProcessController controller) {
        this.myProcessController = controller;
    }

    public void stopProcess() {
        this.myProcessController.stopProcess();
    }

    public boolean canControlProcess() {
        return this.myProcessController != null;
    }

    public boolean isProcessStopped() {
        return this.myProcessController.isProcessStopped();
    }

    public void close() {
        MessageView messageView = MessageView.SERVICE.getInstance(this.myProject);
        Content content = messageView.getContentManager().getContent((JComponent)this);
        if (content != null) {
            messageView.getContentManager().removeContent(content, true);
        }
    }

    public void setProgress(String s, float fraction) {
        this.initProgressPanel();
        this.myProgressText = s;
        this.myFraction = fraction;
        this.updateProgress();
    }

    public void setProgressText(String s) {
        this.initProgressPanel();
        this.myProgressText = s;
        this.updateProgress();
    }

    public void setFraction(float fraction) {
        this.initProgressPanel();
        this.myFraction = fraction;
        this.updateProgress();
    }

    public void clearProgressData() {
        if (this.myProgressPanel != null) {
            this.myProgressText = " ";
            this.myFraction = 0.0f;
            this.updateProgress();
        }
    }

    private void updateProgress() {
        if (this.myIsDisposed) {
            return;
        }
        this.myUpdateAlarm.cancelAllRequests();
        this.myUpdateAlarm.addRequest(() -> {
            float fraction = this.myFraction;
            String text = this.myProgressText;
            if (fraction > 0.0f) {
                this.myProgressLabel.setText((int)((double)(fraction * 100.0f) + 0.5) + "%  " + text);
            } else {
                this.myProgressLabel.setText(text);
            }
        }, 50, ModalityState.NON_MODAL);
    }

    private void initProgressPanel() {
        if (this.myProgressPanel == null) {
            this.myProgressPanel = new JPanel(new GridLayout(1, 2));
            this.myProgressLabel = new JLabel();
            this.myProgressPanel.add(this.myProgressLabel);
            this.myMessagePanel.add((Component)this.myProgressPanel, "South");
            this.myMessagePanel.validate();
        }
    }

    public void collapseAll() {
        TreeUtil.collapseAll((JTree)this.myTree, (int)2);
    }

    public void expandAll() {
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        TreePath leadSelectionPath = this.myTree.getLeadSelectionPath();
        for (int row2 = 0; row2 < this.myTree.getRowCount(); ++row2) {
            this.myTree.expandRow(row2);
        }
        if (selectionPaths != null) {
            this.myTree.setSelectionPaths(selectionPaths);
        }
        if (leadSelectionPath != null) {
            this.myTree.scrollPathToVisible(leadSelectionPath);
        }
    }

    private JPanel createToolbarPanel(@Nullable Runnable rerunAction) {
        DefaultActionGroup group = new DefaultActionGroup();
        CloseTabToolbarAction closeMessageViewAction = new CloseTabToolbarAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                NewErrorTreeViewPanel.this.close();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/errorTreeView/NewErrorTreeViewPanel$5", "actionPerformed"));
            }
        };
        if (rerunAction != null) {
            group.add((AnAction)new RerunAction(rerunAction, (AnAction)closeMessageViewAction));
        }
        group.add((AnAction)new StopAction());
        if (this.canHideWarnings()) {
            group.addSeparator();
            group.add((AnAction)new ShowWarningsAction());
        }
        this.fillRightToolbarGroup(group);
        ActionManager actionManager = ActionManager.getInstance();
        this.myLeftToolbar = actionManager.createActionToolbar("CompilerMessagesToolbar", (ActionGroup)group, false);
        return JBUI.Panels.simplePanel((Component)this.myLeftToolbar.getComponent());
    }

    protected void fillRightToolbarGroup(DefaultActionGroup group) {
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.myOccurrenceNavigatorSupport.goNextOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.myOccurrenceNavigatorSupport.goPreviousOccurence();
    }

    public boolean hasNextOccurence() {
        return this.myOccurrenceNavigatorSupport.hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.myOccurrenceNavigatorSupport.hasPreviousOccurence();
    }

    @NotNull
    public String getNextOccurenceActionName() {
        String string = this.myOccurrenceNavigatorSupport.getNextOccurenceActionName();
        if (string == null) {
            NewErrorTreeViewPanel.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        String string = this.myOccurrenceNavigatorSupport.getPreviousOccurenceActionName();
        if (string == null) {
            NewErrorTreeViewPanel.$$$reportNull$$$0(13);
        }
        return string;
    }

    protected boolean canHideWarnings() {
        return true;
    }

    public boolean isHideWarnings() {
        return this.myConfiguration.isHideWarnings();
    }

    public List<Object> getGroupChildrenData(String groupName) {
        return this.myErrorViewStructure.getGroupChildrenData(groupName);
    }

    public void removeGroup(String name) {
        this.myErrorViewStructure.removeGroup(name);
    }

    public void addFixedHotfixGroup(String text, List<SimpleErrorData> children2) {
        this.myErrorViewStructure.addFixedHotfixGroup(text, children2);
    }

    public void addHotfixGroup(HotfixData hotfixData, List<SimpleErrorData> children2) {
        this.myErrorViewStructure.addHotfixGroup(hotfixData, children2, this);
    }

    public void reload() {
        this.myBuilder.updateTree();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/errorTreeView/NewErrorTreeViewPanel";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/errorTreeView/NewErrorTreeViewPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTree";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousOccurenceActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTree";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performCopy";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCopyEnabled";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCopyVisible";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyOccurrenceNavigatorSupport
    extends OccurenceNavigatorSupport {
        MyOccurrenceNavigatorSupport(Tree tree) {
            super((JTree)tree);
        }

        protected Navigatable createDescriptorForNode(@NotNull DefaultMutableTreeNode node) {
            Object userObject;
            if (node == null) {
                MyOccurrenceNavigatorSupport.$$$reportNull$$$0(0);
            }
            if (!((userObject = node.getUserObject()) instanceof ErrorTreeNodeDescriptor)) {
                return null;
            }
            ErrorTreeNodeDescriptor descriptor = (ErrorTreeNodeDescriptor)((Object)userObject);
            ErrorTreeElement element = descriptor.getElement();
            if (element instanceof NavigatableErrorTreeElement) {
                return ((NavigatableErrorTreeElement)((Object)element)).getNavigatable();
            }
            return null;
        }

        @NotNull
        public String getNextOccurenceActionName() {
            String string = IdeBundle.message((String)"action.next.message", (Object[])new Object[0]);
            if (string == null) {
                MyOccurrenceNavigatorSupport.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getPreviousOccurenceActionName() {
            String string = IdeBundle.message((String)"action.previous.message", (Object[])new Object[0]);
            if (string == null) {
                MyOccurrenceNavigatorSupport.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/errorTreeView/NewErrorTreeViewPanel$MyOccurrenceNavigatorSupport";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/errorTreeView/NewErrorTreeViewPanel$MyOccurrenceNavigatorSupport";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNextOccurenceActionName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreviousOccurenceActionName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createDescriptorForNode";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyTreeExpander
    implements TreeExpander {
        private MyTreeExpander() {
        }

        public void expandAll() {
            NewErrorTreeViewPanel.this.expandAll();
        }

        public boolean canExpand() {
            return true;
        }

        public void collapseAll() {
            NewErrorTreeViewPanel.this.collapseAll();
        }

        public boolean canCollapse() {
            return true;
        }
    }

    private class ShowWarningsAction
    extends ToggleAction
    implements DumbAware {
        ShowWarningsAction() {
            super(IdeBundle.message((String)"action.show.warnings", (Object[])new Object[0]), null, AllIcons.General.ShowWarning);
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                ShowWarningsAction.$$$reportNull$$$0(0);
            }
            return !NewErrorTreeViewPanel.this.isHideWarnings();
        }

        public void setSelected(@NotNull AnActionEvent event, boolean showWarnings) {
            if (event == null) {
                ShowWarningsAction.$$$reportNull$$$0(1);
            }
            if (showWarnings == NewErrorTreeViewPanel.this.isHideWarnings()) {
                NewErrorTreeViewPanel.this.myConfiguration.setHideWarnings(!showWarnings);
                NewErrorTreeViewPanel.this.myBuilder.updateTree();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/ide/errorTreeView/NewErrorTreeViewPanel$ShowWarningsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class StopAction
    extends DumbAwareAction {
        StopAction() {
            super(IdeBundle.message((String)"action.stop", (Object[])new Object[0]), null, AllIcons.Actions.Suspend);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                StopAction.$$$reportNull$$$0(0);
            }
            if (NewErrorTreeViewPanel.this.canControlProcess()) {
                NewErrorTreeViewPanel.this.stopProcess();
            }
            NewErrorTreeViewPanel.this.myLeftToolbar.updateActionsImmediately();
        }

        public void update(@NotNull AnActionEvent event) {
            if (event == null) {
                StopAction.$$$reportNull$$$0(1);
            }
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(NewErrorTreeViewPanel.this.canControlProcess() && !NewErrorTreeViewPanel.this.isProcessStopped());
            presentation.setVisible(NewErrorTreeViewPanel.this.canControlProcess());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/errorTreeView/NewErrorTreeViewPanel$StopAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class RerunAction
    extends DumbAwareAction {
        private final Runnable myRerunAction;
        private final AnAction myCloseAction;

        RerunAction(@NotNull Runnable rerunAction, AnAction closeAction) {
            if (rerunAction == null) {
                RerunAction.$$$reportNull$$$0(0);
            }
            if (closeAction == null) {
                RerunAction.$$$reportNull$$$0(1);
            }
            super(IdeBundle.message((String)"action.refresh", (Object[])new Object[0]), null, AllIcons.Actions.Rerun);
            this.myRerunAction = rerunAction;
            this.myCloseAction = closeAction;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RerunAction.$$$reportNull$$$0(2);
            }
            this.myCloseAction.actionPerformed(e);
            this.myRerunAction.run();
        }

        public void update(@NotNull AnActionEvent event) {
            if (event == null) {
                RerunAction.$$$reportNull$$$0(3);
            }
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(NewErrorTreeViewPanel.this.canControlProcess() && NewErrorTreeViewPanel.this.isProcessStopped());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rerunAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "closeAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/errorTreeView/NewErrorTreeViewPanel$RerunAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ProcessController {
        public void stopProcess();

        public boolean isProcessStopped();
    }
}

