/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.ApplicationStarterEx;
import com.intellij.openapi.application.JBProtocolCommand;
import com.intellij.openapi.application.JetBrainsProtocolHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.platform.CommandLineProjectOpenProcessor;
import com.intellij.project.ProjectKt;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandLineProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.CommandLineProcessor");

    private CommandLineProcessor() {
    }

    @Nullable
    private static Project doOpenFileOrProject(VirtualFile file2, String path) {
        if (ProjectKt.isValidProjectPath(path) || ProjectOpenProcessor.getImportProvider((VirtualFile)file2) != null) {
            Project project = ProjectUtil.openOrImport(path, null, true);
            if (project == null) {
                Messages.showErrorDialog((String)("Cannot open project '" + path + "'"), (String)"Cannot Open Project");
            }
            return project;
        }
        return CommandLineProcessor.doOpenFile(file2, -1, false);
    }

    @Nullable
    private static Project doOpenFile(VirtualFile file2, int line, boolean tempProject) {
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        if (projects.length == 0 || tempProject) {
            Project project = CommandLineProjectOpenProcessor.getInstance().openProjectAndFile(file2, line, tempProject);
            if (project == null) {
                Messages.showErrorDialog((String)"No project found to open file in", (String)"Cannot Open File");
            }
            return project;
        }
        NonProjectFileWritingAccessProvider.allowWriting(file2);
        Project project = CommandLineProcessor.findBestProject(file2, projects);
        (line > 0 ? new OpenFileDescriptor(project, file2, line - 1, 0) : PsiNavigationSupport.getInstance().createNavigatable(project, file2, -1)).navigate(true);
        return project;
    }

    @NotNull
    private static Project findBestProject(VirtualFile file2, Project[] projects) {
        Project project;
        for (Project project2 : projects) {
            if (!ProjectRootManager.getInstance((Project)project2).getFileIndex().isInContent(file2)) continue;
            Project project3 = project2;
            if (project3 == null) {
                CommandLineProcessor.$$$reportNull$$$0(0);
            }
            return project3;
        }
        IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        if (frame != null && (project = frame.getProject()) != null) {
            Project project4 = project;
            if (project4 == null) {
                CommandLineProcessor.$$$reportNull$$$0(1);
            }
            return project4;
        }
        Project project5 = projects[0];
        if (project5 == null) {
            CommandLineProcessor.$$$reportNull$$$0(2);
        }
        return project5;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Project processExternalCommandLine(List<String> args, @Nullable String currentDirectory) {
        void var3_8;
        LOG.info("External command line:");
        LOG.info("Dir: " + currentDirectory);
        for (String string : args) {
            LOG.info(string);
        }
        LOG.info("-----");
        if (args.isEmpty()) {
            return null;
        }
        String command = args.get(0);
        for (ApplicationStarter starter2 : ApplicationStarter.EP_NAME.getExtensionList()) {
            if (!command.equals(starter2.getCommandName())) continue;
            if (starter2 instanceof ApplicationStarterEx && ((ApplicationStarterEx)starter2).canProcessExternalCommandLine()) {
                LOG.info("Processing command with " + starter2);
                ((ApplicationStarterEx)starter2).processExternalCommandLine(ArrayUtil.toStringArray(args), currentDirectory);
                return null;
            }
            String title = "Cannot execute command '" + command + "'";
            String message = "Only one instance of " + ApplicationNamesInfo.getInstance().getProductName() + " can be run at a time.";
            Messages.showErrorDialog((String)message, (String)title);
            return null;
        }
        if (command.startsWith("jetbrains://")) {
            try {
                String string = URLDecoder.decode(command, "UTF-8");
                JetBrainsProtocolHandler.processJetBrainsLauncherParameters((String)string);
                ApplicationManager.getApplication().invokeLater(() -> JBProtocolCommand.handleCurrentCommand());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOG.error((Throwable)unsupportedEncodingException);
            }
            return null;
        }
        Object var3_7 = null;
        int line = -1;
        boolean tempProject = false;
        for (int i = 0; i < args.size(); ++i) {
            String arg = args.get(i);
            if (arg.equals("nosplash")) continue;
            if (arg.equals("-l") || arg.equals("--line")) {
                if (++i == args.size()) break;
                try {
                    line = Integer.parseInt(args.get(i));
                }
                catch (NumberFormatException e) {
                    line = -1;
                }
                continue;
            }
            if (arg.equals("--temp-project")) {
                tempProject = true;
                continue;
            }
            if (StringUtil.isQuotedString((String)arg)) {
                arg = StringUtil.unquoteString((String)arg);
            }
            if (!new File(arg).isAbsolute()) {
                arg = currentDirectory != null ? new File(currentDirectory, arg).getAbsolutePath() : new File(arg).getAbsolutePath();
            }
            VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(arg);
            if (line != -1 || tempProject) {
                if (file2 != null && !file2.isDirectory()) {
                    Project project = CommandLineProcessor.doOpenFile(file2, line, tempProject);
                } else {
                    Messages.showErrorDialog((String)("Cannot find file '" + arg + "'"), (String)"Cannot Find File");
                }
            } else if (file2 != null) {
                Project project = CommandLineProcessor.doOpenFileOrProject(file2, arg);
            } else {
                Messages.showErrorDialog((String)("Cannot find file '" + arg + "'"), (String)"Cannot Find File");
            }
            line = -1;
            tempProject = false;
        }
        return var3_8;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/CommandLineProcessor", "findBestProject"));
    }
}

