/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferable;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorCopyPasteHelperImpl;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class CopyHandler
extends EditorActionHandler {
    private static final Logger LOG = Logger.getInstance(CopyHandler.class);
    private final EditorActionHandler myOriginalAction;

    public CopyHandler(EditorActionHandler originalHandler) {
        this.myOriginalAction = originalHandler;
    }

    public void doExecute(final @NotNull Editor editor, Caret caret, DataContext dataContext) {
        EditorEx ex;
        CopyPastePreProcessor processor2;
        if (editor == null) {
            CopyHandler.$$$reportNull$$$0(0);
        }
        assert (caret == null) : "Invocation of 'copy' operation for specific caret is not supported";
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editor.getComponent()));
        if (project == null) {
            if (this.myOriginalAction != null) {
                this.myOriginalAction.execute(editor, null, dataContext);
            }
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file2 == null) {
            if (this.myOriginalAction != null) {
                this.myOriginalAction.execute(editor, null, dataContext);
            }
            return;
        }
        final SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection(true)) {
            if (Registry.is((String)"editor.skip.copy.and.cut.for.empty.selection")) {
                return;
            }
            editor.getCaretModel().runForEachCaret(new CaretAction(){

                public void perform(Caret caret) {
                    selectionModel.selectLineAtCaret();
                }
            });
            if (!selectionModel.hasSelection(true)) {
                return;
            }
            editor.getCaretModel().runForEachCaret(new CaretAction(){

                public void perform(Caret caret) {
                    EditorActionUtil.moveCaretToLineStartIgnoringSoftWraps(editor);
                }
            });
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int[] startOffsets = selectionModel.getBlockSelectionStarts();
        int[] endOffsets = selectionModel.getBlockSelectionEnds();
        ArrayList transferableDatas = new ArrayList();
        DumbService.getInstance((Project)project).withAlternativeResolveEnabled(() -> {
            if (editor == null) {
                CopyHandler.$$$reportNull$$$0(1);
            }
            for (CopyPastePostProcessor processor2 : CopyPastePostProcessor.EP_NAME.getExtensionList()) {
                try {
                    transferableDatas.addAll(processor2.collectTransferableData(file2, editor, startOffsets, endOffsets));
                }
                catch (IndexNotReadyException e) {
                    LOG.debug((Throwable)e);
                }
            }
        });
        String text = editor.getCaretModel().supportsMultipleCarets() ? EditorCopyPasteHelperImpl.getSelectedTextForClipboard(editor, transferableDatas) : selectionModel.getSelectedText();
        String rawText = TextBlockTransferable.convertLineSeparators(text, "\n", transferableDatas);
        String escapedText = null;
        Iterator iterator = CopyPastePreProcessor.EP_NAME.getExtensionList().iterator();
        while (iterator.hasNext() && (escapedText = (processor2 = (CopyPastePreProcessor)iterator.next()).preprocessOnCopy(file2, startOffsets, endOffsets, rawText)) == null) {
        }
        TextBlockTransferable transferable = new TextBlockTransferable(escapedText != null ? escapedText : rawText, transferableDatas, escapedText != null ? new RawText(rawText) : null);
        CopyPasteManager.getInstance().setContents((Transferable)transferable);
        if (editor instanceof EditorEx && (ex = (EditorEx)editor).isStickySelection()) {
            ex.setStickySelection(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "editor";
        objectArray2[1] = "com/intellij/codeInsight/editorActions/CopyHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doExecute$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

