/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.model;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.psi.YAMLKeyValue;

@ApiStatus.Experimental
public abstract class YamlMetaType {
    @NotNull
    private final String myTypeName;
    @NotNull
    private String myDisplayName;

    protected YamlMetaType(@NotNull String typeName) {
        if (typeName == null) {
            YamlMetaType.$$$reportNull$$$0(0);
        }
        this.myTypeName = typeName;
        this.myDisplayName = typeName;
    }

    @NotNull
    @Contract(pure=true)
    public final String getTypeName() {
        String string = this.myTypeName;
        if (string == null) {
            YamlMetaType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            YamlMetaType.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public Icon getIcon() {
        Icon icon = AllIcons.Json.Object;
        if (icon == null) {
            YamlMetaType.$$$reportNull$$$0(3);
        }
        return icon;
    }

    public void setDisplayName(@NotNull String displayName) {
        if (displayName == null) {
            YamlMetaType.$$$reportNull$$$0(4);
        }
        this.myDisplayName = displayName;
    }

    @Nullable
    public abstract Field findFeatureByName(@NotNull String var1);

    public void validateKeyValue(@NotNull YAMLKeyValue keyValue, @NotNull ProblemsHolder problemsHolder) {
        if (keyValue == null) {
            YamlMetaType.$$$reportNull$$$0(5);
        }
        if (problemsHolder == null) {
            YamlMetaType.$$$reportNull$$$0(6);
        }
    }

    public abstract void buildInsertionSuffixMarkup(@NotNull YamlInsertionMarkup var1, @NotNull Field.Relation var2, @NotNull ForcedCompletionPath.Iteration var3);

    protected static void buildCompleteKeyMarkup(@NotNull YamlInsertionMarkup markup, @NotNull Field feature, @NotNull ForcedCompletionPath.Iteration iteration) {
        if (markup == null) {
            YamlMetaType.$$$reportNull$$$0(7);
        }
        if (feature == null) {
            YamlMetaType.$$$reportNull$$$0(8);
        }
        if (iteration == null) {
            YamlMetaType.$$$reportNull$$$0(9);
        }
        markup.append(feature.getName());
        Field.Relation defaultRelation = feature.getDefaultRelation();
        YamlMetaType defaultType = feature.getType(defaultRelation);
        defaultType.buildInsertionSuffixMarkup(markup, defaultRelation, iteration);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.myTypeName + "@" + Integer.toHexString(this.hashCode());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/meta/model/YamlMetaType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markup";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iteration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/meta/model/YamlMetaType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setDisplayName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateKeyValue";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildCompleteKeyMarkup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Experimental
    public static class ForcedCompletionPath {
        private static final Iteration OFF_PATH_ITERATION = new OffPathIteration();
        private static final Iteration NULL_ITERATION = new NullIteration();
        private static final ForcedCompletionPath NULL_PATH = new ForcedCompletionPath(null);
        @Nullable
        private final List<Field> myCompletionPath;

        @NotNull
        public static ForcedCompletionPath forDeepCompletion(@NotNull List<Field> completionPath) {
            if (completionPath == null) {
                ForcedCompletionPath.$$$reportNull$$$0(0);
            }
            ForcedCompletionPath forcedCompletionPath = new ForcedCompletionPath(completionPath);
            if (forcedCompletionPath == null) {
                ForcedCompletionPath.$$$reportNull$$$0(1);
            }
            return forcedCompletionPath;
        }

        @NotNull
        public static ForcedCompletionPath nullPath() {
            ForcedCompletionPath forcedCompletionPath = NULL_PATH;
            if (forcedCompletionPath == null) {
                ForcedCompletionPath.$$$reportNull$$$0(2);
            }
            return forcedCompletionPath;
        }

        private ForcedCompletionPath(@Nullable List<Field> completionPath) {
            this.myCompletionPath = completionPath;
        }

        @NotNull
        public String getName() {
            if (this.myCompletionPath == null) {
                if ("<null>" == null) {
                    ForcedCompletionPath.$$$reportNull$$$0(3);
                }
                return "<null>";
            }
            String string = this.myCompletionPath.stream().map(Field::getName).collect(Collectors.joining("."));
            if (string == null) {
                ForcedCompletionPath.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nullable
        public YamlMetaType getFinalizingType() {
            if (this.myCompletionPath == null || this.myCompletionPath.size() < 2) {
                return null;
            }
            return this.myCompletionPath.get(this.myCompletionPath.size() - 2).getDefaultType();
        }

        @Nullable
        public Field getFinalizingField() {
            if (this.myCompletionPath == null || this.myCompletionPath.isEmpty()) {
                return null;
            }
            return this.myCompletionPath.get(this.myCompletionPath.size() - 1);
        }

        public Iteration start() {
            return this.myCompletionPath != null ? new OnPathIteration(1) : NULL_ITERATION;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.getName() + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "completionPath";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/yaml/meta/model/YamlMetaType$ForcedCompletionPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/yaml/meta/model/YamlMetaType$ForcedCompletionPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "forDeepCompletion";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "nullPath";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "forDeepCompletion";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class OnPathIteration
        implements Iteration {
            private final int myPosition;

            private OnPathIteration(int position) {
                this.myPosition = position;
            }

            @Override
            public boolean isNextOnPath(@NotNull Field field) {
                if (field == null) {
                    OnPathIteration.$$$reportNull$$$0(0);
                }
                assert (ForcedCompletionPath.this.myCompletionPath != null);
                return !this.isEndOfPathReached() && field.equals(ForcedCompletionPath.this.myCompletionPath.get(this.myPosition));
            }

            @Override
            public boolean isEndOfPathReached() {
                assert (ForcedCompletionPath.this.myCompletionPath != null);
                return this.myPosition >= ForcedCompletionPath.this.myCompletionPath.size();
            }

            @Override
            @NotNull
            public Iteration nextIterationFor(@NotNull Field field) {
                if (field == null) {
                    OnPathIteration.$$$reportNull$$$0(1);
                }
                assert (ForcedCompletionPath.this.myCompletionPath != null);
                Iteration iteration = this.isEndOfPathReached() || field.equals(ForcedCompletionPath.this.myCompletionPath.get(this.myPosition)) ? new OnPathIteration(this.myPosition + 1) : OFF_PATH_ITERATION;
                if (iteration == null) {
                    OnPathIteration.$$$reportNull$$$0(2);
                }
                return iteration;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/yaml/meta/model/YamlMetaType$ForcedCompletionPath$OnPathIteration";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/yaml/meta/model/YamlMetaType$ForcedCompletionPath$OnPathIteration";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "nextIterationFor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isNextOnPath";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "nextIterationFor";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        private static class NullIteration
        implements Iteration {
            private NullIteration() {
            }

            @Override
            public boolean isNextOnPath(@NotNull Field field) {
                if (field == null) {
                    NullIteration.$$$reportNull$$$0(0);
                }
                return false;
            }

            @Override
            public boolean isEndOfPathReached() {
                return true;
            }

            @Override
            @NotNull
            public Iteration nextIterationFor(@NotNull Field field) {
                if (field == null) {
                    NullIteration.$$$reportNull$$$0(1);
                }
                NullIteration nullIteration = this;
                if (nullIteration == null) {
                    NullIteration.$$$reportNull$$$0(2);
                }
                return nullIteration;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/yaml/meta/model/YamlMetaType$ForcedCompletionPath$NullIteration";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/yaml/meta/model/YamlMetaType$ForcedCompletionPath$NullIteration";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "nextIterationFor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isNextOnPath";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "nextIterationFor";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        private static class OffPathIteration
        implements Iteration {
            private OffPathIteration() {
            }

            @Override
            public boolean isNextOnPath(@NotNull Field field) {
                if (field == null) {
                    OffPathIteration.$$$reportNull$$$0(0);
                }
                return false;
            }

            @Override
            public boolean isEndOfPathReached() {
                return false;
            }

            @Override
            @NotNull
            public Iteration nextIterationFor(@NotNull Field field) {
                if (field == null) {
                    OffPathIteration.$$$reportNull$$$0(1);
                }
                OffPathIteration offPathIteration = this;
                if (offPathIteration == null) {
                    OffPathIteration.$$$reportNull$$$0(2);
                }
                return offPathIteration;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/yaml/meta/model/YamlMetaType$ForcedCompletionPath$OffPathIteration";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/yaml/meta/model/YamlMetaType$ForcedCompletionPath$OffPathIteration";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "nextIterationFor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isNextOnPath";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "nextIterationFor";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        public static interface Iteration {
            public boolean isEndOfPathReached();

            public boolean isNextOnPath(@NotNull Field var1);

            @NotNull
            public Iteration nextIterationFor(@NotNull Field var1);
        }
    }

    @ApiStatus.Experimental
    public static class YamlInsertionMarkup {
        public static final String CRLF_MARKUP = "<crlf>";
        public static final String CARET_MARKUP = "<caret>";
        public static final String SEQUENCE_ITEM_MARKUP = "- ";
        private final StringBuilder myOutput;
        private final String myTabSymbol;
        private int myLevel;
        private boolean myCaretAppended;

        public YamlInsertionMarkup() {
            this("  ");
        }

        public YamlInsertionMarkup(@NotNull String tabSymbol) {
            if (tabSymbol == null) {
                YamlInsertionMarkup.$$$reportNull$$$0(0);
            }
            this.myOutput = new StringBuilder();
            this.myTabSymbol = tabSymbol;
        }

        public void append(@NotNull String text) {
            if (text == null) {
                YamlInsertionMarkup.$$$reportNull$$$0(1);
            }
            this.myOutput.append(text);
        }

        public void newLineAndTabs() {
            this.newLineAndTabs(false);
        }

        public void newLineAndTabs(boolean withSequenceItemMark) {
            if (withSequenceItemMark) assert (this.myLevel > 0);
            this.append(CRLF_MARKUP);
            if (withSequenceItemMark) {
                this.append(this.tabs(this.myLevel - 1));
                this.append(SEQUENCE_ITEM_MARKUP);
            } else {
                this.append(this.tabs(this.myLevel));
            }
        }

        public void appendCaret() {
            if (!this.myCaretAppended) {
                this.append(CARET_MARKUP);
            }
            this.myCaretAppended = true;
        }

        public String getMarkup() {
            return this.myOutput.toString();
        }

        public void increaseTabs(int indent) {
            assert (indent > 0);
            this.myLevel += indent;
        }

        public void doTabbedBlock(int indent, @NotNull Runnable doWhenTabbed) {
            if (doWhenTabbed == null) {
                YamlInsertionMarkup.$$$reportNull$$$0(2);
            }
            this.increaseTabs(indent);
            try {
                doWhenTabbed.run();
            }
            finally {
                this.decreaseTabs(indent);
            }
        }

        @NotNull
        public String getTabSymbol() {
            String string = this.myTabSymbol;
            if (string == null) {
                YamlInsertionMarkup.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void decreaseTabs(int indent) {
            assert (indent <= this.myLevel);
            this.myLevel -= indent;
        }

        private String tabs(int level) {
            return StringUtil.repeat((String)this.myTabSymbol, (int)level);
        }

        public void insertStringAndCaret(Editor editor, String commonPadding) {
            String insertionMarkup = this.getMarkup();
            String suffixWithCaret = insertionMarkup.replace(CRLF_MARKUP, "\n" + commonPadding);
            int caretIndex = suffixWithCaret.indexOf(CARET_MARKUP);
            String suffix = suffixWithCaret.replace(CARET_MARKUP, "");
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)suffix, (boolean)false, (boolean)true, (int)caretIndex);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tabSymbol";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "doWhenTabbed";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/yaml/meta/model/YamlMetaType$YamlInsertionMarkup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/yaml/meta/model/YamlMetaType$YamlInsertionMarkup";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTabSymbol";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "append";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "doTabbedBlock";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

