/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.generators.symfony;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtilRt;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.framework.FrameworkUtils;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkDescription;
import com.jetbrains.php.framework.generators.FrameworkDescriptionProvider;
import com.jetbrains.php.framework.generators.symfony.SymfonyDescriptionProvider;
import com.jetbrains.php.framework.generators.symfony.SymfonyVersion;
import com.jetbrains.php.framework.generators.symfonycomponent.SymfonyComponentUtils;
import com.jetbrains.php.framework.ui.FrameworkPathDialog;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class SymfonyUtils {
    private static final Logger LOG = Logger.getInstance(SymfonyUtils.class);

    private SymfonyUtils() {
    }

    static List<FrameworkCommand> getFrameworkCommands(SymfonyDescriptionProvider.VersionedData symfonyData, @NotNull ProgressIndicator pi) throws ExecutionException, FrameworkDescriptionProvider.FrameworkParseException {
        File tmpProjectFile;
        if (pi == null) {
            SymfonyUtils.$$$reportNull$$$0(0);
        }
        FrameworkDescription symfonyFramework = SymfonyUtils.getSymfonyFrameworkDescription(symfonyData);
        SymfonyVersion version = symfonyData.getVersion();
        if (version == null) {
            version = SymfonyUtils.getVersion(symfonyData.getData(), null);
        }
        if (version.isSuitableForComponent()) {
            return version.getCommands(symfonyData.getData().createCommand(new String[0]), symfonyFramework, pi);
        }
        FrameworkUtils.checkProgress(pi);
        try {
            tmpProjectFile = FileUtilRt.createTempDirectory((String)"symfony", (String)"tmp");
            tmpProjectFile.deleteOnExit();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            throw new ExecutionException(FrameworkBundle.message("framework.symfony.failed.to.create.temp.dir.0", e.getMessage()));
        }
        FrameworkUtils.checkProgress(pi);
        String tmpPath = tmpProjectFile.getPath();
        FrameworkUtils.executeCommandWithFullOutput(version.getCommandToCreateProject(symfonyData.getData()), tmpPath, false, false);
        FrameworkUtils.checkProgress(pi);
        try {
            symfonyFramework.setHelp(version.getHelp(symfonyData.getData(), tmpPath));
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
        }
        FrameworkUtils.checkProgress(pi);
        return version.getCommands(symfonyData.getData(), tmpPath, symfonyFramework);
    }

    @NonNls
    static FrameworkDescription getSymfonyFrameworkDescription(SymfonyDescriptionProvider.VersionedData symfonyData) {
        return SymfonyComponentUtils.getFrameworkDescription(symfonyData.getData(), "s", SymfonyDescriptionProvider.FRAMEWORK_NAME, "com.symfony", symfonyData.getVersion());
    }

    private static SymfonyVersion getVersion(FrameworkPathDialog.Data symfonyData, String workingFolder) throws ExecutionException, FrameworkDescriptionProvider.FrameworkParseException {
        ScriptRunnerUtil.ScriptOutput versionOutput;
        String[] command = symfonyData.createCommand("-V");
        try {
            versionOutput = FrameworkUtils.executeCommandWithFullOutput(command, workingFolder, true, true);
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
            throw new ExecutionException(FrameworkBundle.message("framework.symfony.failed.to.execute.0.1.v", symfonyData.getPhpPath(false), symfonyData.getPath(false)));
        }
        return SymfonyVersion.getVersion(command, versionOutput);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/php/framework/generators/symfony/SymfonyUtils", "getFrameworkCommands"));
    }
}

