/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Stack;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.spi.utils.CndFileSystemProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Utilities;

public class CndPathUtilities {
    private static boolean isWindows = Utilities.isWindows();
    public static final boolean IfdefDiagnostics = Boolean.getBoolean("ifdef.debug.diagnostics");

    private CndPathUtilities() {
    }

    static void testSetWindows(boolean isWin) {
        isWindows = isWin;
    }

    public static String getDirName(String path) {
        return PathUtilities.getDirName((String)path);
    }

    public static String getBaseName(String path) {
        return PathUtilities.getBaseName((String)path);
    }

    public static String getRelativePath(String base, String path) {
        String pstring;
        String bstring;
        if (path.equals(base = CndPathUtilities.trimDotDot(base))) {
            return path;
        }
        if (path.startsWith(base + '/')) {
            return path.substring(base.length() + 1);
        }
        if (path.startsWith(base + '\\')) {
            return path.substring(base.length() + 1);
        }
        if (!CndPathUtilities.isPathAbsolute(path)) {
            return path;
        }
        String[] bnames = CndPathUtilities.getPathNameArray(base);
        String[] pnames = CndPathUtilities.getPathNameArray(path);
        int match = 0;
        for (int i = 0; i < bnames.length && i < pnames.length && (bstring = bnames[i]).equals(pstring = pnames[i]); ++i) {
            ++match;
        }
        if (match > 0 && match == pnames.length && bnames.length > pnames.length) {
            StringBuilder s = new StringBuilder();
            for (int cnt = 0; cnt < bnames.length - match - 1; ++cnt) {
                s.append("..").append(File.separator);
            }
            s.append("..");
            return s.toString();
        }
        if (match > 0) {
            StringBuilder s = new StringBuilder();
            for (int cnt = bnames.length - match; cnt > 0; --cnt) {
                if (s.length() > 0) {
                    s.append(File.separatorChar);
                }
                s.append("..");
            }
            for (int i = match; i < pnames.length; ++i) {
                if (pnames[i].isEmpty()) continue;
                if (s.length() > 0 && s.charAt(s.length() - 1) != File.separatorChar) {
                    s.append(File.separator);
                }
                s.append(pnames[i]);
            }
            return s.toString();
        }
        return path;
    }

    public static String toAbsolutePath(FileObject base, String path) {
        try {
            return CndPathUtilities.toAbsolutePath(base.getFileSystem(), base.getPath(), path);
        }
        catch (FileStateInvalidException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static String toAbsolutePath(FSPath basePath, String path) {
        return CndPathUtilities.toAbsolutePath(basePath.getFileSystem(), basePath.getPath(), path);
    }

    public static String toAbsolutePath(FileSystem fileSystem, String basePath, String path) {
        CndUtils.assertAbsolutePathInConsole(basePath);
        String string = path = path == null || path.length() == 0 ? "." : path;
        if (!CndFileSystemProvider.isAbsolute(fileSystem, path)) {
            path = basePath + '/' + path;
        }
        path = CndFileUtils.normalizeAbsolutePath(fileSystem, path);
        path = CndPathUtilities.naturalizeSlashes(fileSystem, path);
        return path;
    }

    public static String toRelativePath(FileObject base, FileObject path) {
        return CndPathUtilities.toRelativePath(base.getPath(), path.getPath());
    }

    public static String toRelativePath(FileObject base, String path) {
        return CndPathUtilities.toRelativePath(base.getPath(), path);
    }

    public static String toRelativePath(String base, FileObject path) {
        return CndPathUtilities.toRelativePath(base, path.getPath());
    }

    public static String toRelativePath(String base, String path) {
        String relPath = path;
        if (relPath == null || relPath.length() == 0) {
            relPath = ".";
        }
        if (CndPathUtilities.isPathAbsolute(relPath)) {
            relPath = relPath.equals(base) ? "." : (CndPathUtilities.isPathAbsolute(base) ? CndPathUtilities.getRelativePath(base, relPath) : path);
        }
        return relPath;
    }

    public static String toAbsoluteOrRelativePath(FileObject base, FileObject path) {
        return CndPathUtilities.toAbsoluteOrRelativePath(base, path.getPath());
    }

    public static String toAbsoluteOrRelativePath(FileObject base, String path) {
        return CndPathUtilities.toAbsoluteOrRelativePath(base.getPath(), path);
    }

    public static String toAbsoluteOrRelativePath(String base, String path) {
        String dotSlash;
        String resRel = CndPathUtilities.toRelativePath(base, path);
        String res = CndPathUtilities.isPathAbsolute(resRel) || resRel.startsWith("..") ? path : (resRel.startsWith(dotSlash = "." + File.separatorChar) ? resRel.substring(2) : resRel);
        return res;
    }

    static String[] getPathNameArray(String path) {
        int pos = 0;
        if (0 < path.length() && (path.charAt(0) == '/' || path.charAt(0) == '\\')) {
            pos = 1;
        }
        ArrayList<String> l = new ArrayList<String>();
        if (CndPathUtilities.isPathAbsolute(path)) {
            while (pos >= 0) {
                int next = path.indexOf(47, pos);
                if (next < 0) {
                    next = path.indexOf(92, pos);
                }
                if (next > 0) {
                    l.add(path.substring(pos, next));
                    pos = next + 1;
                    continue;
                }
                l.add(path.substring(pos));
                pos = -1;
            }
        }
        return l.toArray(new String[l.size()]);
    }

    public static String expandPath(String filename) {
        int si;
        int max = filename.length();
        StringBuilder dp = new StringBuilder(256);
        for (si = 0; si < max && Character.isSpaceChar(filename.charAt(si)); ++si) {
        }
        if (si < max && filename.charAt(si) == '~' && si++ < max && (si == max || filename.charAt(si) == '/')) {
            dp.append(System.getProperty("user.home"));
        }
        while (si < max) {
            int endIndex;
            char c;
            if ((c = filename.charAt(si++)) == '\\' && si < max) {
                if (filename.charAt(si) == '$') {
                    dp.append('\\');
                    dp.append('$');
                    ++si;
                    continue;
                }
                dp.append(c);
                continue;
            }
            if (c == '$' && si < max && filename.charAt(si) == '(') {
                endIndex = filename.indexOf(41, si);
                dp.append('$');
                if (endIndex > -1) {
                    dp.append(filename.substring(si, endIndex));
                    si = endIndex;
                    continue;
                }
                dp.append(filename.substring(si));
                si = max;
                continue;
            }
            if (c == '$' && si < max) {
                boolean braces;
                boolean bl = braces = filename.charAt(si) == '{';
                if (braces) {
                    // empty if block
                }
                int beginIndex = ++si;
                while (si < max) {
                    char c2 = filename.charAt(si);
                    if (braces && c2 == '}' || !Character.isLetterOrDigit(c2) && c2 != '_') break;
                    ++si;
                }
                endIndex = si;
                if (si < max && braces) {
                    ++si;
                }
                if (endIndex > beginIndex) {
                    String value = System.getenv(filename.substring(beginIndex, endIndex));
                    if (value != null) {
                        dp.append(value);
                        continue;
                    }
                    dp.append('$');
                    if (braces) {
                        dp.append('{');
                    }
                    dp.append(filename.substring(beginIndex, endIndex));
                    if (!braces) continue;
                    dp.append('}');
                    continue;
                }
                dp.append('$');
                if (!braces) continue;
                dp.append("{}");
                continue;
            }
            dp.append(c);
        }
        return dp.toString();
    }

    public static String trimSlashes(String dir) {
        int trim = 0;
        for (int i = dir.length(); i > 0 && (dir.charAt(i - 1) == '/' || dir.charAt(i - 1) == '\\'); --i) {
            ++trim;
        }
        if (trim > 0) {
            return dir.substring(0, dir.length() - trim);
        }
        return dir;
    }

    public static String trimpath(String dir) {
        return CndPathUtilities.trimSlashes(dir.trim());
    }

    @Deprecated
    public static String normalize(String path) {
        return CndPathUtilities.normalizeSlashes(path);
    }

    public static String normalizeWindowsPath(String path) {
        path = path.replace('\\', '/');
        path = PathUtilities.normalizeUnixPath((String)path);
        path = path.replace('/', '\\');
        return path;
    }

    public static String normalizeUnixPath(String absPath) {
        return PathUtilities.normalizeUnixPath((String)absPath);
    }

    public static String normalizeSlashes(String path) {
        return path.replace('\\', '/');
    }

    public static String naturalizeSlashes(String path) {
        if (Utilities.isUnix()) {
            return path.replace('\\', '/');
        }
        if (Utilities.isWindows()) {
            return path.replace('/', '\\');
        }
        return path;
    }

    public static String naturalizeSlashes(FileSystem fileSystem, String path) {
        char rightSlash = CndFileUtils.getFileSeparatorChar(fileSystem);
        char wrongSlash = rightSlash == '/' ? (char)'\\' : '/';
        return path.replace(wrongSlash, rightSlash);
    }

    public static String quoteIfNecessary(String s) {
        int n = s.length();
        if (n == 0) {
            return s;
        }
        if (s.charAt(0) == '\"' && s.charAt(n - 1) == '\"') {
            return s;
        }
        for (int i = 0; i < n; ++i) {
            int j;
            char c = s.charAt(i);
            if (c != ' ' && c != '\t' && c != '*' && c != '[' && c != ']' && c != '(' && c != ')') continue;
            if (s.indexOf(34) > 0 && (j = s.indexOf("\\\"")) < 0) {
                s = s.replace("\"", "\\\"");
            }
            return '\"' + s + '\"';
        }
        return s;
    }

    public static boolean isAbsolute(FileSystem fileSystem, String path) {
        return CndFileSystemProvider.isAbsolute(fileSystem, path);
    }

    public static boolean isAbsolute(CharSequence path) {
        return CndPathUtilities.isPathAbsolute(path);
    }

    public static boolean isPathAbsolute(FileSystem fs, String path) {
        return CndFileSystemProvider.isAbsolute(fs, path);
    }

    public static void assertNoUrl(CharSequence path) {
        if (CharSequenceUtils.startsWith(path, "rfs:") || CharSequenceUtils.startsWith(path, "file:")) {
            CndUtils.assertTrue(false, "Path should not start with protocol: " + path);
        }
    }

    public static boolean isPathAbsolute(CharSequence path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        CndPathUtilities.assertNoUrl(path);
        if (path.charAt(0) == '/') {
            return true;
        }
        if (path.charAt(0) == '\\') {
            return true;
        }
        if (CharSequenceUtils.indexOf(path, ':') == 1 && isWindows) {
            if (path.length() == 2) {
                return false;
            }
            return path.charAt(2) == '\\' || path.charAt(2) == '/';
        }
        return false;
    }

    public static boolean isIgnoredFolder(File file) {
        if (file.isDirectory()) {
            String name = file.getName();
            return CndPathUtilities.isIgnoredFolder(name);
        }
        return false;
    }

    public static boolean isIgnoredFolder(String name) {
        return name.equals("SCCS") || name.equals("CVS") || name.equals(".hg") || name.equals("SunWS_cache") || name.equals(".svn");
    }

    public static boolean sameString(String a, String b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static boolean sameStringArray(String[] a, String[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int x = 0; x < a.length; ++x) {
            if (CndPathUtilities.sameString(a[x], b[x])) continue;
            return false;
        }
        return true;
    }

    public static String escapeOddCharacters(String s) {
        int n = s.length();
        StringBuilder ret = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '\t' || c == ':' || c == '\'' || c == '*' || c == '\"' || c == '[' || c == ']' || c == '(' || c == ')' || c == ';') {
                ret.append('\\');
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static String replaceOddCharacters(String s, char replaceChar) {
        int n = s.length();
        StringBuilder ret = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '\t' || c == ':' || c == '\'' || c == '*' || c == '\"' || c == '[' || c == ']' || c == '(' || c == ')') {
                ret.append(replaceChar);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static String escapeQuotes(String s) {
        if (s.indexOf(34) < 0) {
            return s;
        }
        return s.replaceAll("\"", "\\\\\"");
    }

    public static boolean hasMakeSpecialCharacters(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isLetterOrDigit(string.charAt(i)) || string.charAt(i) == '_' || string.charAt(i) == '-' || string.charAt(i) == '.' || string.charAt(i) == '/' || string.charAt(i) == '$' || string.charAt(i) == '{' || string.charAt(i) == '}' || string.charAt(i) == ':' || string.charAt(i) == '\\') continue;
            return true;
        }
        return false;
    }

    public static String trimDotDot(String path) {
        Stack<String> stack = new Stack<String>();
        String absPrefix = null;
        if (CndPathUtilities.isPathAbsolute(path)) {
            if (path.length() >= 2 && path.charAt(0) == '/' && path.charAt(1) == '/') {
                absPrefix = "//";
                path = path.substring(2);
            } else if (path.charAt(0) == '/') {
                absPrefix = "/";
                path = path.substring(1);
            } else if (path.charAt(1) == ':') {
                absPrefix = path.substring(0, 3);
                path = path.substring(3);
            }
        }
        int down = 0;
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("..")) {
                if (down > 0) {
                    stack.pop();
                    --down;
                    continue;
                }
                stack.push(token);
                continue;
            }
            stack.push(token);
            ++down;
        }
        StringBuilder retpath = new StringBuilder();
        if (absPrefix != null) {
            retpath.append(absPrefix);
        }
        for (int i = 0; i < stack.size(); ++i) {
            retpath.append((String)stack.elementAt(i));
            if (i >= stack.size() - 1) continue;
            retpath.append('/');
        }
        return retpath.toString();
    }

    public static String createUniqueFileName(String folder, String name, String ext) {
        if (folder == null || folder.length() == 0 || !CndPathUtilities.isPathAbsolute(folder) || name == null || name.length() == 0) {
            assert (false);
            return null;
        }
        String newName = name;
        int i = 0;
        while (true) {
            if (i > 0) {
                newName = name + "_" + i;
            }
            String newPath = folder + "/" + newName;
            if (ext != null && ext.length() > 0) {
                newPath = newPath + "." + ext;
            }
            if (!new File(newPath).exists()) break;
            ++i;
        }
        return newName;
    }

    public static String createUniqueFileName(FileObject folder, String name, String ext) {
        if (folder == null || name == null || name.length() == 0) {
            assert (false);
            return null;
        }
        String newName = name;
        int i = 0;
        while (true) {
            FileObject fileObject;
            if (i > 0) {
                newName = name + "_" + i;
            }
            if ((fileObject = folder.getFileObject(newName, ext)) == null || !fileObject.isValid()) break;
            ++i;
        }
        return newName;
    }

    public static String expandMacro(String string, String macro, String value) {
        int i = string.indexOf(macro);
        if (i == 0) {
            string = value + string.substring(macro.length());
        } else if (i > 0) {
            string = string.substring(0, i) + value + string.substring(i + macro.length());
        }
        return string;
    }

    public static String expandAllMacroses(String string, String macro, String value) {
        while (string.indexOf(macro) > -1) {
            string = CndPathUtilities.expandMacro(string, macro, value);
        }
        return string;
    }
}

