/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony2.ui.wizards;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.symfony2.options.SymfonyOptions;
import org.netbeans.modules.php.symfony2.options.SymfonyOptionsValidator;
import org.netbeans.modules.php.symfony2.ui.options.SymfonyOptionsPanelController;
import org.netbeans.modules.php.symfony2.ui.wizards.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class NewProjectConfigurationPanel
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 326547867641L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JLabel infoLabel;
    private JCheckBox ltsCheckBox;
    private JLabel noteLabel;
    private JLabel optionsLabel;

    public NewProjectConfigurationPanel() {
        this.initComponents();
        this.init();
        this.initListeners();
    }

    @Override
    public void addNotify() {
        SymfonyOptions.getInstance().addChangeListener(this);
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        SymfonyOptions.getInstance().removeChangeListener(this);
        super.removeNotify();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public boolean isUseLts() {
        return this.ltsCheckBox.isSelected();
    }

    public String getErrorMessage() {
        ValidationResult result = new SymfonyOptionsValidator().validate().getResult();
        if (result.hasErrors()) {
            return ((ValidationResult.Message)result.getErrors().get(0)).getMessage();
        }
        if (result.hasWarnings()) {
            return ((ValidationResult.Message)result.getWarnings().get(0)).getMessage();
        }
        return null;
    }

    private void init() {
        this.setComponents();
        this.optionsLabel.setMaximumSize(this.optionsLabel.getPreferredSize());
    }

    private void initListeners() {
        this.infoLabel.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NewProjectConfigurationPanel.this.enableOptionsLabel();
            }
        });
        this.enableOptionsLabel();
    }

    private void setComponents() {
        boolean showOther;
        String info;
        if (SymfonyOptions.getInstance().isUseInstaller()) {
            info = Bundle.NewProjectConfigurationPanel_info_installer();
            showOther = true;
        } else {
            info = Bundle.NewProjectConfigurationPanel_info_sandbox();
            showOther = false;
        }
        this.infoLabel.setText(info);
        this.ltsCheckBox.setVisible(showOther);
        this.noteLabel.setVisible(showOther);
    }

    void enableOptionsLabel() {
        this.optionsLabel.setVisible(this.infoLabel.isEnabled());
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.infoLabel = new JLabel();
        this.optionsLabel = new JLabel();
        this.ltsCheckBox = new JCheckBox();
        this.noteLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)"INFO");
        Mnemonics.setLocalizedText((JLabel)this.optionsLabel, (String)NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.optionsLabel.text"));
        this.optionsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                NewProjectConfigurationPanel.this.optionsLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                NewProjectConfigurationPanel.this.optionsLabelMousePressed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.ltsCheckBox, (String)NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.ltsCheckBox.text"));
        Mnemonics.setLocalizedText((JLabel)this.noteLabel, (String)NbBundle.getMessage(NewProjectConfigurationPanel.class, (String)"NewProjectConfigurationPanel.noteLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.infoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.optionsLabel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.ltsCheckBox).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.noteLabel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.optionsLabel, -2, -1, -2).addComponent(this.infoLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ltsCheckBox).addGap(18, 18, 18).addComponent(this.noteLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void optionsLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void optionsLabelMousePressed(MouseEvent evt) {
        OptionsDisplayer.getDefault().open(SymfonyOptionsPanelController.getOptionsPath());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setComponents();
        this.fireChange();
    }
}

