/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.lex.impl.ScratchBufferStatics;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeMemory;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.support.BumpPtrAllocator;
import org.llvm.support.MemoryBuffer;

public class ScratchBuffer
implements Destructors.ClassWithDestructor {
    private final SourceManager SourceMgr;
    final BumpPtrAllocator Allocator = new BumpPtrAllocator();
    private char.ptr CurBuffer;
    private int BufferStartLoc;
    private int BytesUsed;

    public ScratchBuffer(SourceManager SM) {
        this.SourceMgr = SM;
        this.CurBuffer = null;
        this.BufferStartLoc = SourceLocation.getInvalid();
        this.BytesUsed = ScratchBufferStatics.ScratchBufSize;
    }

    public int getToken(char.ptr Buf, int Len, char.ptr DestPtr) {
        assert (DestPtr.$isNull()) : "" + DestPtr;
        if (Unsigned.$greater_uint((int)(this.BytesUsed + Len + 2), (int)ScratchBufferStatics.ScratchBufSize)) {
            this.AllocScratchBuffer(Len + 2);
        }
        this.CurBuffer.$set(this.BytesUsed++, (byte)10);
        DestPtr.$assign((Object)this.CurBuffer);
        DestPtr.$inc(this.BytesUsed);
        std.memcpy((byte[])DestPtr.$array(), (int)DestPtr.$index(), (char.ptr)Buf, (int)0, (int)Len);
        this.BytesUsed += Len + 1;
        this.CurBuffer.$set(this.BytesUsed - 1, (byte)0);
        return SourceLocation.$getLocWithOffset((int)this.BufferStartLoc, (int)(this.BytesUsed - Len - 1));
    }

    public int getToken(byte[] Buf, int idx, int Len, char.ptr DestPtr) {
        assert (DestPtr.$isNull()) : "" + DestPtr;
        if (Unsigned.$greater_uint((int)(this.BytesUsed + Len + 2), (int)ScratchBufferStatics.ScratchBufSize)) {
            this.AllocScratchBuffer(Len + 2);
        }
        this.CurBuffer.$set(this.BytesUsed++, (byte)10);
        assert (DestPtr != null && this.CurBuffer.getClass().isAssignableFrom(DestPtr.getClass())) : "non assignable " + this.CurBuffer + " for " + DestPtr;
        DestPtr.$assign((Object)this.CurBuffer);
        DestPtr.$inc(this.BytesUsed);
        std.memcpy((byte[])DestPtr.$array(), (int)DestPtr.$index(), (byte[])Buf, (int)idx, (int)Len);
        this.BytesUsed += Len + 1;
        this.CurBuffer.$set(this.BytesUsed - 1, (byte)0);
        return SourceLocation.$getLocWithOffset((int)this.BufferStartLoc, (int)(this.BytesUsed - Len - 1));
    }

    private void AllocScratchBuffer(int RequestLen) {
        std_ptr.unique_ptr OwnBuf = null;
        if (Unsigned.$less_uint((int)RequestLen, (int)ScratchBufferStatics.ScratchBufSize)) {
            RequestLen = ScratchBufferStatics.ScratchBufSize;
        }
        OwnBuf = MemoryBuffer.getNewMemBuffer((NativeMemory.Allocator)this.Allocator, (int)RequestLen, (StringRef)StringRef.R$scratch_space_marker);
        MemoryBuffer Buf = (MemoryBuffer)OwnBuf.$star();
        int FID = this.SourceMgr.createFileID(OwnBuf);
        this.BufferStartLoc = this.SourceMgr.getLocForStartOfFile(FID);
        this.CurBuffer = Native.$tryClone((char.ptr)Buf.getBufferStart());
        this.BytesUsed = 0;
    }

    public void $destroy() {
        this.Allocator.$destroy();
    }

    public String toString() {
        return ", CurBuffer=" + this.CurBuffer + ", BufferStartLoc=" + this.BufferStartLoc + ", BytesUsed=" + this.BytesUsed;
    }
}

