/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.ProductCode;
import com.amazonaws.services.ec2.model.StateReason;
import com.amazonaws.services.ec2.model.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Image {
    private String imageId;
    private String imageLocation;
    private String state;
    private String ownerId;
    private Boolean publicValue;
    private List<ProductCode> productCodes;
    private String architecture;
    private String imageType;
    private String kernelId;
    private String ramdiskId;
    private String platform;
    private StateReason stateReason;
    private String imageOwnerAlias;
    private String name;
    private String description;
    private String rootDeviceType;
    private String rootDeviceName;
    private List<BlockDeviceMapping> blockDeviceMappings;
    private String virtualizationType;
    private List<Tag> tags;

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public Image withImageId(String imageId) {
        this.imageId = imageId;
        return this;
    }

    public String getImageLocation() {
        return this.imageLocation;
    }

    public void setImageLocation(String imageLocation) {
        this.imageLocation = imageLocation;
    }

    public Image withImageLocation(String imageLocation) {
        this.imageLocation = imageLocation;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Image withState(String state) {
        this.state = state;
        return this;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public Image withOwnerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public Boolean isPublic() {
        return this.publicValue;
    }

    public void setPublic(Boolean publicValue) {
        this.publicValue = publicValue;
    }

    public Image withPublic(Boolean publicValue) {
        this.publicValue = publicValue;
        return this;
    }

    public Boolean getPublic() {
        return this.publicValue;
    }

    public List<ProductCode> getProductCodes() {
        if (this.productCodes == null) {
            this.productCodes = new ArrayList<ProductCode>();
        }
        return this.productCodes;
    }

    public void setProductCodes(Collection<ProductCode> productCodes) {
        ArrayList<ProductCode> productCodesCopy = new ArrayList<ProductCode>();
        if (productCodes != null) {
            productCodesCopy.addAll(productCodes);
        }
        this.productCodes = productCodesCopy;
    }

    public Image withProductCodes(ProductCode ... productCodes) {
        for (ProductCode value : productCodes) {
            this.getProductCodes().add(value);
        }
        return this;
    }

    public Image withProductCodes(Collection<ProductCode> productCodes) {
        ArrayList<ProductCode> productCodesCopy = new ArrayList<ProductCode>();
        if (productCodes != null) {
            productCodesCopy.addAll(productCodes);
        }
        this.productCodes = productCodesCopy;
        return this;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public Image withArchitecture(String architecture) {
        this.architecture = architecture;
        return this;
    }

    public String getImageType() {
        return this.imageType;
    }

    public void setImageType(String imageType) {
        this.imageType = imageType;
    }

    public Image withImageType(String imageType) {
        this.imageType = imageType;
        return this;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public void setKernelId(String kernelId) {
        this.kernelId = kernelId;
    }

    public Image withKernelId(String kernelId) {
        this.kernelId = kernelId;
        return this;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public void setRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
    }

    public Image withRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
        return this;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public Image withPlatform(String platform) {
        this.platform = platform;
        return this;
    }

    public StateReason getStateReason() {
        return this.stateReason;
    }

    public void setStateReason(StateReason stateReason) {
        this.stateReason = stateReason;
    }

    public Image withStateReason(StateReason stateReason) {
        this.stateReason = stateReason;
        return this;
    }

    public String getImageOwnerAlias() {
        return this.imageOwnerAlias;
    }

    public void setImageOwnerAlias(String imageOwnerAlias) {
        this.imageOwnerAlias = imageOwnerAlias;
    }

    public Image withImageOwnerAlias(String imageOwnerAlias) {
        this.imageOwnerAlias = imageOwnerAlias;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Image withName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Image withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getRootDeviceType() {
        return this.rootDeviceType;
    }

    public void setRootDeviceType(String rootDeviceType) {
        this.rootDeviceType = rootDeviceType;
    }

    public Image withRootDeviceType(String rootDeviceType) {
        this.rootDeviceType = rootDeviceType;
        return this;
    }

    public String getRootDeviceName() {
        return this.rootDeviceName;
    }

    public void setRootDeviceName(String rootDeviceName) {
        this.rootDeviceName = rootDeviceName;
    }

    public Image withRootDeviceName(String rootDeviceName) {
        this.rootDeviceName = rootDeviceName;
        return this;
    }

    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
        }
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        ArrayList<BlockDeviceMapping> blockDeviceMappingsCopy = new ArrayList<BlockDeviceMapping>();
        if (blockDeviceMappings != null) {
            blockDeviceMappingsCopy.addAll(blockDeviceMappings);
        }
        this.blockDeviceMappings = blockDeviceMappingsCopy;
    }

    public Image withBlockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
        for (BlockDeviceMapping value : blockDeviceMappings) {
            this.getBlockDeviceMappings().add(value);
        }
        return this;
    }

    public Image withBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        ArrayList<BlockDeviceMapping> blockDeviceMappingsCopy = new ArrayList<BlockDeviceMapping>();
        if (blockDeviceMappings != null) {
            blockDeviceMappingsCopy.addAll(blockDeviceMappings);
        }
        this.blockDeviceMappings = blockDeviceMappingsCopy;
        return this;
    }

    public String getVirtualizationType() {
        return this.virtualizationType;
    }

    public void setVirtualizationType(String virtualizationType) {
        this.virtualizationType = virtualizationType;
    }

    public Image withVirtualizationType(String virtualizationType) {
        this.virtualizationType = virtualizationType;
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        ArrayList<Tag> tagsCopy = new ArrayList<Tag>();
        if (tags != null) {
            tagsCopy.addAll(tags);
        }
        this.tags = tagsCopy;
    }

    public Image withTags(Tag ... tags) {
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public Image withTags(Collection<Tag> tags) {
        ArrayList<Tag> tagsCopy = new ArrayList<Tag>();
        if (tags != null) {
            tagsCopy.addAll(tags);
        }
        this.tags = tagsCopy;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("ImageId: " + this.imageId + ", ");
        sb.append("ImageLocation: " + this.imageLocation + ", ");
        sb.append("State: " + this.state + ", ");
        sb.append("OwnerId: " + this.ownerId + ", ");
        sb.append("Public: " + this.publicValue + ", ");
        sb.append("ProductCodes: " + this.productCodes + ", ");
        sb.append("Architecture: " + this.architecture + ", ");
        sb.append("ImageType: " + this.imageType + ", ");
        sb.append("KernelId: " + this.kernelId + ", ");
        sb.append("RamdiskId: " + this.ramdiskId + ", ");
        sb.append("Platform: " + this.platform + ", ");
        sb.append("StateReason: " + this.stateReason + ", ");
        sb.append("ImageOwnerAlias: " + this.imageOwnerAlias + ", ");
        sb.append("Name: " + this.name + ", ");
        sb.append("Description: " + this.description + ", ");
        sb.append("RootDeviceType: " + this.rootDeviceType + ", ");
        sb.append("RootDeviceName: " + this.rootDeviceName + ", ");
        sb.append("BlockDeviceMappings: " + this.blockDeviceMappings + ", ");
        sb.append("VirtualizationType: " + this.virtualizationType + ", ");
        sb.append("Tags: " + this.tags + ", ");
        sb.append("}");
        return sb.toString();
    }
}

