/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitObjectType;
import org.netbeans.modules.git.remote.cli.GitTag;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.openide.util.Cancellable;

public class CreateTagCommand
extends GitCommand {
    public static final boolean KIT = false;
    private final boolean forceUpdate;
    private final String tagName;
    private final String taggedObject;
    private final String message;
    private final boolean signed;
    private GitTag tag;
    private final GitCommand.Revision revisionPlaseHolder;
    private final ProgressMonitor monitor;

    public CreateTagCommand(JGitRepository repository, GitClassFactory gitFactory, String tagName, String taggedObject, String message, boolean signed, boolean forceUpdate, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.monitor = monitor;
        this.tagName = tagName;
        this.taggedObject = taggedObject;
        this.message = message;
        this.signed = signed;
        this.forceUpdate = forceUpdate;
        this.revisionPlaseHolder = new GitCommand.Revision();
    }

    public GitTag getTag() {
        return this.tag;
    }

    @Override
    protected void prepare() throws GitException {
        this.setCommandsNumber(3);
        super.prepare();
        this.addArgument(0, "tag");
        if (this.signed) {
            this.addArgument(0, "-s");
        }
        if (this.forceUpdate) {
            this.addArgument(0, "-f");
        }
        if (this.message != null && !this.message.isEmpty()) {
            this.addArgument(0, "-m");
            this.addArgument(0, this.message.replace("\n", "\\n"));
        }
        this.addArgument(0, this.tagName);
        if (this.taggedObject != null) {
            this.addArgument(0, this.taggedObject);
        }
        this.addArgument(1, "show-ref");
        this.addArgument(1, "--tags");
        this.addArgument(1, this.tagName);
        this.addArgument(2, "show");
        this.addArgument(2, "--raw");
        this.addArgument(2, this.revisionPlaseHolder);
    }

    @Override
    protected void run() throws GitException {
        block5: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                final GitTag.TagContainer container = new GitTag.TagContainer();
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                    }
                }.runCLI();
                new GitCommand.Runner(canceled, 1){

                    @Override
                    public void outputParser(String output) throws GitException {
                        CreateTagCommand.parseShowRef(output, container);
                    }

                    @Override
                    protected void errorParser(String error) throws GitException {
                        CreateTagCommand.this.parseAddError(error);
                    }
                }.runCLI();
                if (container.id != null) {
                    this.revisionPlaseHolder.setContent(container.id);
                    new GitCommand.Runner(canceled, 2){

                        @Override
                        public void outputParser(String output) throws GitException {
                            CreateTagCommand.parseShowDetails(output, container);
                        }

                        @Override
                        protected void errorParser(String error) throws GitException {
                            CreateTagCommand.this.parseAddError(error);
                        }
                    }.runCLI();
                    this.tag = this.getClassFactory().createTag(container);
                }
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block5;
                throw new GitException(t);
            }
        }
    }

    static void parseShowRef(String output, GitTag.TagContainer container) {
        for (String line : output.split("\n")) {
            String[] s = line.split(" ");
            if (s.length != 2) continue;
            String rev = s[0];
            String ref = s[1];
            int i = ref.lastIndexOf(47);
            if (i <= 0) continue;
            container.id = rev;
            container.name = ref.substring(i + 1);
            container.ref = ref;
        }
    }

    static void parseShowDetails(String output, GitTag.TagContainer container) {
        State state = State.header;
        for (String line : output.split("\n")) {
            if (state == State.header) {
                if (line.startsWith("tag ")) continue;
                if (line.startsWith("Tagger:")) {
                    container.author = line.substring(7).trim();
                    continue;
                }
                if (line.startsWith("Date:")) {
                    container.time = line.substring(5).trim();
                    continue;
                }
                if (line.startsWith("commit")) {
                    state = State.object;
                } else {
                    state = State.message;
                    continue;
                }
            }
            if (state == State.message) {
                if (line.length() > 0) {
                    if (container.message == null) {
                        container.message = line.trim();
                        continue;
                    }
                    container.message = container.message + "\n" + line.trim();
                    continue;
                }
                state = State.object;
                continue;
            }
            if (state != State.object) continue;
            if (line.startsWith("commit")) {
                container.type = GitObjectType.COMMIT;
                container.objectId = line.substring(6).trim();
                break;
            }
            if (line.startsWith("tree")) {
                container.type = GitObjectType.TREE;
                container.objectId = line.substring(4).trim();
                break;
            }
            if (!line.startsWith("tag")) continue;
            container.type = GitObjectType.TAG;
            container.objectId = line.substring(3).trim();
            break;
        }
    }

    private void parseAddError(String error) {
        this.processMessages(error);
    }

    private static enum State {
        header,
        message,
        object;

    }
}

