/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.netbeans.modules.git.remote.cli.jgit.JGitConfig;

public final class GitRemoteConfig {
    private final List<String> uris;
    private final List<String> pushUris;
    private final List<String> fetchSpecs;
    private final List<String> pushSpecs;
    private final String remoteName;

    public GitRemoteConfig(String remoteName, List<String> uris, List<String> pushUris, List<String> fetchSpecs, List<String> pushSpecs) {
        this.remoteName = remoteName;
        this.uris = uris;
        this.pushUris = pushUris;
        this.fetchSpecs = fetchSpecs;
        this.pushSpecs = pushSpecs;
    }

    public GitRemoteConfig(JGitConfig config, String remoteName) {
        this.remoteName = remoteName;
        this.uris = new ArrayList<String>();
        String s = config.getString("remote", remoteName, "url");
        if (s != null) {
            this.uris.add(s);
        }
        s = config.getString("remote", remoteName, "pushurl");
        this.pushUris = new ArrayList<String>();
        if (s != null) {
            this.pushUris.add(s);
        }
        s = config.getString("remote", remoteName, "fetch");
        this.fetchSpecs = new ArrayList<String>();
        if (s != null) {
            this.fetchSpecs.add(s);
        }
        s = config.getString("remote", remoteName, "push");
        this.pushSpecs = new ArrayList<String>();
        if (s != null) {
            this.pushSpecs.add(s);
        }
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    public List<String> getUris() {
        return Collections.unmodifiableList(this.uris);
    }

    public List<String> getPushUris() {
        return Collections.unmodifiableList(this.pushUris);
    }

    public List<String> getFetchRefSpecs() {
        return Collections.unmodifiableList(this.fetchSpecs);
    }

    public List<String> getPushRefSpecs() {
        return Collections.unmodifiableList(this.pushSpecs);
    }

    private static List<String> getAsStrings(List<? extends Object> list) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Object object : list) {
            set.add(object.toString());
        }
        return new ArrayList<String>(set);
    }
}

