/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.modules.git.remote.cli.GitLineDetails;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.GitUser;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public final class GitBlameResult {
    private final VCSFileProxy blamedFile;
    private final int lineCount;
    private final GitLineDetails[] lineDetails;

    GitBlameResult(VCSFileProxy file, Map<String, GitBlameContent> result, JGitRepository repository) {
        this.blamedFile = file;
        TreeMap<Integer, GitLineDetails> lines = new TreeMap<Integer, GitLineDetails>();
        for (Map.Entry<String, GitBlameContent> entry : result.entrySet()) {
            GitBlameContent v = entry.getValue();
            GitRevisionInfo.GitRevCommit rev = new GitRevisionInfo.GitRevCommit();
            rev.autorAndMail = v.author + " " + v.author_mail;
            rev.autorTime = v.author_time + " " + v.author_tz;
            rev.commiterAndMail = v.committer + " " + v.committer_mail;
            rev.commiterTime = v.committer_time + " " + v.committer_tz;
            rev.message = v.summary;
            rev.revisionCode = v.revision;
            GitRevisionInfo revInfo = new GitRevisionInfo(rev, repository);
            VCSFileProxy sourceFile = VCSFileProxy.createFileProxy((VCSFileProxy)repository.getLocation(), (String)v.filename);
            GitUser author = revInfo.getAuthor();
            GitUser committer = revInfo.getCommitter();
            for (Map.Entry<Integer, LineInfo> e : v.lines.entrySet()) {
                lines.put(e.getKey(), new GitLineDetails(e.getValue().lineContent, revInfo, author, committer, sourceFile, e.getValue().line - 1));
            }
        }
        this.lineCount = lines.size();
        this.lineDetails = new GitLineDetails[this.lineCount];
        for (Map.Entry<String, GitBlameContent> entry : lines.entrySet()) {
            if ("0000000000000000000000000000000000000000".equals(((GitLineDetails)((Object)entry.getValue())).getRevisionInfo().getRevision())) continue;
            this.lineDetails[((Integer)((Object)entry.getKey())).intValue() - 1] = (GitLineDetails)((Object)entry.getValue());
        }
    }

    public VCSFileProxy getBlamedFile() {
        return this.blamedFile;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public GitLineDetails getLineDetails(int lineNumber) {
        return lineNumber < this.lineCount ? this.lineDetails[lineNumber] : null;
    }

    public static final class GitBlameContent {
        public String revision;
        public String author;
        public String author_mail;
        public String author_time;
        public String author_tz;
        public String committer;
        public String committer_mail;
        public String committer_time;
        public String committer_tz;
        public String summary;
        public String previous;
        public String filename;
        public HashMap<Integer, LineInfo> lines = new HashMap();
    }

    public static final class LineInfo {
        public int line;
        public String lineContent;
    }
}

