/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.project;

import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.modules.profiler.api.JavaPlatform;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.java.JavaProfilerSource;
import org.netbeans.modules.profiler.nbimpl.project.Bundle;
import org.netbeans.modules.profiler.spi.project.ProjectProfilingSupportProvider;
import org.openide.filesystems.FileObject;

public abstract class JavaProjectProfilingSupportProvider
extends ProjectProfilingSupportProvider.Basic {
    private final Project project;

    public boolean isProfilingSupported() {
        return true;
    }

    public boolean isAttachSupported() {
        return true;
    }

    public boolean isFileObjectSupported(FileObject file) {
        return file.hasExt("java");
    }

    public boolean areProfilingPointsSupported() {
        return true;
    }

    public void setupProjectSessionSettings(SessionSettings ss) {
        JavaPlatform platform = this.getProjectJavaPlatform();
        if (platform != null) {
            ss.setSystemArchitecture(platform.getPlatformArchitecture());
            ss.setJavaVersionString(platform.getPlatformJDKVersion());
            ss.setJavaExecutable(platform.getPlatformJavaFile());
        }
    }

    public boolean checkProjectCanBeProfiled(FileObject file) {
        if (file != null) {
            JavaProfilerSource src = JavaProfilerSource.createFrom((FileObject)file);
            if (src != null && !src.isRunnable()) {
                ProfilerDialogs.displayInfo((String)Bundle.NoMainMethodMsg(src.getTopLevelClass().getQualifiedName()));
                return false;
            }
            if (!this.isFileObjectSupported(file)) {
                return false;
            }
        }
        return super.checkProjectCanBeProfiled(file);
    }

    public synchronized JavaPlatform getProjectJavaPlatform() {
        JavaPlatform projectJavaPlatform = this.resolveProjectJavaPlatform();
        if (projectJavaPlatform != null && !MiscUtils.isSupportedJVM((Map)projectJavaPlatform.getSystemProperties())) {
            ProfilerDialogs.displayError((String)Bundle.UnsupportedJavaPlatform());
            return null;
        }
        return projectJavaPlatform;
    }

    protected abstract JavaPlatform resolveProjectJavaPlatform();

    protected final JavaPlatform getPlatformByName(String platformName) {
        if (platformName == null || platformName.equals("default_platform")) {
            return JavaPlatform.getDefaultPlatform();
        }
        return JavaPlatform.getJavaPlatformById((String)platformName);
    }

    protected final Project getProject() {
        return this.project;
    }

    protected JavaProjectProfilingSupportProvider(Project project) {
        this.project = project;
    }
}

