/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.target.impl;

import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitchUInt;
import org.llvm.support.ARM;
import org.llvm.support.ARMBuildAttrs;
import org.llvm.support.llvm;
import org.llvm.support.target.impl.TargetParserStatics;

public final class TargetParserARMGlobals {
    public static StringRef getCanonicalArchName(StringRef Arch) {
        int offset = StringRef.npos;
        StringRef A = new StringRef(Arch);
        StringRef Error2 = new StringRef(NativePointer.$EMPTY);
        if (A.startswith("arm64")) {
            offset = 5;
        } else if (A.startswith("arm")) {
            offset = 3;
        } else if (A.startswith("thumb")) {
            offset = 5;
        } else if (A.startswith("aarch64")) {
            offset = 7;
            if (A.find("eb") != StringRef.npos) {
                return Error2;
            }
            if (llvm.$eq_StringRef(A.substr(offset, 3), "_be")) {
                offset += 3;
            }
        }
        if (offset != StringRef.npos && llvm.$eq_StringRef(A.substr(offset, 2), "eb")) {
            offset += 2;
        } else if (A.endswith("eb")) {
            A.$assignMove(A.substr(0, A.size() - 2));
        }
        if (offset != StringRef.npos) {
            A.$assignMove(A.substr(offset));
        }
        if (A.empty()) {
            return new StringRef(JavaDifferentiators.JD.Move.INSTANCE, Arch);
        }
        if (offset != StringRef.npos) {
            if (A.$at(0) != 118 || std.isdigit((int)A.$at(1)) == 0) {
                return Error2;
            }
            if (A.find("eb") != StringRef.npos) {
                return Error2;
            }
        }
        return A;
    }

    public static StringRef getFPUName(int FPUKind2) {
        if (Unsigned.$greatereq_uint((int)FPUKind2, (int)ARM.FPUKind.FK_LAST.getValue())) {
            return new StringRef();
        }
        return TargetParserStatics.FPUNames[FPUKind2].getName();
    }

    public static int getFPUVersion(int FPUKind2) {
        if (Unsigned.$greatereq_uint((int)FPUKind2, (int)ARM.FPUKind.FK_LAST.getValue())) {
            return 0;
        }
        return TargetParserStatics.FPUNames[FPUKind2].FPUVersion.getValue();
    }

    public static int getFPUNeonSupportLevel(int FPUKind2) {
        if (Unsigned.$greatereq_uint((int)FPUKind2, (int)ARM.FPUKind.FK_LAST.getValue())) {
            return 0;
        }
        return TargetParserStatics.FPUNames[FPUKind2].NeonSupport.getValue();
    }

    public static int getFPURestriction(int FPUKind2) {
        if (Unsigned.$greatereq_uint((int)FPUKind2, (int)ARM.FPUKind.FK_LAST.getValue())) {
            return 0;
        }
        return TargetParserStatics.FPUNames[FPUKind2].Restriction.getValue();
    }

    public static boolean getFPUFeatures(int FPUKind2, std.vectorCharPtr Features) {
        if (Unsigned.$greatereq_uint((int)FPUKind2, (int)ARM.FPUKind.FK_LAST.getValue()) || FPUKind2 == ARM.FPUKind.FK_INVALID.getValue()) {
            return false;
        }
        switch (TargetParserStatics.FPUNames[FPUKind2].Restriction) {
            case FR_SP_D16: {
                Features.push_back(NativePointer.$((String)"+fp-only-sp"));
                Features.push_back(NativePointer.$((String)"+d16"));
                break;
            }
            case FR_D16: {
                Features.push_back(NativePointer.$((String)"-fp-only-sp"));
                Features.push_back(NativePointer.$((String)"+d16"));
                break;
            }
            case FR_None: {
                Features.push_back(NativePointer.$((String)"-fp-only-sp"));
                Features.push_back(NativePointer.$((String)"-d16"));
            }
        }
        switch (TargetParserStatics.FPUNames[FPUKind2].FPUVersion) {
            case FV_VFPV5: {
                Features.push_back(NativePointer.$((String)"+fp-armv8"));
                break;
            }
            case FV_VFPV4: {
                Features.push_back(NativePointer.$((String)"+vfp4"));
                Features.push_back(NativePointer.$((String)"-fp-armv8"));
                break;
            }
            case FV_VFPV3_FP16: {
                Features.push_back(NativePointer.$((String)"+vfp3"));
                Features.push_back(NativePointer.$((String)"+fp16"));
                Features.push_back(NativePointer.$((String)"-vfp4"));
                Features.push_back(NativePointer.$((String)"-fp-armv8"));
                break;
            }
            case FV_VFPV3: {
                Features.push_back(NativePointer.$((String)"+vfp3"));
                Features.push_back(NativePointer.$((String)"-fp16"));
                Features.push_back(NativePointer.$((String)"-vfp4"));
                Features.push_back(NativePointer.$((String)"-fp-armv8"));
                break;
            }
            case FV_VFPV2: {
                Features.push_back(NativePointer.$((String)"+vfp2"));
                Features.push_back(NativePointer.$((String)"-vfp3"));
                Features.push_back(NativePointer.$((String)"-fp16"));
                Features.push_back(NativePointer.$((String)"-vfp4"));
                Features.push_back(NativePointer.$((String)"-fp-armv8"));
                break;
            }
            case FV_NONE: {
                Features.push_back(NativePointer.$((String)"-vfp2"));
                Features.push_back(NativePointer.$((String)"-vfp3"));
                Features.push_back(NativePointer.$((String)"-fp16"));
                Features.push_back(NativePointer.$((String)"-vfp4"));
                Features.push_back(NativePointer.$((String)"-fp-armv8"));
            }
        }
        switch (TargetParserStatics.FPUNames[FPUKind2].NeonSupport) {
            case NS_Crypto: {
                Features.push_back(NativePointer.$((String)"+neon"));
                Features.push_back(NativePointer.$((String)"+crypto"));
                break;
            }
            case NS_Neon: {
                Features.push_back(NativePointer.$((String)"+neon"));
                Features.push_back(NativePointer.$((String)"-crypto"));
                break;
            }
            case NS_None: {
                Features.push_back(NativePointer.$((String)"-neon"));
                Features.push_back(NativePointer.$((String)"-crypto"));
            }
        }
        return true;
    }

    public static boolean getHWDivFeatures(int HWDivKind, std.vectorCharPtr Features) {
        if (HWDivKind == 0) {
            return false;
        }
        if ((HWDivKind & 0x20) != 0) {
            Features.push_back(NativePointer.$((String)"+hwdiv-arm"));
        } else {
            Features.push_back(NativePointer.$((String)"-hwdiv-arm"));
        }
        if ((HWDivKind & 0x10) != 0) {
            Features.push_back(NativePointer.$((String)"+hwdiv"));
        } else {
            Features.push_back(NativePointer.$((String)"-hwdiv"));
        }
        return true;
    }

    public static boolean getExtensionFeatures(int Extensions, std.vectorCharPtr Features) {
        if (Extensions == 0) {
            return false;
        }
        if ((Extensions & 2) != 0) {
            Features.push_back(NativePointer.$((String)"+crc"));
        } else {
            Features.push_back(NativePointer.$((String)"-crc"));
        }
        if ((Extensions & 0x400) != 0) {
            Features.push_back(NativePointer.$((String)"+dsp"));
        } else {
            Features.push_back(NativePointer.$((String)"-dsp"));
        }
        return TargetParserARMGlobals.getHWDivFeatures(Extensions, Features);
    }

    public static StringRef getArchName(int ArchKind2) {
        if (Unsigned.$greatereq_uint((int)ArchKind2, (int)ARM.ArchKind.AK_LAST.getValue())) {
            return new StringRef();
        }
        return TargetParserStatics.ARCHNames[ArchKind2].getName();
    }

    public static int getArchAttr(int ArchKind2) {
        if (Unsigned.$greatereq_uint((int)ArchKind2, (int)ARM.ArchKind.AK_LAST.getValue())) {
            return ARMBuildAttrs.CPUArch.Pre_v4.getValue();
        }
        return TargetParserStatics.ARCHNames[ArchKind2].ArchAttr.getValue();
    }

    public static StringRef getCPUAttr(int ArchKind2) {
        if (Unsigned.$greatereq_uint((int)ArchKind2, (int)ARM.ArchKind.AK_LAST.getValue())) {
            return new StringRef();
        }
        return TargetParserStatics.ARCHNames[ArchKind2].getCPUAttr();
    }

    public static StringRef getSubArch(int ArchKind2) {
        if (Unsigned.$greatereq_uint((int)ArchKind2, (int)ARM.ArchKind.AK_LAST.getValue())) {
            return new StringRef();
        }
        return TargetParserStatics.ARCHNames[ArchKind2].getSubArch();
    }

    public static StringRef getArchExtName(int ArchExtKind2) {
        for (TargetParserStatics.Unnamed_struct2 AE : TargetParserStatics.ARCHExtNames) {
            if (ArchExtKind2 != AE.ID) continue;
            return AE.getName();
        }
        return new StringRef();
    }

    public static char.ptr getArchExtFeature(StringRef ArchExt) {
        if (ArchExt.startswith("no")) {
            StringRef ArchExtBase = ArchExt.substr(2);
            TargetParserStatics.Unnamed_struct2[] unnamed_struct2Array = TargetParserStatics.ARCHExtNames;
            int n = unnamed_struct2Array.length;
            for (int i = 0; i < n; ++i) {
                TargetParserStatics.Unnamed_struct2 AE = unnamed_struct2Array[i];
                if (AE.NegFeature == null || !llvm.$eq_StringRef(ArchExtBase, AE.getName())) continue;
                return AE.NegFeature;
            }
        }
        for (TargetParserStatics.Unnamed_struct2 AE : TargetParserStatics.ARCHExtNames) {
            if (AE.Feature == null || !llvm.$eq_StringRef(ArchExt, AE.getName())) continue;
            return AE.Feature;
        }
        return null;
    }

    public static StringRef getHWDivName(int HWDivKind) {
        for (TargetParserStatics.Unnamed_struct3 D : TargetParserStatics.HWDivNames) {
            if (HWDivKind != D.ID) continue;
            return D.getName();
        }
        return new StringRef();
    }

    public static int getDefaultFPU(StringRef CPU, int ArchKind2) {
        if (llvm.$eq_StringRef(CPU, "generic")) {
            return TargetParserStatics.ARCHNames[ArchKind2].DefaultFPU;
        }
        return new StringSwitchUInt(CPU).Case("arm2", ARM.FPUKind.FK_NONE.getValue()).Case("arm3", ARM.FPUKind.FK_NONE.getValue()).Case("arm6", ARM.FPUKind.FK_NONE.getValue()).Case("arm7m", ARM.FPUKind.FK_NONE.getValue()).Case("arm8", ARM.FPUKind.FK_NONE.getValue()).Case("arm810", ARM.FPUKind.FK_NONE.getValue()).Case("strongarm", ARM.FPUKind.FK_NONE.getValue()).Case("strongarm110", ARM.FPUKind.FK_NONE.getValue()).Case("strongarm1100", ARM.FPUKind.FK_NONE.getValue()).Case("strongarm1110", ARM.FPUKind.FK_NONE.getValue()).Case("arm7tdmi", ARM.FPUKind.FK_NONE.getValue()).Case("arm7tdmi-s", ARM.FPUKind.FK_NONE.getValue()).Case("arm710t", ARM.FPUKind.FK_NONE.getValue()).Case("arm720t", ARM.FPUKind.FK_NONE.getValue()).Case("arm9", ARM.FPUKind.FK_NONE.getValue()).Case("arm9tdmi", ARM.FPUKind.FK_NONE.getValue()).Case("arm920", ARM.FPUKind.FK_NONE.getValue()).Case("arm920t", ARM.FPUKind.FK_NONE.getValue()).Case("arm922t", ARM.FPUKind.FK_NONE.getValue()).Case("arm9312", ARM.FPUKind.FK_NONE.getValue()).Case("arm940t", ARM.FPUKind.FK_NONE.getValue()).Case("ep9312", ARM.FPUKind.FK_NONE.getValue()).Case("arm10tdmi", ARM.FPUKind.FK_NONE.getValue()).Case("arm1020t", ARM.FPUKind.FK_NONE.getValue()).Case("arm9e", ARM.FPUKind.FK_NONE.getValue()).Case("arm946e-s", ARM.FPUKind.FK_NONE.getValue()).Case("arm966e-s", ARM.FPUKind.FK_NONE.getValue()).Case("arm968e-s", ARM.FPUKind.FK_NONE.getValue()).Case("arm10e", ARM.FPUKind.FK_NONE.getValue()).Case("arm1020e", ARM.FPUKind.FK_NONE.getValue()).Case("arm1022e", ARM.FPUKind.FK_NONE.getValue()).Case("arm926ej-s", ARM.FPUKind.FK_NONE.getValue()).Case("arm1136j-s", ARM.FPUKind.FK_NONE.getValue()).Case("arm1136jf-s", ARM.FPUKind.FK_VFPV2.getValue()).Case("arm1136jz-s", ARM.FPUKind.FK_NONE.getValue()).Case("arm1176j-s", ARM.FPUKind.FK_NONE.getValue()).Case("arm1176jz-s", ARM.FPUKind.FK_NONE.getValue()).Case("mpcore", ARM.FPUKind.FK_VFPV2.getValue()).Case("mpcorenovfp", ARM.FPUKind.FK_NONE.getValue()).Case("arm1176jzf-s", ARM.FPUKind.FK_VFPV2.getValue()).Case("arm1156t2-s", ARM.FPUKind.FK_NONE.getValue()).Case("arm1156t2f-s", ARM.FPUKind.FK_VFPV2.getValue()).Case("cortex-m0", ARM.FPUKind.FK_NONE.getValue()).Case("cortex-m0plus", ARM.FPUKind.FK_NONE.getValue()).Case("cortex-m1", ARM.FPUKind.FK_NONE.getValue()).Case("sc000", ARM.FPUKind.FK_NONE.getValue()).Case("cortex-a5", ARM.FPUKind.FK_NEON_VFPV4.getValue()).Case("cortex-a7", ARM.FPUKind.FK_NEON_VFPV4.getValue()).Case("cortex-a8", ARM.FPUKind.FK_NEON.getValue()).Case("cortex-a9", ARM.FPUKind.FK_NEON_FP16.getValue()).Case("cortex-a12", ARM.FPUKind.FK_NEON_VFPV4.getValue()).Case("cortex-a15", ARM.FPUKind.FK_NEON_VFPV4.getValue()).Case("cortex-a17", ARM.FPUKind.FK_NEON_VFPV4.getValue()).Case("krait", ARM.FPUKind.FK_NEON_VFPV4.getValue()).Case("cortex-r4", ARM.FPUKind.FK_NONE.getValue()).Case("cortex-r4f", ARM.FPUKind.FK_VFPV3_D16.getValue()).Case("cortex-r5", ARM.FPUKind.FK_VFPV3_D16.getValue()).Case("cortex-r7", ARM.FPUKind.FK_VFPV3_D16_FP16.getValue()).Case("sc300", ARM.FPUKind.FK_NONE.getValue()).Case("cortex-m3", ARM.FPUKind.FK_NONE.getValue()).Case("cortex-m4", ARM.FPUKind.FK_FPV4_SP_D16.getValue()).Case("cortex-m7", ARM.FPUKind.FK_FPV5_D16.getValue()).Case("cortex-a35", ARM.FPUKind.FK_CRYPTO_NEON_FP_ARMV8.getValue()).Case("cortex-a53", ARM.FPUKind.FK_CRYPTO_NEON_FP_ARMV8.getValue()).Case("cortex-a57", ARM.FPUKind.FK_CRYPTO_NEON_FP_ARMV8.getValue()).Case("cortex-a72", ARM.FPUKind.FK_CRYPTO_NEON_FP_ARMV8.getValue()).Case("cyclone", ARM.FPUKind.FK_CRYPTO_NEON_FP_ARMV8.getValue()).Case("exynos-m1", ARM.FPUKind.FK_CRYPTO_NEON_FP_ARMV8.getValue()).Case("iwmmxt", ARM.FPUKind.FK_NONE.getValue()).Case("xscale", ARM.FPUKind.FK_NONE.getValue()).Case("swift", ARM.FPUKind.FK_NEON_VFPV4.getValue()).Case("invalid", ARM.FPUKind.FK_INVALID.getValue()).Default(ARM.FPUKind.FK_INVALID.getValue());
    }

    public static int getDefaultExtensions(StringRef CPU, int _ArchKind) {
        if (llvm.$eq_StringRef(CPU, "generic")) {
            return TargetParserStatics.ARCHNames[_ArchKind].ArchBaseExtensions;
        }
        return new StringSwitchUInt(CPU).Case("arm2", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV2.getValue()].ArchBaseExtensions | 1).Case("arm3", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV2A.getValue()].ArchBaseExtensions | 1).Case("arm6", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV3.getValue()].ArchBaseExtensions | 1).Case("arm7m", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV3M.getValue()].ArchBaseExtensions | 1).Case("arm8", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV4.getValue()].ArchBaseExtensions | 1).Case("arm810", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV4.getValue()].ArchBaseExtensions | 1).Case("strongarm", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV4.getValue()].ArchBaseExtensions | 1).Case("strongarm110", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV4.getValue()].ArchBaseExtensions | 1).Case("strongarm1100", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV4.getValue()].ArchBaseExtensions | 1).Case("strongarm1110", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV4.getValue()].ArchBaseExtensions | 1).Case("arm7tdmi", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV4T.getValue()].ArchBaseExtensions | 1).Case("arm7tdmi-s", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV4T.getValue()].ArchBaseExtensions | 1).Case("arm710t", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV4T.getValue()].ArchBaseExtensions | 1).Case("arm720t", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV4T.getValue()].ArchBaseExtensions | 1).Case("arm9", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV4T.getValue()].ArchBaseExtensions | 1).Case("arm9tdmi", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV4T.getValue()].ArchBaseExtensions | 1).Case("arm920", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV4T.getValue()].ArchBaseExtensions | 1).Case("arm920t", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV4T.getValue()].ArchBaseExtensions | 1).Case("arm922t", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV4T.getValue()].ArchBaseExtensions | 1).Case("arm9312", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV4T.getValue()].ArchBaseExtensions | 1).Case("arm940t", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV4T.getValue()].ArchBaseExtensions | 1).Case("ep9312", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV4T.getValue()].ArchBaseExtensions | 1).Case("arm10tdmi", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV5T.getValue()].ArchBaseExtensions | 1).Case("arm1020t", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV5T.getValue()].ArchBaseExtensions | 1).Case("arm9e", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV5TE.getValue()].ArchBaseExtensions | 1).Case("arm946e-s", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV5TE.getValue()].ArchBaseExtensions | 1).Case("arm966e-s", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV5TE.getValue()].ArchBaseExtensions | 1).Case("arm968e-s", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV5TE.getValue()].ArchBaseExtensions | 1).Case("arm10e", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV5TE.getValue()].ArchBaseExtensions | 1).Case("arm1020e", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV5TE.getValue()].ArchBaseExtensions | 1).Case("arm1022e", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV5TE.getValue()].ArchBaseExtensions | 1).Case("arm926ej-s", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV5TEJ.getValue()].ArchBaseExtensions | 1).Case("arm1136j-s", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV6.getValue()].ArchBaseExtensions | 1).Case("arm1136jf-s", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV6.getValue()].ArchBaseExtensions | 1).Case("arm1136jz-s", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV6.getValue()].ArchBaseExtensions | 1).Case("arm1176j-s", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV6K.getValue()].ArchBaseExtensions | 1).Case("arm1176jz-s", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV6KZ.getValue()].ArchBaseExtensions | 1).Case("mpcore", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV6K.getValue()].ArchBaseExtensions | 1).Case("mpcorenovfp", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV6K.getValue()].ArchBaseExtensions | 1).Case("arm1176jzf-s", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV6KZ.getValue()].ArchBaseExtensions | 1).Case("arm1156t2-s", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV6T2.getValue()].ArchBaseExtensions | 1).Case("arm1156t2f-s", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV6T2.getValue()].ArchBaseExtensions | 1).Case("cortex-m0", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV6M.getValue()].ArchBaseExtensions | 1).Case("cortex-m0plus", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV6M.getValue()].ArchBaseExtensions | 1).Case("cortex-m1", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV6M.getValue()].ArchBaseExtensions | 1).Case("sc000", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV6M.getValue()].ArchBaseExtensions | 1).Case("cortex-a5", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV7A.getValue()].ArchBaseExtensions | 0x140).Case("cortex-a7", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV7A.getValue()].ArchBaseExtensions | 0x370).Case("cortex-a8", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV7A.getValue()].ArchBaseExtensions | 0x100).Case("cortex-a9", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV7A.getValue()].ArchBaseExtensions | 0x140).Case("cortex-a12", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV7A.getValue()].ArchBaseExtensions | 0x370).Case("cortex-a15", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV7A.getValue()].ArchBaseExtensions | 0x370).Case("cortex-a17", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV7A.getValue()].ArchBaseExtensions | 0x370).Case("krait", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV7A.getValue()].ArchBaseExtensions | 0x30).Case("cortex-r4", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV7R.getValue()].ArchBaseExtensions | 1).Case("cortex-r4f", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV7R.getValue()].ArchBaseExtensions | 1).Case("cortex-r5", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV7R.getValue()].ArchBaseExtensions | 0x60).Case("cortex-r7", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV7R.getValue()].ArchBaseExtensions | 0x60).Case("sc300", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV7M.getValue()].ArchBaseExtensions | 1).Case("cortex-m3", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV7M.getValue()].ArchBaseExtensions | 1).Case("cortex-m4", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV7EM.getValue()].ArchBaseExtensions | 1).Case("cortex-m7", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV7EM.getValue()].ArchBaseExtensions | 1).Case("cortex-a35", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV8A.getValue()].ArchBaseExtensions | 2).Case("cortex-a53", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV8A.getValue()].ArchBaseExtensions | 2).Case("cortex-a57", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV8A.getValue()].ArchBaseExtensions | 2).Case("cortex-a72", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV8A.getValue()].ArchBaseExtensions | 2).Case("cyclone", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV8A.getValue()].ArchBaseExtensions | 2).Case("exynos-m1", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV8A.getValue()].ArchBaseExtensions | 2).Case("iwmmxt", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_IWMMXT.getValue()].ArchBaseExtensions | 1).Case("xscale", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_XSCALE.getValue()].ArchBaseExtensions | 1).Case("swift", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_ARMV7S.getValue()].ArchBaseExtensions | 0x30).Case("invalid", TargetParserStatics.ARCHNames[ARM.ArchKind.AK_INVALID.getValue()].ArchBaseExtensions | 0).Default(0);
    }

    public static StringRef getDefaultCPU(StringRef Arch) {
        int AK = TargetParserARMGlobals.parseArch(new StringRef(Arch));
        if (AK == ARM.ArchKind.AK_INVALID.getValue()) {
            return new StringRef();
        }
        for (TargetParserStatics.Unnamed_struct4 CPU : TargetParserStatics.CPUNames) {
            if (CPU.ArchID.getValue() != AK || !CPU.Default) continue;
            return CPU.getName();
        }
        return new StringRef(NativePointer.$generic);
    }

    public static int parseHWDiv(StringRef HWDiv) {
        StringRef Syn = TargetParserStatics.getHWDivSynonym(new StringRef(HWDiv));
        for (TargetParserStatics.Unnamed_struct3 D : TargetParserStatics.HWDivNames) {
            if (!llvm.$eq_StringRef(Syn, D.getName())) continue;
            return D.ID;
        }
        return 0;
    }

    public static int parseFPU(StringRef FPU) {
        StringRef Syn = TargetParserStatics.getFPUSynonym(new StringRef(FPU));
        for (TargetParserStatics.Unnamed_struct F : TargetParserStatics.FPUNames) {
            if (!llvm.$eq_StringRef(Syn, F.getName())) continue;
            return F.ID.getValue();
        }
        return ARM.FPUKind.FK_INVALID.getValue();
    }

    public static int parseArch(StringRef Arch) {
        Arch.$assignMove(TargetParserARMGlobals.getCanonicalArchName(Arch));
        StringRef Syn = TargetParserStatics.getArchSynonym(new StringRef(Arch));
        for (TargetParserStatics.Unnamed_struct1 A : TargetParserStatics.ARCHNames) {
            if (!A.getName().endswith(Syn)) continue;
            return A.ID.getValue();
        }
        return ARM.ArchKind.AK_INVALID.getValue();
    }

    public static int parseArchExt(StringRef ArchExt) {
        for (TargetParserStatics.Unnamed_struct2 A : TargetParserStatics.ARCHExtNames) {
            if (!llvm.$eq_StringRef(ArchExt, A.getName())) continue;
            return A.ID;
        }
        return 0;
    }

    public static int parseCPUArch(StringRef CPU) {
        for (TargetParserStatics.Unnamed_struct4 C : TargetParserStatics.CPUNames) {
            if (!llvm.$eq_StringRef(CPU, C.getName())) continue;
            return C.ArchID.getValue();
        }
        return ARM.ArchKind.AK_INVALID.getValue();
    }

    public static int parseArchISA(StringRef Arch) {
        return new StringSwitchUInt(Arch).StartsWith("aarch64", ARM.ISAKind.IK_AARCH64.getValue()).StartsWith("arm64", ARM.ISAKind.IK_AARCH64.getValue()).StartsWith("thumb", ARM.ISAKind.IK_THUMB.getValue()).StartsWith("arm", ARM.ISAKind.IK_ARM.getValue()).Default(ARM.EndianKind.EK_INVALID.getValue());
    }

    public static int parseArchEndian(StringRef Arch) {
        if (Arch.startswith("armeb") || Arch.startswith("thumbeb") || Arch.startswith("aarch64_be")) {
            return ARM.EndianKind.EK_BIG.getValue();
        }
        if (Arch.startswith("arm") || Arch.startswith("thumb")) {
            if (Arch.endswith("eb")) {
                return ARM.EndianKind.EK_BIG.getValue();
            }
            return ARM.EndianKind.EK_LITTLE.getValue();
        }
        if (Arch.startswith("aarch64")) {
            return ARM.EndianKind.EK_LITTLE.getValue();
        }
        return ARM.EndianKind.EK_INVALID.getValue();
    }

    public static int parseArchProfile(StringRef Arch) {
        Arch.$assignMove(TargetParserARMGlobals.getCanonicalArchName(Arch));
        switch (ARM.ArchKind.valueOf(TargetParserARMGlobals.parseArch(new StringRef(Arch)))) {
            case AK_ARMV6M: 
            case AK_ARMV7M: 
            case AK_ARMV7EM: {
                return ARM.ProfileKind.PK_M.getValue();
            }
            case AK_ARMV7R: {
                return ARM.ProfileKind.PK_R.getValue();
            }
            case AK_ARMV7A: 
            case AK_ARMV7K: 
            case AK_ARMV8A: 
            case AK_ARMV8_1A: 
            case AK_ARMV8_2A: {
                return ARM.ProfileKind.PK_A.getValue();
            }
        }
        return ARM.ProfileKind.PK_INVALID.getValue();
    }

    public static int parseArchVersion(StringRef Arch) {
        Arch.$assignMove(TargetParserARMGlobals.getCanonicalArchName(Arch));
        switch (ARM.ArchKind.valueOf(TargetParserARMGlobals.parseArch(new StringRef(Arch)))) {
            case AK_ARMV2: 
            case AK_ARMV2A: {
                return 2;
            }
            case AK_ARMV3: 
            case AK_ARMV3M: {
                return 3;
            }
            case AK_ARMV4: 
            case AK_ARMV4T: {
                return 4;
            }
            case AK_ARMV5T: 
            case AK_ARMV5TE: 
            case AK_IWMMXT: 
            case AK_IWMMXT2: 
            case AK_XSCALE: 
            case AK_ARMV5TEJ: {
                return 5;
            }
            case AK_ARMV6M: 
            case AK_ARMV6: 
            case AK_ARMV6K: 
            case AK_ARMV6T2: 
            case AK_ARMV6KZ: {
                return 6;
            }
            case AK_ARMV7M: 
            case AK_ARMV7EM: 
            case AK_ARMV7R: 
            case AK_ARMV7A: 
            case AK_ARMV7K: 
            case AK_ARMV7S: {
                return 7;
            }
            case AK_ARMV8A: 
            case AK_ARMV8_1A: 
            case AK_ARMV8_2A: {
                return 8;
            }
        }
        return 0;
    }
}

