/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.xref.impl;

import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.utils.cache.TextCache;

class ObjectReferenceImpl
implements CsmReference {
    private final CsmUID<CsmObject> targetDelegate;
    private final CsmUID<CsmObject> ownerDelegate;
    private final CsmUID<CsmObject> topDelegate;
    private final CsmUID<CsmFile> fileUID;
    private final int startPosition;
    private final int endPosition;
    private final CsmReferenceKind kind;

    ObjectReferenceImpl(CsmUID<CsmObject> target, CsmUID<CsmObject> owner, CsmUID<CsmObject> topUID, CsmUID<CsmFile> file, CsmReferenceKind kind, int startRef, int endRef) {
        this.targetDelegate = target;
        this.ownerDelegate = owner;
        this.topDelegate = topUID;
        this.fileUID = file;
        this.startPosition = startRef;
        this.endPosition = endRef;
        this.kind = kind;
    }

    @Override
    public CsmObject getReferencedObject() {
        return (CsmObject)this.targetDelegate.getObject();
    }

    @Override
    public CsmObject getOwner() {
        return (CsmObject)this.ownerDelegate.getObject();
    }

    @Override
    public CsmObject getClosestTopLevelObject() {
        return (CsmObject)this.topDelegate.getObject();
    }

    @Override
    public CsmReferenceKind getKind() {
        return this.kind;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectReferenceImpl other = (ObjectReferenceImpl)obj;
        if (this.startPosition != other.startPosition) {
            return false;
        }
        if (this.endPosition != other.endPosition) {
            return false;
        }
        if (!(this.targetDelegate == other.targetDelegate || this.targetDelegate != null && this.targetDelegate.equals(other.targetDelegate))) {
            return false;
        }
        if (!(this.ownerDelegate == other.ownerDelegate || this.ownerDelegate != null && this.ownerDelegate.equals(other.ownerDelegate))) {
            return false;
        }
        return this.fileUID == other.fileUID || this.fileUID != null && this.fileUID.equals(other.fileUID);
    }

    public int getStartOffset() {
        return this.startPosition;
    }

    public int getEndOffset() {
        return this.endPosition;
    }

    public CsmOffsetable.Position getStartPosition() {
        throw new UnsupportedOperationException("use getStartOffset instead");
    }

    public CsmOffsetable.Position getEndPosition() {
        throw new UnsupportedOperationException("use getEndOffset instead");
    }

    public CsmFile getContainingFile() {
        return this._getFile();
    }

    public CharSequence getText() {
        CsmFile file = this.getContainingFile();
        if (file != null) {
            return TextCache.getManager().getString(file.getText(this.getStartOffset(), this.getEndOffset()));
        }
        return "";
    }

    private CsmFile _getFile() {
        CsmFile file = (CsmFile)this.fileUID.getObject();
        return file;
    }

    protected String getOffsetString() {
        return "[" + this.getStartOffset() + "-" + this.getEndOffset() + "]";
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + this.startPosition;
        hash = 97 * hash + this.endPosition;
        hash = 97 * hash + (this.targetDelegate != null ? this.targetDelegate.hashCode() : 0);
        hash = 97 * hash + (this.ownerDelegate != null ? this.ownerDelegate.hashCode() : 0);
        hash = 97 * hash + (this.fileUID != null ? this.fileUID.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "Object Reference: " + (this.targetDelegate != null ? this.targetDelegate.toString() : this.getOffsetString());
    }
}

