/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.makeproject.api.wizards.BuildSupport;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SelectModePanel;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class SconsScriptSupport
implements BuildSupport.BuildFileProvider {
    private static final String[] pattern = new String[]{"SConstruct", "Sconstruct", "sconstruct"};

    public BuildSupport.BuildFile findBuildFileInFolder(FileObject folder, ExecutionEnvironment ee, CompilerSet compilerSet) {
        if (folder == null || !folder.isFolder() || !folder.canRead()) {
            return null;
        }
        for (String name : pattern) {
            FileObject makeFO = folder.getFileObject(name);
            if (makeFO == null || !makeFO.isValid() || !makeFO.isData() || !makeFO.canRead()) continue;
            return new SconsScriptArtifact(makeFO.getPath());
        }
        return null;
    }

    public BuildSupport.BuildFile scriptToBuildFile(String script) {
        String name = CndPathUtilities.getBaseName((String)script);
        if (name != null) {
            for (String predefined : pattern) {
                if (!predefined.equals(name)) continue;
                return new SconsScriptArtifact(script);
            }
        }
        return null;
    }

    public boolean isSupported(BuildSupport.BuildFile script) {
        return script instanceof SconsScriptArtifact;
    }

    public FileFilter[] getFileFilter() {
        return new FileFilter[]{FileFilterFactory.getSconsFileFilter()};
    }

    public String getHint() {
        return NbBundle.getMessage(SelectModePanel.class, (String)"SelectModeSimpleInstructionExtraText_Scons");
    }

    private static final class SconsScriptArtifact
    implements BuildSupport.BuildFile {
        private final String script;

        SconsScriptArtifact(String script) {
            this.script = script;
        }

        public String getFile() {
            return this.script;
        }

        public String getCleanCommandLine(String arguments, String workingDir) {
            String res = "scons --clean";
            if (arguments != null && !arguments.isEmpty()) {
                res = res + " " + arguments;
            }
            return res;
        }

        public String getBuildCommandLine(String arguments, String workingDir) {
            String res = "scons -i";
            if (arguments != null && !arguments.isEmpty()) {
                res = res + " " + arguments;
            }
            return res;
        }

        public String validate(ExecutionEnvironment ee, CompilerSet compilerSet) {
            return null;
        }
    }
}

