/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.spi.remote.setup.support.RemoteSyncNotifier;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.filesystems.FileSystem;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class RemoteSyncNotifierImpl
extends RemoteSyncNotifier {
    private static final RemoteSyncNotifierImpl INSTANCE = new RemoteSyncNotifierImpl();
    private final Set<ExecutionEnvironment> alreadyNotified = new HashSet<ExecutionEnvironment>();
    private final Object lock = new Object();

    public static RemoteSyncNotifierImpl getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(final ExecutionEnvironment env, final long fsSkew) {
        Object object = this.lock;
        synchronized (object) {
            if (this.alreadyNotified.contains(env)) {
                return;
            }
            this.alreadyNotified.add(env);
        }
        Runnable edtRunner = new Runnable(){

            @Override
            public void run() {
                String envString = env.getDisplayName();
                Object text = null;
                String title = NbBundle.getMessage(RemoteSyncNotifier.class, (String)"FS_Skew_Title", (Object)envString);
                ImageIcon icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/remote/sync/exclamation.gif", (boolean)false);
                CharSequence skewString = RemoteSyncNotifierImpl.secondsToString((long)fsSkew);
                skewString = fsSkew > 0L ? NbBundle.getMessage(RemoteSyncNotifier.class, (String)"FS_Skew_Faster", (Object)skewString) : NbBundle.getMessage(RemoteSyncNotifier.class, (String)"FS_Skew_Slower", (Object)skewString);
                String details = NbBundle.getMessage(RemoteSyncNotifier.class, (String)"FS_Skew_Details", (Object)envString, (Object)skewString);
                JComponent baloonComponent = RemoteSyncNotifierImpl.this.createDetails(details);
                JComponent popupComponent = RemoteSyncNotifierImpl.this.createDetails(details);
                Notification n = NotificationDisplayer.getDefault().notify(title, (Icon)icon, baloonComponent, popupComponent, NotificationDisplayer.Priority.HIGH, NotificationDisplayer.Category.WARNING);
            }
        };
        SwingUtilities.invokeLater(edtRunner);
    }

    private JComponent createDetails(String explanationText) {
        JPanel res = new JPanel(new BorderLayout());
        JLabel text = new JLabel(explanationText);
        text.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        res.add((Component)text, "Center");
        res.setOpaque(false);
        return res;
    }

    public static void arrangeComboBox(JComboBox cbSyncMode, ExecutionEnvironment execEnv) {
        ArrayList<RemoteSyncFactory> factories = new ArrayList<RemoteSyncFactory>();
        for (RemoteSyncFactory factory : RemoteSyncFactory.getFactories()) {
            if (!factory.isApplicable(execEnv)) continue;
            factories.add(factory);
        }
        cbSyncMode.setModel(new DefaultComboBoxModel<Object>(factories.toArray()));
        cbSyncMode.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                RemoteSyncFactory factory = (RemoteSyncFactory)value;
                if (factory != null) {
                    label.setText(factory.getDisplayName());
                    label.setToolTipText(factory.getDescription());
                }
                return label;
            }
        });
    }

    public void warnDoubleRemote(ExecutionEnvironment buildEnv, FileSystem sourceFileSystem) {
        ExecutionEnvironment sourceEnv = FileSystemProvider.getExecutionEnvironment((FileSystem)sourceFileSystem);
        String message = NbBundle.getMessage(RemoteSyncNotifier.class, (String)"ErrorDoubleRemote", (Object)buildEnv, (Object)sourceFileSystem);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
    }
}

