/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ScanDialog;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.ui.SelectClassPanel;
import org.netbeans.modules.websvc.wsitconf.util.AbstractTask;
import org.netbeans.modules.websvc.wsitconf.util.SourceUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ClassDialog {
    private Dialog dialog;
    private SelectClassPanel sPanel;
    private SelectClassDialogDesc dlgDesc;

    public ClassDialog(Project project, String extendingClass) {
        this.sPanel = new SelectClassPanel(project);
        this.dlgDesc = new SelectClassDialogDesc(this.sPanel, extendingClass);
        this.dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.dlgDesc);
    }

    public void show() {
        this.dialog.setVisible(true);
    }

    public boolean okButtonPressed() {
        return this.dlgDesc.getValue() == DialogDescriptor.OK_OPTION;
    }

    public Set<String> getSelectedClasses() {
        HashSet<String> selectedClasses = new HashSet<String>();
        Node[] nodes = this.sPanel.getSelectedNodes();
        for (int i = 0; i < nodes.length; ++i) {
            String name = this.getClassNameFromNode(nodes[i]);
            selectedClasses.add(name);
        }
        return selectedClasses;
    }

    private String getClassNameFromNode(Node node) {
        final String[] name = new String[1];
        FileObject classElement = (FileObject)node.getLookup().lookup(FileObject.class);
        JavaSource js = JavaSource.forFileObject((FileObject)classElement);
        try {
            js.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    SourceUtils sourceUtils = SourceUtils.newInstance(controller);
                    name[0] = sourceUtils.getTypeElement().getQualifiedName().toString();
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return name[0];
    }

    static class SelectClassDialogDesc
    extends DialogDescriptor {
        String extendingClass;
        final SelectClassPanel sPanel;
        private Object[] closingOptionsWithoutOK = new Object[]{DialogDescriptor.CANCEL_OPTION, DialogDescriptor.CLOSED_OPTION};
        private Object[] closingOptionsWithOK = new Object[]{DialogDescriptor.CANCEL_OPTION, DialogDescriptor.CLOSED_OPTION, DialogDescriptor.OK_OPTION};

        public SelectClassDialogDesc(SelectClassPanel sPanel, String extendingClass) {
            super((Object)sPanel, "Select Class");
            this.extendingClass = extendingClass;
            this.sPanel = sPanel;
            this.setButtonListener(new AddClassActionListener(sPanel));
        }

        private boolean isWantedClass(final JavaSource js) {
            if (this.extendingClass == null) {
                return true;
            }
            final Boolean[] subType = new Boolean[]{false};
            ScanDialog.runWhenScanFinished((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        js.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                            public void run(CompilationController controller) throws IOException {
                                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                SourceUtils sourceUtils = SourceUtils.newInstance(controller);
                                subType[0] = sourceUtils.isSubtype(SelectClassDialogDesc.this.extendingClass);
                            }
                        }, true);
                    }
                    catch (Throwable t) {
                        Logger.global.log(Level.INFO, t.getMessage());
                    }
                }
            }, (String)NbBundle.getMessage(ClassDialog.class, (String)"LBL_AnalyzeClass"));
            return subType[0];
        }

        class AddClassActionListener
        implements ActionListener {
            SelectClassPanel sPanel;

            public AddClassActionListener(SelectClassPanel sPanel) {
                this.sPanel = sPanel;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() == NotifyDescriptor.OK_OPTION) {
                    boolean accepted = false;
                    String errMsg = null;
                    Node[] selectedNodes = this.sPanel.getSelectedNodes();
                    if (selectedNodes.length != 1) {
                        errMsg = NbBundle.getMessage(ClassDialog.class, (String)"TXT_SelectOnlyOne_msg");
                    } else {
                        Node node = selectedNodes[0];
                        FileObject classElement = (FileObject)node.getLookup().lookup(FileObject.class);
                        if (classElement == null) {
                            errMsg = NbBundle.getMessage(ClassDialog.class, (String)"TXT_NoFileObject_msg");
                            Logger.global.log(Level.INFO, errMsg + ", " + node);
                        } else {
                            JavaSource js = JavaSource.forFileObject((FileObject)classElement);
                            if (js == null) {
                                errMsg = NbBundle.getMessage(ClassDialog.class, (String)"TXT_NotJavaClass_msg");
                            } else if (!SelectClassDialogDesc.this.isWantedClass(js)) {
                                errMsg = NbBundle.getMessage(ClassDialog.class, (String)"TXT_NotWantedClass_msg", (Object)classElement.getName(), (Object)SelectClassDialogDesc.this.extendingClass);
                            } else {
                                accepted = true;
                            }
                        }
                    }
                    if (!accepted) {
                        NotifyDescriptor.Message notifyDescr = new NotifyDescriptor.Message((Object)errMsg, 0);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)notifyDescr);
                        SelectClassDialogDesc.this.setClosingOptions(SelectClassDialogDesc.this.closingOptionsWithoutOK);
                    } else {
                        SelectClassDialogDesc.this.setClosingOptions(SelectClassDialogDesc.this.closingOptionsWithOK);
                    }
                }
            }
        }
    }
}

