/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.tools.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.driver.Driver;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.ToolsStatics;
import org.clang.driver.options;
import org.clank.java.std;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.ARM;
import org.llvm.support.llvm;
import org.llvm.support.sys.sys;

public final class ArmStatics {
    public static std.string getARMTargetCPU(StringRef CPU, StringRef Arch, Triple Triple2) {
        if (!CPU.empty()) {
            std.string MCPU = ((StringRef)new StringRef((StringRef)CPU).split((String)"+").first).lower();
            if (std.$eq_string$C_T((std.string)MCPU, (String)"native")) {
                return sys.getHostCPUName().$basic_string();
            }
            return MCPU;
        }
        return ArmStatics.getARMCPUForMArch(new StringRef(Arch), Triple2).$basic_string();
    }

    public static std.string getARMArch(StringRef Arch, Triple Triple2) {
        std.string CPU;
        std.string MArch = new std.string();
        if (!Arch.empty()) {
            MArch.$assignMove(Arch.$basic_string());
        } else {
            MArch.$assignMove(Triple2.getArchName().$basic_string());
        }
        MArch.$assignMove(((StringRef)new StringRef((std.string)MArch).split((String)"+").first).lower());
        if (std.$eq_string$C_T((std.string)MArch, (String)"native") && std.$noteq_string$C_T((std.string)(CPU = sys.getHostCPUName().$basic_string()), (String)"generic")) {
            StringRef Suffix = ArmStatics.getLLVMArchSuffixForARM(new StringRef(CPU), new StringRef(MArch), Triple2);
            if (Suffix.empty()) {
                MArch.$assign((CharSequence)"");
            } else {
                MArch.$assignMove(std.$add_string((std.string)new std.string((CharSequence)"arm"), (std.string)Suffix.str()));
            }
        }
        return MArch;
    }

    public static StringRef getARMCPUForMArch(StringRef Arch, Triple Triple2) {
        std.string MArch = ArmStatics.getARMArch(new StringRef(Arch), Triple2);
        if (MArch.empty()) {
            return new StringRef();
        }
        return Triple2.getARMCPUForArch(new StringRef(MArch));
    }

    public static StringRef getLLVMArchSuffixForARM(StringRef CPU, StringRef Arch, Triple Triple2) {
        int ArchKind2;
        if (llvm.$eq_StringRef((StringRef)CPU, (String)"generic")) {
            std.string ARMArch = ArmStatics.getARMArch(new StringRef(Arch), Triple2);
            ArchKind2 = ARM.parseArch((StringRef)new StringRef(ARMArch));
            if (ArchKind2 == ARM.ArchKind.AK_INVALID.getValue()) {
                ArchKind2 = ARM.parseCPUArch((StringRef)Triple2.getARMCPUForArch(new StringRef(ARMArch)));
            }
        } else {
            int n = ArchKind2 = llvm.$eq_StringRef((StringRef)Arch, (String)"armv7k") || llvm.$eq_StringRef((StringRef)Arch, (String)"thumbv7k") ? ARM.ArchKind.AK_ARMV7K.getValue() : ARM.parseCPUArch((StringRef)CPU);
        }
        if (ArchKind2 == ARM.ArchKind.AK_INVALID.getValue()) {
            return new StringRef(NativePointer.$EMPTY);
        }
        return ARM.getSubArch((int)ArchKind2);
    }

    public static void appendEBLinkFlags(ArgList Args, ArgStringList CmdArgs, Triple Triple2) {
        if (Args.hasArg(new OptSpecifier(options.ID.OPT_r.getValue()))) {
            return;
        }
        if (ToolsStatics.getARMSubArchVersionNumber(Triple2) >= 7 || ToolsStatics.isARMMProfile(Triple2)) {
            CmdArgs.push_back((Object)NativePointer.$((String)"--be8"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FloatABI getARMFloatABI(ToolChain TC, ArgList Args) {
        Driver D = TC.getDriver();
        Triple _Triple = new Triple(new Twine(TC.ComputeEffectiveClangTriple(Args)));
        int SubArch = ToolsStatics.getARMSubArchVersionNumber(_Triple);
        FloatABI ABI = FloatABI.Invalid;
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_msoft_float.getValue()), new OptSpecifier(options.ID.OPT_mhard_float.getValue()), new OptSpecifier(options.ID.OPT_mfloat_abi_EQ.getValue()));
        if (A != null) {
            JavaCleaner $c$;
            if (A.getOption().matches(new OptSpecifier(options.ID.OPT_msoft_float.getValue()))) {
                ABI = FloatABI.Soft;
            } else if (A.getOption().matches(new OptSpecifier(options.ID.OPT_mhard_float.getValue()))) {
                ABI = FloatABI.Hard;
            } else {
                ABI = (FloatABI)((Object)new StringSwitch(A.getValue()).Case("soft", (Object)FloatABI.Soft).Case("softfp", (Object)FloatABI.SoftFP).Case("hard", (Object)FloatABI.Hard).Default((Object)FloatABI.Invalid));
                if (ABI == FloatABI.Invalid && !new StringRef(A.getValue()).empty()) {
                    $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(329))), (StringRef)new StringRef(A.getAsString(Args))));
                        ABI = FloatABI.Soft;
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
            }
            if (_Triple.isOSBinFormatMachO() && !ToolsStatics.useAAPCSForMachO(_Triple) && ABI == FloatABI.Hard) {
                $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(365))), (StringRef)new StringRef(A.getAsString(Args))), (StringRef)_Triple.getArchName()));
                }
                finally {
                    $c$.$destroy();
                }
            }
        }
        if (ABI == FloatABI.Invalid) {
            block3 : switch (_Triple.getOS()) {
                case Darwin: 
                case MacOSX: 
                case IOS: 
                case TvOS: {
                    ABI = SubArch == 6 || SubArch == 7 ? FloatABI.SoftFP : FloatABI.Soft;
                    ABI = _Triple.isWatchABI() ? FloatABI.Hard : ABI;
                    break;
                }
                case WatchOS: {
                    ABI = FloatABI.Hard;
                    break;
                }
                case Win32: {
                    ABI = FloatABI.Hard;
                    break;
                }
                case FreeBSD: {
                    switch (_Triple.getEnvironment()) {
                        case GNUEABIHF: {
                            ABI = FloatABI.Hard;
                            break block3;
                        }
                    }
                    ABI = FloatABI.Soft;
                    break;
                }
                default: {
                    switch (_Triple.getEnvironment()) {
                        case GNUEABIHF: 
                        case MuslEABIHF: 
                        case EABIHF: {
                            ABI = FloatABI.Hard;
                            break block3;
                        }
                        case GNUEABI: 
                        case MuslEABI: 
                        case EABI: {
                            ABI = FloatABI.SoftFP;
                            break block3;
                        }
                        case Android: {
                            ABI = SubArch == 7 ? FloatABI.SoftFP : FloatABI.Soft;
                            break block3;
                        }
                    }
                    ABI = _Triple.isOSBinFormatMachO() && _Triple.getSubArch() == Triple.SubArchType.ARMSubArch_v7em ? FloatABI.Hard : FloatABI.Soft;
                    if (_Triple.getOS() == Triple.OSType.UnknownOS && _Triple.isOSBinFormatMachO()) break;
                    JavaCleaner $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(380))), (String)"soft"));
                        break;
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
            }
        }
        assert (ABI != FloatABI.Invalid) : "must select an ABI";
        return ABI;
    }

    public static final class FloatABI
    extends Enum<FloatABI>
    implements Native.ComparableLower {
        public static final /* enum */ FloatABI Invalid = new FloatABI(0);
        public static final /* enum */ FloatABI Soft = new FloatABI(Invalid.getValue() + 1);
        public static final /* enum */ FloatABI SoftFP = new FloatABI(Soft.getValue() + 1);
        public static final /* enum */ FloatABI Hard = new FloatABI(SoftFP.getValue() + 1);
        private final int value;
        private static final /* synthetic */ FloatABI[] $VALUES;

        public static FloatABI[] values() {
            return (FloatABI[])$VALUES.clone();
        }

        public static FloatABI valueOf(String name) {
            return Enum.valueOf(FloatABI.class, name);
        }

        public static FloatABI valueOf(int val) {
            FloatABI out;
            FloatABI floatABI = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private FloatABI(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_int((int)this.value, (int)((FloatABI)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_int((int)this.value, (int)((FloatABI)((Object)obj)).value);
        }

        static {
            $VALUES = new FloatABI[]{Invalid, Soft, SoftFP, Hard};
        }

        private static final class Values {
            private static final FloatABI[] VALUES;
            private static final FloatABI[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (FloatABI kind : FloatABI.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new FloatABI[min < 0 ? 1 - min : 0];
                VALUES = new FloatABI[max >= 0 ? 1 + max : 0];
                for (FloatABI kind : FloatABI.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((FloatABI)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((FloatABI)kind).value] = kind;
                }
            }
        }
    }
}

