/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.clone;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.ui.clone.CloneDestinationPanel;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class RepositoryStepPanel
extends JPanel {
    final JButton btnBrowseDestination = new JButton();
    private final JLabel jLabel1 = new JLabel();
    private final JLabel jLabel2 = new JLabel();
    private final JLabel jLabel3 = new JLabel();
    private final JPanel jPanel1 = new JPanel();
    private final JSeparator jSeparator1 = new JSeparator();
    final JLabel lblCloneName = new JLabel();
    private final JLabel lblDestination = new JLabel();
    final JPanel progressPanel = new JPanel();
    final JTextField txtDestination = new JTextField();

    public RepositoryStepPanel(JPanel repositoryPanel) {
        this.initComponents();
        this.txtDestination.setText(this.defaultWorkingDirectory().getPath());
        this.jPanel1.add(repositoryPanel);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setPreferredSize(this.getPreferredSize());
    }

    private void initComponents() {
        this.setMinimumSize(new Dimension(480, 160));
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/git/ui/clone/Bundle");
        this.setName(bundle.getString("BK2018"));
        this.setVerifyInputWhenFocusTarget(false);
        this.progressPanel.setLayout(null);
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 3));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(RepositoryStepPanel.class, (String)"LBL_RepositoryStepPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(RepositoryStepPanel.class, (String)"RepositoryStepPanel.jLabel1.text"));
        this.lblDestination.setLabelFor(this.txtDestination);
        Mnemonics.setLocalizedText((JLabel)this.lblDestination, (String)NbBundle.getMessage(RepositoryStepPanel.class, (String)"RepositoryStepPanel.lblDestination.text"));
        this.lblDestination.setToolTipText(NbBundle.getMessage(RepositoryStepPanel.class, (String)"RepositoryStepPanel.lblDestination.TTtext"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnBrowseDestination, (String)NbBundle.getMessage(RepositoryStepPanel.class, (String)"RepositoryStepPanel.btnBrowse.text"));
        this.btnBrowseDestination.setToolTipText(NbBundle.getMessage(RepositoryStepPanel.class, (String)"RepositoryStepPanel.btnBrowse.TTtext"));
        this.btnBrowseDestination.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepositoryStepPanel.this.btnBrowseDestinationActionPerformed(evt);
            }
        });
        this.jLabel3.setForeground(UIManager.getDefaults().getColor("Label.disabledForeground"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(RepositoryStepPanel.class, (String)"RepositoryStepPanel.destinationHint.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.progressPanel, -1, 574, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, 574, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addComponent(this.lblDestination).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.txtDestination).addGap(0, 0, 0).addComponent(this.lblCloneName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnBrowseDestination)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblDestination).addComponent(this.txtDestination, -2, -1, -2).addComponent(this.btnBrowseDestination).addComponent(this.lblCloneName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addGap(18, 18, Short.MAX_VALUE).addComponent(this.progressPanel, -2, 37, -2)));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RepositoryStepPanel.class, (String)"ACSD_RepositoryPanel"));
    }

    private void btnBrowseDestinationActionPerformed(ActionEvent evt) {
        FileFilter[] old;
        File oldFile = this.defaultWorkingDirectory();
        AccessibleJFileChooser fileChooser = new AccessibleJFileChooser(NbBundle.getMessage(CloneDestinationPanel.class, (String)"ACSD_BrowseFolder"), oldFile);
        fileChooser.setDialogTitle(NbBundle.getMessage(CloneDestinationPanel.class, (String)"Browse_title"));
        fileChooser.setMultiSelectionEnabled(false);
        for (FileFilter fileFilter : old = fileChooser.getChoosableFileFilters()) {
            fileChooser.removeChoosableFileFilter(fileFilter);
        }
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(CloneDestinationPanel.class, (String)"Folders");
            }
        });
        fileChooser.setFileSelectionMode(1);
        fileChooser.showDialog(this, NbBundle.getMessage(CloneDestinationPanel.class, (String)"OK_Button"));
        File f = fileChooser.getSelectedFile();
        if (f != null) {
            this.txtDestination.setText(f.getAbsolutePath());
        }
    }

    private File defaultWorkingDirectory() {
        File projectFolder;
        String cloneDir;
        File defaultDir = null;
        String current = this.txtDestination.getText();
        if (current != null && !current.trim().equals("")) {
            File currentFile;
            for (currentFile = new File(current); currentFile != null && !currentFile.exists(); currentFile = currentFile.getParentFile()) {
            }
            if (currentFile != null) {
                defaultDir = currentFile.isFile() ? currentFile.getParentFile() : currentFile;
            }
        }
        if (defaultDir == null && (cloneDir = GitModuleConfig.getDefault().getPreferences().get("cloneDestinationStep.cloneDirectory", null)) != null) {
            defaultDir = new File(cloneDir);
        }
        if (defaultDir == null && (projectFolder = ProjectChooser.getProjectsFolder()).exists() && projectFolder.isDirectory()) {
            defaultDir = projectFolder;
        }
        if (defaultDir == null) {
            defaultDir = new File(System.getProperty("user.home"));
        }
        return defaultDir;
    }
}

