/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.project.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.j2me.project.wizard.J2MEProjectWizardIterator;
import org.netbeans.modules.j2me.project.wizard.PanelConfigureProject;
import org.netbeans.modules.j2me.project.wizard.PlatformDevicesPanel;
import org.netbeans.modules.j2me.project.wizard.SettingsPanel;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class PanelOptionsVisual
extends SettingsPanel
implements PropertyChangeListener,
DocumentListener {
    private static boolean lastMainClassCheck = true;
    private final J2MEProjectWizardIterator.WizardType type;
    private PanelConfigureProject panel;
    private String currentLibrariesLocation;
    private String projectLocation;
    private boolean isMainClassValid;
    private PlatformDevicesPanel platformDevicesPanel;
    private JButton btnLibFolder;
    private JCheckBox cbSharable;
    private JCheckBox createMainCheckBox;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator2;
    private JLabel lblHint;
    private JLabel lblLibFolder;
    private JTextField mainClassTextField;
    private JPanel platformDevicesContainer;
    private JLabel progressLabel;
    private JPanel progressPanel;
    private JTextField txtLibFolder;

    PanelOptionsVisual(PanelConfigureProject panel, J2MEProjectWizardIterator.WizardType type) {
        this.panel = panel;
        this.type = type;
        this.preInitComponents();
        this.initComponents();
        this.postInitComponents();
    }

    private void preInitComponents() {
    }

    private void postInitComponents() {
        this.platformDevicesPanel = new PlatformDevicesPanel(this.panel, this.type);
        this.platformDevicesContainer.add((Component)this.platformDevicesPanel, "Center");
        this.currentLibrariesLocation = "." + File.separatorChar + "lib";
        this.txtLibFolder.setText(this.currentLibrariesLocation);
        this.cbSharableActionPerformed(null);
        switch (this.type) {
            case APPLICATION: {
                this.createMainCheckBox.setSelected(lastMainClassCheck);
                this.mainClassTextField.setEnabled(lastMainClassCheck);
                break;
            }
            case SAMPLE: {
                this.setBottomPanelAreaVisible(false);
            }
        }
        this.mainClassTextField.getDocument().addDocumentListener(this);
        this.txtLibFolder.getDocument().addDocumentListener(this);
        this.progressLabel.setVisible(false);
        this.progressPanel.setVisible(false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propName = event.getPropertyName();
        if ("projectName".equals(propName)) {
            String projectName = (String)event.getNewValue();
            this.mainClassTextField.setText(PanelOptionsVisual.createMainClassName(projectName, this.type));
        } else if ("projectLocation".equals(propName)) {
            this.projectLocation = (String)event.getNewValue();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentChanged(e.getDocument());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentChanged(e.getDocument());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.documentChanged(e.getDocument());
    }

    private void documentChanged(Document doc) {
        if (this.txtLibFolder.getDocument().equals(doc)) {
            this.librariesLocationChanged();
        } else if (this.mainClassTextField.getDocument().equals(doc)) {
            this.mainClassChanged();
        }
    }

    private static String createMainClassName(String projectName, J2MEProjectWizardIterator.WizardType type) {
        String part;
        StringBuilder pkg = new StringBuilder();
        StringBuilder main = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        boolean needsEscape = false;
        for (int i = 0; i < projectName.length(); ++i) {
            char c = projectName.charAt(i);
            if (first) {
                if (!Character.isJavaIdentifierStart(c)) {
                    if (!Character.isJavaIdentifierPart(c)) continue;
                    needsEscape = true;
                    sb.append(c);
                    first = false;
                    continue;
                }
                sb.append(c);
                first = false;
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
                continue;
            }
            if (sb.length() <= 0) continue;
            part = sb.toString();
            if (pkg.length() > 0) {
                pkg.append('.');
            }
            if (needsEscape || !Utilities.isJavaIdentifier((String)part.toLowerCase())) {
                pkg.append(NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_PackageNamePrefix"));
            }
            pkg.append(part.toLowerCase());
            if (!needsEscape || main.length() > 0) {
                main.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1));
            }
            sb = new StringBuilder();
            first = true;
            needsEscape = false;
        }
        if (sb.length() > 0) {
            part = sb.toString();
            if (pkg.length() > 0) {
                pkg.append('.');
            }
            if (needsEscape || !Utilities.isJavaIdentifier((String)part.toLowerCase())) {
                pkg.append(NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_PackageNamePrefix"));
            }
            pkg.append(part.toLowerCase());
            if (!needsEscape || main.length() > 0) {
                main.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1));
            }
        }
        if (main.length() == 0) {
            main.append(NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_MidletName"));
        }
        return pkg.length() == 0 ? main.toString() : String.format("%s.%s", pkg.toString(), main.toString());
    }

    private void initComponents() {
        this.cbSharable = new JCheckBox();
        this.lblLibFolder = new JLabel();
        this.createMainCheckBox = new JCheckBox();
        this.mainClassTextField = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.btnLibFolder = new JButton();
        this.lblHint = new JLabel();
        this.txtLibFolder = new JTextField();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.jPanel2 = new JPanel();
        this.progressLabel = new JLabel();
        this.progressPanel = new JPanel();
        this.platformDevicesContainer = new JPanel();
        this.setLayout(new GridBagLayout());
        this.cbSharable.setSelected(SharableLibrariesUtils.isLastProjectSharable());
        Mnemonics.setLocalizedText((AbstractButton)this.cbSharable, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_SharableProject_Checkbox"));
        this.cbSharable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.cbSharableActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.cbSharable, gridBagConstraints);
        this.cbSharable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSN_sharableProject"));
        this.cbSharable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_sharableProject"));
        this.lblLibFolder.setLabelFor(this.txtLibFolder);
        Mnemonics.setLocalizedText((JLabel)this.lblLibFolder, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_Location_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 768;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.add((Component)this.lblLibFolder, gridBagConstraints);
        this.lblLibFolder.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSN_labelLibrariesFolder"));
        this.lblLibFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_labelLibrariesFolder"));
        this.createMainCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createMainCheckBox, (String)NbBundle.getBundle(PanelOptionsVisual.class).getString("LBL_createMainCheckBox"));
        this.createMainCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PanelOptionsVisual.this.createMainCheckBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.insets = new Insets(25, 0, 0, 10);
        this.add((Component)this.createMainCheckBox, gridBagConstraints);
        this.createMainCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSN_createMainCheckBox"));
        this.createMainCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSD_createMainCheckBox"));
        this.mainClassTextField.setText("com.myapp.Midlet");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(25, 0, 0, 0);
        this.add((Component)this.mainClassTextField, gridBagConstraints);
        this.mainClassTextField.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelOptionsVisual.class).getString("ASCN_mainClassTextFiled"));
        this.mainClassTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelOptionsVisual.class).getString("ASCD_mainClassTextFiled"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 13, 0);
        this.add((Component)this.jSeparator2, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.btnLibFolder, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_Browse_Button"));
        this.btnLibFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.btnLibFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 768;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.btnLibFolder, gridBagConstraints);
        this.btnLibFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_browseLibraries"));
        Mnemonics.setLocalizedText((JLabel)this.lblHint, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"HINT_LibrariesFolder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel1.add((Component)this.lblHint, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.2;
        this.jPanel1.add((Component)this.txtLibFolder, gridBagConstraints);
        this.txtLibFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_LibrariesLocation"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        this.add((Component)this.filler1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.filler2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.jPanel2, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.progressLabel, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_Progress_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.progressLabel, gridBagConstraints);
        this.progressLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSN_progressLabel"));
        this.progressLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_progressLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.progressPanel, gridBagConstraints);
        this.platformDevicesContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.platformDevicesContainer, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSN_PanelOptionsVisual"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_PanelOptionsVisual"));
    }

    private void cbSharableActionPerformed(ActionEvent evt) {
        this.txtLibFolder.setEnabled(this.cbSharable.isSelected());
        this.btnLibFolder.setEnabled(this.cbSharable.isSelected());
        this.lblHint.setEnabled(this.cbSharable.isSelected());
        this.lblLibFolder.setEnabled(this.cbSharable.isSelected());
        if (this.cbSharable.isSelected()) {
            this.txtLibFolder.setText(this.currentLibrariesLocation);
        } else {
            this.txtLibFolder.setText("");
        }
    }

    private void btnLibFolderActionPerformed(ActionEvent evt) {
        File f = FileUtil.normalizeFile((File)new File(this.projectLocation + File.separatorChar + "project_folder"));
        String curr = SharableLibrariesUtils.browseForLibraryLocation((String)this.txtLibFolder.getText().trim(), (Component)this, (File)f);
        if (curr != null) {
            this.currentLibrariesLocation = curr;
            if (this.cbSharable.isSelected()) {
                this.txtLibFolder.setText(this.currentLibrariesLocation);
            }
        }
    }

    private void createMainCheckBoxItemStateChanged(ItemEvent evt) {
        lastMainClassCheck = this.createMainCheckBox.isSelected();
        this.mainClassTextField.setEnabled(lastMainClassCheck);
        this.panel.fireChangeEvent();
    }

    private void setBottomPanelAreaVisible(boolean visible) {
        this.cbSharable.setVisible(visible);
        this.lblLibFolder.setVisible(visible);
        this.jPanel1.setVisible(visible);
        this.txtLibFolder.setVisible(visible);
        this.btnLibFolder.setVisible(visible);
        this.lblHint.setVisible(visible);
        this.createMainCheckBox.setVisible(visible);
        this.mainClassTextField.setVisible(visible);
        this.jSeparator2.setVisible(visible);
    }

    @Override
    boolean valid(WizardDescriptor settings) {
        this.setBottomPanelAreaVisible(this.type != J2MEProjectWizardIterator.WizardType.SAMPLE);
        if (this.cbSharable.isSelected()) {
            String location = this.txtLibFolder.getText();
            if (this.projectLocation != null) {
                if (new File(location).isAbsolute()) {
                    settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"WARN_PanelOptionsVisual.absolutePath"));
                } else {
                    File projectLoc = FileUtil.normalizeFile((File)new File(this.projectLocation));
                    File libLoc = PropertyUtils.resolveFile((File)projectLoc, (String)location);
                    if (!CollocationQuery.areCollocated((URI)projectLoc.toURI(), (URI)libLoc.toURI())) {
                        settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"WARN_PanelOptionsVisual.relativePath"));
                    }
                }
            }
        }
        if (this.mainClassTextField.isVisible() && this.mainClassTextField.isEnabled() && !this.isMainClassValid) {
            settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"ERROR_IllegalMainClassName"));
            return false;
        }
        return this.platformDevicesPanel.valid(settings);
    }

    @Override
    synchronized void read(WizardDescriptor d) {
        this.platformDevicesPanel.read(d);
    }

    @Override
    void validate(WizardDescriptor d) throws WizardValidationException {
        this.platformDevicesPanel.validate(d);
    }

    @Override
    void store(WizardDescriptor d) {
        d.putProperty("mainClass", this.createMainCheckBox.isSelected() && this.createMainCheckBox.isVisible() ? this.mainClassTextField.getText() : null);
        d.putProperty("sharedLibraries", this.cbSharable.isSelected() ? this.txtLibFolder.getText() : null);
        this.platformDevicesPanel.store(d);
    }

    private void mainClassChanged() {
        String mainClassName = this.mainClassTextField.getText();
        StringTokenizer tk = new StringTokenizer(mainClassName, ".");
        boolean isValid = true;
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            if (token.length() != 0 && Utilities.isJavaIdentifier((String)token)) continue;
            isValid = false;
            break;
        }
        this.isMainClassValid = !mainClassName.isEmpty() && isValid;
        this.panel.fireChangeEvent();
    }

    private void librariesLocationChanged() {
        this.panel.fireChangeEvent();
    }
}

