/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2me.project.J2MEProject;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.LibrariesNode;
import org.netbeans.modules.java.api.common.project.ui.ProjectUISupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class LibrariesNodeProvider
implements NodeFactory {
    public NodeList<?> createNodes(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        J2MEProject j2mePrj = (J2MEProject)project.getLookup().lookup(J2MEProject.class);
        if (j2mePrj != null) {
            return new Libs(j2mePrj);
        }
        return NodeFactorySupport.fixedNodeList((Node[])new Node[0]);
    }

    private static final class Libs
    implements NodeList<NodeType>,
    PropertyChangeListener {
        private final J2MEProject prj;
        private final SourceRoots sources;
        private final SourceRoots tests;
        private final ChangeSupport changeSupport;
        private final ClassPathSupport cs;

        Libs(@NonNull J2MEProject prj) {
            Parameters.notNull((CharSequence)"prj", (Object)prj);
            this.prj = prj;
            this.sources = this.prj.getSourceRoots();
            this.tests = this.prj.getTestRoots();
            this.changeSupport = new ChangeSupport((Object)this);
            this.cs = new ClassPathSupport(prj.evaluator(), prj.getReferenceHelper(), prj.getHelper(), prj.getUpdateHelper(), null);
        }

        @NonNull
        public List<NodeType> keys() {
            ArrayList<NodeType> res = new ArrayList<NodeType>(2);
            res.add(NodeType.SOURCES);
            if (Libs.nonEmpty(this.tests)) {
                res.add(NodeType.TESTS);
            }
            return res;
        }

        public void addChangeListener(@NonNull ChangeListener l) {
            Parameters.notNull((CharSequence)"l", (Object)l);
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(@NonNull ChangeListener l) {
            Parameters.notNull((CharSequence)"l", (Object)l);
            this.changeSupport.removeChangeListener(l);
        }

        @NonNull
        public Node node(@NonNull NodeType key) {
            Parameters.notNull((CharSequence)"key", (Object)((Object)key));
            switch (key) {
                case SOURCES: {
                    FileObject[] roots = this.sources.getRoots();
                    ClassPath bootCp = roots.length > 0 ? this.prj.getClassPathProvider().findClassPath(roots[0], "classpath/boot") : this.prj.getClassPathProvider().getProjectClassPaths("classpath/boot")[0];
                    return new LibrariesNode.Builder((Project)this.prj, this.prj.evaluator(), this.prj.getUpdateHelper(), this.prj.getReferenceHelper(), this.cs).setName(NbBundle.getMessage(LibrariesNodeProvider.class, (String)"CTL_LibrariesNode")).addClassPathProperties(new String[]{"run.classpath"}).addClassPathIgnoreRefs(new String[]{"build.classes.dir"}).setPlatformProperty("platform.active").setPlatformType("j2me").setBootPath(bootCp).addLibrariesNodeActions(new Action[]{LibrariesNode.createAddProjectAction((Project)this.prj, (SourceRoots)this.sources), LibrariesNode.createAddLibraryAction((ReferenceHelper)this.prj.getReferenceHelper(), (SourceRoots)this.sources, null), LibrariesNode.createAddFolderAction((AntProjectHelper)this.prj.getHelper(), (SourceRoots)this.sources), null, ProjectUISupport.createPreselectPropertiesAction((Project)this.prj, (String)"Libraries", (String)"COMPILE")}).build();
                }
                case TESTS: {
                    return new LibrariesNode.Builder((Project)this.prj, this.prj.evaluator(), this.prj.getUpdateHelper(), this.prj.getReferenceHelper(), this.cs).setName(NbBundle.getMessage(LibrariesNodeProvider.class, (String)"CTL_TestLibrariesNode")).addClassPathProperties(new String[]{"run.test.classpath"}).addClassPathIgnoreRefs(new String[]{"build.test.classes.dir", "javac.classpath", "build.classes.dir"}).addLibrariesNodeActions(new Action[]{LibrariesNode.createAddProjectAction((Project)this.prj, (SourceRoots)this.tests), LibrariesNode.createAddLibraryAction((ReferenceHelper)this.prj.getReferenceHelper(), (SourceRoots)this.tests, null), LibrariesNode.createAddFolderAction((AntProjectHelper)this.prj.getHelper(), (SourceRoots)this.tests), null, ProjectUISupport.createPreselectPropertiesAction((Project)this.prj, (String)"Libraries", null)}).build();
                }
            }
            throw new IllegalArgumentException(key.toString());
        }

        public void addNotify() {
            this.sources.addPropertyChangeListener((PropertyChangeListener)this);
            this.tests.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void removeNotify() {
            this.sources.removePropertyChangeListener((PropertyChangeListener)this);
            this.tests.removePropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (SourceRoots.PROP_ROOTS.equals(evt.getPropertyName())) {
                this.changeSupport.fireChange();
            }
        }

        private static boolean nonEmpty(@NonNull SourceRoots sr) {
            return sr.getRoots().length > 0;
        }

        private static enum NodeType {
            SOURCES,
            TESTS;

        }
    }
}

