/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.installer.product.Registry;
import org.netbeans.installer.product.components.Product;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.XMLUtils;
import org.netbeans.installer.utils.exceptions.XMLException;
import org.w3c.dom.Element;

public class UninstallUtils {
    private static final String UPDATE_TRACKING_MODULE_VERSION_ELEMENT = "module_version";
    private static final String UPDATE_TRACKING_ORIGIN_ATRIBUTE = "origin";
    private static final String UPDATE_TRACKING_NAME_ATRIBUTE = "name";
    private static final String UPDATE_TRACKING_ORIGIN_INSTALLER_STRING = "installer";
    private static final String UPDATE_TRACKING_LOCATION = "update_tracking";
    private static final String UPDATE_BACKUP_LOCATION = "update";
    private static File installationLocation;
    private static List<File> emptyFolders;
    private static Set<File> updatedFiles;
    private static Set<File> clustersRoots;
    private static Set<File> filesToDelete;

    public static Set<File> getFilesToDeteleAfterUninstallation() {
        if (filesToDelete == null) {
            filesToDelete = new HashSet<File>();
            filesToDelete.addAll(UninstallUtils.getUpdatedFiles());
            for (File clusterRoot : UninstallUtils.getClustersRoots()) {
                File updateTrackingFolder = new File(clusterRoot, UPDATE_TRACKING_LOCATION);
                filesToDelete.addAll(UninstallUtils.getAllDescendantsRecursively(updateTrackingFolder));
                File lastModifiedFile = new File(clusterRoot, ".lastModified");
                if (lastModifiedFile.exists()) {
                    filesToDelete.add(lastModifiedFile);
                }
                File updateBackupFolder = new File(clusterRoot, UPDATE_BACKUP_LOCATION);
                filesToDelete.addAll(UninstallUtils.getAllDescendantsRecursively(updateBackupFolder));
            }
        }
        return filesToDelete;
    }

    public static List<File> getEmptyFolders() {
        if (emptyFolders == null) {
            emptyFolders = new ArrayList<File>();
            for (File clusterRoot : UninstallUtils.getClustersRoots()) {
                UninstallUtils.isFolderEmpty(clusterRoot);
            }
        }
        return emptyFolders;
    }

    private static Set<File> getUpdatedFiles() {
        if (updatedFiles == null) {
            Set<File> clustersRootsList = UninstallUtils.getClustersRoots();
            if (clustersRootsList == null || clustersRootsList.isEmpty()) {
                return Collections.EMPTY_SET;
            }
            FileFilter onlyXmlFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getPath().endsWith(".xml");
                }
            };
            updatedFiles = new HashSet<File>();
            for (File clusterRoot : clustersRootsList) {
                File clusterUpdateTrackingFolder = new File(clusterRoot, UPDATE_TRACKING_LOCATION);
                File[] updateTrackingFiles = clusterUpdateTrackingFolder.listFiles(onlyXmlFilter);
                if (updateTrackingFiles == null) continue;
                for (File trackingFile : updateTrackingFiles) {
                    try {
                        Element root = XMLUtils.getDocumentElement(trackingFile);
                        for (Element element : XMLUtils.getChildren(root, UPDATE_TRACKING_MODULE_VERSION_ELEMENT)) {
                            if (element.getAttribute(UPDATE_TRACKING_ORIGIN_ATRIBUTE).equals(UPDATE_TRACKING_ORIGIN_INSTALLER_STRING)) continue;
                            for (Element fileElement : XMLUtils.getChildren(element)) {
                                String fileName = fileElement.getAttribute(UPDATE_TRACKING_NAME_ATRIBUTE);
                                File file = new File(clusterRoot, fileName);
                                updatedFiles.add(file);
                            }
                        }
                    }
                    catch (XMLException ex) {
                        LogManager.log(ex);
                    }
                }
            }
        }
        return updatedFiles;
    }

    private static Set<File> getClustersRoots() {
        if (clustersRoots == null) {
            File installationLoc = UninstallUtils.getInstallationLocation();
            if (installationLoc != null && installationLoc.exists()) {
                FileFilter onlyDirFilter = new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory();
                    }
                };
                clustersRoots = new HashSet<File>(Arrays.asList(installationLoc.listFiles(onlyDirFilter)));
            } else {
                clustersRoots = Collections.EMPTY_SET;
            }
        }
        return clustersRoots;
    }

    private static List<File> getAllDescendantsRecursively(File folder) {
        if (folder != null && folder.isDirectory()) {
            ArrayList<File> descendants = new ArrayList<File>();
            for (File actualFile : folder.listFiles()) {
                if (actualFile.isDirectory()) {
                    descendants.addAll(UninstallUtils.getAllDescendantsRecursively(actualFile));
                }
                descendants.add(actualFile);
            }
            return descendants;
        }
        return Collections.EMPTY_LIST;
    }

    private static File getInstallationLocation() {
        if (installationLocation == null) {
            String target = System.getProperty("nbi.product.target.component.uid");
            Registry registry = Registry.getInstance();
            for (Product product : registry.getProductsToUninstall()) {
                if (!product.getUid().equals(target)) continue;
                installationLocation = product.getInstallationLocation();
            }
        }
        return installationLocation;
    }

    private static boolean isFolderEmpty(File file) {
        boolean result = true;
        if (file != null && file.isDirectory()) {
            for (File descendant : file.listFiles()) {
                result = UninstallUtils.isFolderEmpty(descendant) & result;
            }
            if (result) {
                emptyFolders.add(file);
            }
        } else {
            result = false;
        }
        return result;
    }
}

