/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.sendto.output;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.sendto.output.OutputPattern;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public final class OutputPatterns {
    private static final String NODE_NAME = "outputPatterns";
    private static final List<OutputPattern> patterns = new ArrayList<OutputPattern>();
    private static boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<OutputPattern> getPatterns() {
        ArrayList<OutputPattern> result;
        List<OutputPattern> list = patterns;
        synchronized (list) {
            if (!initialized) {
                List<OutputPattern> model = OutputPatterns.loadFromProperties(NODE_NAME);
                if (model == null) {
                    try {
                        model = OutputPatterns.loadFromStream(OutputPatterns.class.getClassLoader().getResourceAsStream("org/netbeans/modules/dlight/sendto/resources/initialOutputPatterns"));
                    }
                    catch (ParseException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                patterns.addAll(model);
                try {
                    OutputPatterns.storeToProperties(NODE_NAME, model);
                }
                catch (BackingStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                initialized = true;
            }
            result = new ArrayList<OutputPattern>(patterns);
        }
        return Collections.unmodifiableList(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<OutputPattern> loadFromStream(InputStream in) throws ParseException {
        ArrayList<OutputPattern> newModel = new ArrayList<OutputPattern>();
        BufferedReader br = null;
        try {
            String s;
            br = new BufferedReader(new InputStreamReader(in));
            while ((s = br.readLine()) != null) {
                OutputPattern ptrn = OutputPatterns.parseLine(s.trim());
                if (ptrn == null) continue;
                newModel.add(ptrn);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
        return newModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void storeToFile(FileObject afile, List<OutputPattern> model) {
        try (PrintWriter w = null;){
            w = new PrintWriter(afile.getOutputStream());
            for (OutputPattern pattern : model) {
                w.append(pattern.name).append('=').append(pattern.pattern.pattern()).append('#').append(pattern.order.name()).append('\n');
            }
        }
    }

    private static List<OutputPattern> loadFromProperties(String propertiesNode) {
        try {
            Preferences prefs = NbPreferences.forModule(OutputPatterns.class);
            if (!prefs.nodeExists(propertiesNode)) {
                return null;
            }
            prefs = prefs.node(propertiesNode);
            ArrayList<OutputPattern> newModel = new ArrayList<OutputPattern>();
            for (String name : prefs.keys()) {
                OutputPattern pattern = OutputPatterns.parseLine(name + "=" + prefs.get(name, ""));
                if (pattern == null) continue;
                newModel.add(pattern);
            }
            return newModel;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private static void storeToProperties(String propertiesNode, List<OutputPattern> model) throws BackingStoreException {
        Preferences prefs = NbPreferences.forModule(OutputPatterns.class);
        prefs = prefs.node(propertiesNode);
        prefs.clear();
        for (OutputPattern pattern : model) {
            prefs.put(pattern.name, pattern.pattern.pattern() + '#' + pattern.order.name());
        }
        prefs.flush();
    }

    private static OutputPattern parseLine(String line) throws ParseException {
        if (line.isEmpty() || line.startsWith("#")) {
            return null;
        }
        int idx1 = line.lastIndexOf(61);
        int idx2 = line.lastIndexOf(35);
        if (idx1 < 0 || idx2 < 0) {
            throw new ParseException(line, 0);
        }
        try {
            String name = line.substring(0, idx1);
            Pattern pattern = Pattern.compile(line.substring(idx1 + 1, idx2));
            OutputPattern.Order order = OutputPattern.Order.valueOf(line.substring(idx2 + 1));
            return new OutputPattern(name, pattern, order);
        }
        catch (IllegalArgumentException ex) {
            throw new ParseException(line, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setPatterns(List<OutputPattern> newPatterns) {
        List<OutputPattern> list = patterns;
        synchronized (list) {
            patterns.clear();
            patterns.addAll(newPatterns);
        }
        try {
            OutputPatterns.storeToProperties(NODE_NAME, newPatterns);
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }
}

