/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.StringReader;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.Filter;
import net.sf.saxon.IdentityTransformer;
import net.sf.saxon.IdentityTransformerHandler;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.TemplatesHandlerImpl;
import net.sf.saxon.TransformerHandlerImpl;
import net.sf.saxon.event.PIGrabber;
import net.sf.saxon.event.Sender;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.InputSource;
import org.xml.sax.XMLFilter;

public class TransformerFactoryImpl
extends SAXTransformerFactory {
    private Configuration config;
    private static final String FEATURE_SECURE_PROCESSING = "http://javax.xml.XMLConstants/feature/secure-processing";

    public TransformerFactoryImpl() {
        this.config = new Configuration();
    }

    public TransformerFactoryImpl(Configuration config) {
        this.config = config;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        return templates.newTransformer();
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        return new IdentityTransformer(this.config);
    }

    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        CompilerInfo info = new CompilerInfo();
        info.setURIResolver(this.config.getURIResolver());
        info.setErrorListener(this.config.getErrorListener());
        info.setCompileWithTracing(this.config.isCompileWithTracing());
        PreparedStylesheet pss = new PreparedStylesheet(this.config, info);
        pss.prepare(source);
        return pss;
    }

    public Templates newTemplates(Source source, CompilerInfo info) throws TransformerConfigurationException {
        PreparedStylesheet pss = new PreparedStylesheet(this.config, info);
        pss.prepare(source);
        return pss;
    }

    public Source getAssociatedStylesheet(Source source, String media, String title, String charset) throws TransformerConfigurationException {
        PIGrabber grabber;
        block6: {
            grabber = new PIGrabber();
            grabber.setFactory(this.config);
            grabber.setCriteria(media, title, charset);
            grabber.setBaseURI(source.getSystemId());
            grabber.setURIResolver(this.config.getURIResolver());
            try {
                new Sender(this.config.makePipelineConfiguration()).send(source, grabber);
            }
            catch (XPathException err) {
                if (grabber.isTerminated()) break block6;
                throw new TransformerConfigurationException("Failed while looking for xml-stylesheet PI", err);
            }
        }
        try {
            Source[] sources = grabber.getAssociatedStylesheets();
            if (sources == null) {
                throw new TransformerConfigurationException("No matching <?xml-stylesheet?> processing instruction found");
            }
            return this.compositeStylesheet(source.getSystemId(), sources);
        }
        catch (TransformerException err) {
            if (err instanceof TransformerConfigurationException) {
                throw (TransformerConfigurationException)err;
            }
            throw new TransformerConfigurationException(err);
        }
    }

    private Source compositeStylesheet(String baseURI, Source[] sources) throws TransformerConfigurationException {
        if (sources.length == 1) {
            return sources[0];
        }
        if (sources.length == 0) {
            throw new TransformerConfigurationException("No stylesheets were supplied");
        }
        StringBuffer sb = new StringBuffer(250);
        sb.append("<xsl:stylesheet version='1.0' ");
        sb.append(" xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>");
        for (int i = 0; i < sources.length; ++i) {
            sb.append("<xsl:import href='").append(sources[i].getSystemId()).append("'/>");
        }
        sb.append("</xsl:stylesheet>");
        InputSource composite = new InputSource();
        composite.setSystemId(baseURI);
        composite.setCharacterStream(new StringReader(sb.toString()));
        return new SAXSource(this.config.getSourceParser(), composite);
    }

    public void setURIResolver(URIResolver resolver) {
        this.config.setURIResolver(resolver);
    }

    public URIResolver getURIResolver() {
        return this.config.getURIResolver();
    }

    public boolean getFeature(String name) {
        if (name.equals("http://javax.xml.transform.sax.SAXSource/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.sax.SAXResult/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.dom.DOMSource/feature")) {
            return this.isDOMAvailable();
        }
        if (name.equals("http://javax.xml.transform.dom.DOMResult/feature")) {
            return this.isDOMAvailable();
        }
        if (name.equals("http://javax.xml.transform.stream.StreamSource/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.stream.StreamResult/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
            return true;
        }
        if (name.equals("http://javax.xml.transform.sax.SAXTransformerFactory/feature/xmlfilter")) {
            return true;
        }
        if (name.equals(FEATURE_SECURE_PROCESSING)) {
            return !this.config.isAllowExternalFunctions();
        }
        throw new IllegalArgumentException("Unknown feature " + name);
    }

    private boolean isDOMAvailable() {
        List models = this.config.getExternalObjectModels();
        for (int i = 0; i < models.size(); ++i) {
            if (!models.get(i).getClass().getName().equals("net.sf.saxon.dom.DOMObjectModel")) continue;
            return true;
        }
        return false;
    }

    public void setAttribute(String name, Object value) throws IllegalArgumentException {
        if (name.equals("http://saxon.sf.net/feature/configuration")) {
            this.config = (Configuration)value;
        } else {
            this.config.setConfigurationProperty(name, value);
        }
    }

    public Object getAttribute(String name) throws IllegalArgumentException {
        if (name.equals("http://saxon.sf.net/feature/configuration")) {
            return this.config;
        }
        return this.config.getConfigurationProperty(name);
    }

    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        this.config.setErrorListener(listener);
    }

    public ErrorListener getErrorListener() {
        return this.config.getErrorListener();
    }

    public TransformerHandler newTransformerHandler(Source src) throws TransformerConfigurationException {
        Templates tmpl = this.newTemplates(src);
        return this.newTransformerHandler(tmpl);
    }

    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        if (!(templates instanceof PreparedStylesheet)) {
            throw new TransformerConfigurationException("Templates object was not created by Saxon");
        }
        Controller controller = (Controller)templates.newTransformer();
        return new TransformerHandlerImpl(controller);
    }

    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        IdentityTransformer controller = new IdentityTransformer(this.config);
        return new IdentityTransformerHandler(controller);
    }

    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        return new TemplatesHandlerImpl(this.config);
    }

    public XMLFilter newXMLFilter(Source src) throws TransformerConfigurationException {
        Templates tmpl = this.newTemplates(src);
        return this.newXMLFilter(tmpl);
    }

    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        if (!(templates instanceof PreparedStylesheet)) {
            throw new TransformerConfigurationException("Supplied Templates object was not created using Saxon");
        }
        Controller controller = (Controller)templates.newTransformer();
        return new Filter(controller);
    }

    public void setFeature(String name, boolean value) throws TransformerConfigurationException {
        if (!name.equals(FEATURE_SECURE_PROCESSING)) {
            throw new TransformerConfigurationException("Unsupported TransformerFactory feature: " + name);
        }
        this.config.setAllowExternalFunctions(!value);
    }
}

