/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.annotations;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.LazyDebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.editor.StickyWindowSupport;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.debugger.ui.annotations.DebuggerAnnotation;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.netbeans.spi.debugger.ui.EditorPin;
import org.netbeans.spi.debugger.ui.PinWatchUISupport;
import org.openide.awt.CloseButtonFactory;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.AnnotationProvider;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

public class WatchAnnotationProvider
implements AnnotationProvider,
LazyDebuggerManagerListener {
    public static PinSupportedAccessor PIN_SUPPORT_ACCESS;
    private static WatchAnnotationProvider INSTANCE;
    private static final Map<Watch, Annotation> watchToAnnotation;
    private static final Map<Watch, JComponent> watchToWindow;
    private Set<PropertyChangeListener> dataObjectListeners;

    public WatchAnnotationProvider() {
        PinWatchUISupport.getDefault();
        INSTANCE = this;
    }

    public void annotate(final Line.Set lines, Lookup context) {
        Watch[] watches;
        DataObject dobj = (DataObject)context.lookup(DataObject.class);
        if (dobj == null) {
            return;
        }
        final CloneableEditorSupport ces = (CloneableEditorSupport)context.lookup(CloneableEditorSupport.class);
        if (ces == null) {
            return;
        }
        FileObject file = (FileObject)context.lookup(FileObject.class);
        if (file == null) {
            file = dobj.getPrimaryFile();
        }
        LinkedList<Watch> pinnedWatches = null;
        for (Watch watch : watches = DebuggerManager.getDebuggerManager().getWatches()) {
            EditorPin epin;
            Watch.Pin pin = watch.getPin();
            if (!(pin instanceof EditorPin) || !file.equals((epin = (EditorPin)pin).getFile())) continue;
            if (pinnedWatches == null) {
                pinnedWatches = new LinkedList<Watch>();
            }
            pinnedWatches.add(watch);
        }
        if (pinnedWatches != null) {
            final LinkedList<Watch> pws = pinnedWatches;
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    JEditorPane[] openedPanes = ces.getOpenedPanes();
                    if (openedPanes != null) {
                        for (JEditorPane pane : openedPanes) {
                            EditorUI eui = Utilities.getEditorUI((JTextComponent)pane);
                            if (eui == null) continue;
                            Map map = watchToAnnotation;
                            synchronized (map) {
                                for (Watch watch : pws) {
                                    EditorPin epin = (EditorPin)watch.getPin();
                                    Line line = lines.getOriginal(epin.getLine());
                                    WatchAnnotationProvider.this.pin(watch, eui, line);
                                }
                            }
                        }
                    }
                }
            });
        }
    }

    private void pin(Watch watch, EditorUI eui, Line line) throws IndexOutOfBoundsException {
        EditorPin pin;
        Annotation ann = watchToAnnotation.remove(watch);
        if (ann != null) {
            ann.detach();
        }
        JComponent frame = watchToWindow.remove(watch);
        StickyWindowSupport stickyWindowSupport = eui.getStickyWindowSupport();
        if (frame != null) {
            frame.setVisible(false);
            stickyWindowSupport.removeWindow(frame);
        }
        if ((pin = (EditorPin)watch.getPin()) == null) {
            return;
        }
        if (line == null) {
            line = this.getLine(pin.getFile(), pin.getLine());
        }
        final DebuggerAnnotation annotation = new DebuggerAnnotation("PinnedWatch", line);
        annotation.setWatch(watch);
        watchToAnnotation.put(watch, annotation);
        annotation.attach((Annotatable)line);
        pin.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("line".equals(evt.getPropertyName())) {
                    annotation.detach();
                    Line line = WatchAnnotationProvider.this.getLine(pin.getFile(), pin.getLine());
                    annotation.attach((Annotatable)line);
                }
            }
        });
        final StickyPanel window = new StickyPanel(watch, eui);
        stickyWindowSupport.addWindow((JComponent)window);
        window.setLocation(pin.getLocation());
        watchToWindow.put(watch, window);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Dimension size = window.getPreferredSize();
                Point loc = window.getLocation();
                window.setBounds(loc.x, loc.y, size.width, size.height);
            }
        });
    }

    private Line getLine(FileObject file, int lineNumber) {
        DataObject dataObject;
        if (file == null) {
            return null;
        }
        try {
            dataObject = DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
        if (dataObject == null) {
            return null;
        }
        LineCookie lineCookie = (LineCookie)dataObject.getLookup().lookup(LineCookie.class);
        if (lineCookie == null) {
            return null;
        }
        Line.Set ls = lineCookie.getLineSet();
        if (ls == null) {
            return null;
        }
        try {
            return ls.getCurrent(lineNumber);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException runtimeException) {
            return null;
        }
    }

    public String[] getProperties() {
        return new String[]{"watches"};
    }

    public Breakpoint[] initBreakpoints() {
        return null;
    }

    public void breakpointAdded(Breakpoint breakpoint) {
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
    }

    public void initWatches() {
    }

    public void watchAdded(Watch watch) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watchRemoved(Watch watch) {
        Map<Watch, Annotation> map = watchToAnnotation;
        synchronized (map) {
            JComponent frame;
            Annotation annotation = watchToAnnotation.remove(watch);
            if (annotation != null) {
                annotation.detach();
            }
            if ((frame = watchToWindow.remove(watch)) != null) {
                EditorUI eui = ((StickyPanel)frame).eui;
                eui.getStickyWindowSupport().removeWindow(frame);
            }
        }
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void engineAdded(DebuggerEngine engine) {
    }

    public void engineRemoved(DebuggerEngine engine) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    private static JTextComponent createNonEditableSelectableLabel(String text) {
        JTextPane tf = new JTextPane(){

            @Override
            public void setText(String text) {
                String noWrapText = "<html><div style='white-space:nowrap'>" + text + "</div></html>";
                super.setText(noWrapText);
            }
        };
        tf.setContentType("text/html");
        tf.setEditable(false);
        tf.setBorder(null);
        tf.setForeground(UIManager.getColor("Label.foreground"));
        tf.setBackground(UIManager.getColor("Label.background"));
        tf.setFont(UIManager.getFont("Label.font"));
        tf.setText(text);
        tf.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        return tf;
    }

    static {
        watchToAnnotation = new IdentityHashMap<Watch, Annotation>();
        watchToWindow = new IdentityHashMap<Watch, JComponent>();
    }

    public static abstract class PinSupportedAccessor {
        public abstract PinWatchUISupport.ValueProvider getValueProvider(EditorPin var1);

        public final void pin(Watch watch) throws DataObjectNotFoundException {
            Line line;
            EditorPin pin = (EditorPin)watch.getPin();
            DataObject dobj = DataObject.find((FileObject)pin.getFile());
            EditorCookie ec = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
            JEditorPane[] openedPanes = ec.getOpenedPanes();
            if (openedPanes == null) {
                throw new IllegalArgumentException("No editor panes opened for file " + pin.getFile());
            }
            LineCookie lineCookie = (LineCookie)dobj.getLookup().lookup(LineCookie.class);
            if (lineCookie == null) {
                throw new IllegalArgumentException("No line cookie in " + pin.getFile());
            }
            Line.Set ls = lineCookie.getLineSet();
            try {
                line = ls.getCurrent(pin.getLine());
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Wrong line: " + pin.getLine(), e);
            }
            for (JEditorPane pane : openedPanes) {
                JEditorPane ep = EditorContextDispatcher.getDefault().getMostRecentEditor();
                EditorUI editorUI = Utilities.getEditorUI((JTextComponent)pane);
                INSTANCE.pin(watch, editorUI, line);
            }
        }
    }

    private static final class StickyPanel
    extends JPanel {
        private static final String ICON_COMMENT = "org/netbeans/modules/debugger/resources/actions/Comment.png";
        private static final String UI_PREFIX = "ToolTip";
        private final Watch watch;
        private final EditorUI eui;
        private final JTextComponent textComponent;
        private final JTextField valueField;
        private final JToolBar headActions;
        private final JToolBar tailActions;
        private JTextField commentField;
        private final PinWatchUISupport.ValueProvider valueProvider;
        private final String evaluatingValue;
        private String lastValue;
        private int minPreferredHeight = 0;

        public StickyPanel(final Watch watch, final EditorUI eui) {
            this.watch = watch;
            this.eui = eui;
            EditorPin pin = (EditorPin)watch.getPin();
            Font font = UIManager.getFont("ToolTip.font");
            this.setOpaque(true);
            this.setBorder(BorderFactory.createLineBorder(this.getForeground()));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridConstraints = new GridBagConstraints();
            gridConstraints.gridx = 0;
            gridConstraints.gridy = 0;
            this.valueProvider = PIN_SUPPORT_ACCESS.getValueProvider(pin);
            this.headActions = StickyPanel.createActionsToolbar();
            this.add((Component)this.headActions, gridConstraints);
            Action[] actions = this.valueProvider.getHeadActions(watch);
            this.addActions(this.headActions, actions);
            this.evaluatingValue = this.valueProvider.getEvaluatingText();
            final String expressionText = watch.getExpression() + " = ";
            this.valueField = new JTextField();
            this.valueField.setVisible(false);
            this.valueProvider.setChangeListener(watch, new PinWatchUISupport.ValueProvider.ValueChangeListener(){

                @Override
                public void valueChanged(Watch w) {
                    final boolean[] isEvaluating = new boolean[]{false};
                    final String text = this.getWatchValueText(watch, valueProvider, isEvaluating);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Action[] actions = valueProvider.getHeadActions(watch);
                            this.addActions(headActions, actions);
                            textComponent.setText(expressionText + text);
                            actions = valueProvider.getTailActions(watch);
                            this.addActions(tailActions, actions);
                            Dimension size = this.getPreferredSize();
                            Point loc = this.getLocation();
                            this.setBounds(loc.x, loc.y, size.width, size.height);
                            if (!isEvaluating[0]) {
                                this.adjustSize();
                            }
                        }
                    });
                }
            });
            this.textComponent = WatchAnnotationProvider.createNonEditableSelectableLabel(expressionText + this.getWatchValueText(watch, this.valueProvider, null));
            if (font != null) {
                this.textComponent.setFont(font);
            }
            this.textComponent.setBorder(new EmptyBorder(0, 3, 0, 3));
            ++gridConstraints.gridx;
            this.add((Component)this.textComponent, gridConstraints);
            int expressionTextPositionEnd = this.textComponent.getFontMetrics(this.textComponent.getFont()).stringWidth(expressionText);
            Insets lastInsets = gridConstraints.insets;
            gridConstraints.insets = new Insets(0, expressionTextPositionEnd, 0, 0);
            this.add((Component)this.valueField, gridConstraints);
            gridConstraints.insets = lastInsets;
            this.setComponentZOrder(this.textComponent, 1);
            this.setComponentZOrder(this.valueField, 0);
            TextKeysMouseListener textKeysMouseListener = new TextKeysMouseListener(expressionTextPositionEnd);
            this.textComponent.addMouseListener(textKeysMouseListener);
            this.textComponent.addKeyListener(textKeysMouseListener);
            this.textComponent.addFocusListener(textKeysMouseListener);
            this.valueField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String newValue = valueField.getText();
                    if (valueProvider.setValue(watch, newValue)) {
                        boolean[] isEvaluating = new boolean[]{false};
                        textComponent.setText(expressionText + this.getWatchValueText(watch, valueProvider, isEvaluating));
                        if (!isEvaluating[0]) {
                            this.adjustSize();
                        }
                    }
                    this.hideValueField();
                }
            });
            this.valueField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    this.hideValueField();
                }
            });
            this.valueField.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if ('\u001b' == e.getKeyChar()) {
                        this.hideValueField();
                    }
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }
            });
            this.tailActions = StickyPanel.createActionsToolbar();
            ++gridConstraints.gridx;
            gridConstraints.weighty = 1.0;
            gridConstraints.fill = 3;
            this.add((Component)this.tailActions, gridConstraints);
            actions = this.valueProvider.getTailActions(watch);
            this.addActions(this.tailActions, actions);
            JSeparator iconsSeparator = new JSeparator(1);
            ++gridConstraints.gridx;
            gridConstraints.weighty = 1.0;
            gridConstraints.fill = 3;
            this.add((Component)iconsSeparator, gridConstraints);
            gridConstraints.weighty = 0.0;
            gridConstraints.fill = 0;
            ImageIcon commentIcon = ImageUtilities.loadImageIcon((String)ICON_COMMENT, (boolean)false);
            JButton commentButton = new JButton(commentIcon);
            commentButton.setBorder(new EmptyBorder(0, 3, 0, 3));
            commentButton.setBorderPainted(false);
            commentButton.setContentAreaFilled(false);
            ++gridConstraints.gridx;
            this.add((Component)commentButton, gridConstraints);
            JButton closeButton = CloseButtonFactory.createCloseButton();
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    eui.getStickyWindowSupport().removeWindow((JComponent)this);
                    watch.remove();
                }
            });
            ++gridConstraints.gridx;
            this.add((Component)closeButton, gridConstraints);
            final int gridwidth = gridConstraints.gridx + 1;
            if (pin.getComment() != null) {
                this.addCommentField(pin.getComment(), gridwidth);
            }
            commentButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.addCommentListener(gridwidth);
                }
            });
            MouseAdapter mouseAdapter = new MouseAdapter(){
                private Point orig;
                private Cursor lastCursor;

                @Override
                public void mouseDragged(MouseEvent e) {
                    int line;
                    if (!this.canDrag(e)) {
                        this.unsetMoveCursor();
                        return;
                    }
                    if (this.orig == null) {
                        return;
                    }
                    this.setMoveCursor();
                    Point p = this.getLocation();
                    int deltaX = e.getX() - this.orig.x;
                    int deltaY = e.getY() - this.orig.y;
                    p.translate(deltaX, deltaY);
                    this.setLocation(p);
                    Point linePoint = new Point(p.x, p.y + textComponent.getHeight() / 2);
                    int pos = eui.getComponent().viewToModel(linePoint);
                    try {
                        line = LineDocumentUtils.getLineIndex((LineDocument)eui.getDocument(), (int)pos);
                    }
                    catch (BadLocationException ex) {
                        line = ((EditorPin)watch.getPin()).getLine();
                    }
                    ((EditorPin)watch.getPin()).move(line, p);
                    textComponent.setCaretPosition(0);
                    e.consume();
                    this.adjustSize();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.orig = e.getPoint();
                    if (this.canDrag(e)) {
                        this.setMoveCursor();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.orig = null;
                    this.unsetMoveCursor();
                }

                private void setMoveCursor() {
                    if (this.lastCursor == null) {
                        this.lastCursor = this.getCursor();
                        this.setCursor(Cursor.getPredefinedCursor(13));
                    }
                }

                private void unsetMoveCursor() {
                    if (this.lastCursor != null) {
                        this.setCursor(this.lastCursor);
                        this.lastCursor = null;
                    }
                }
            };
            this.addMouseListener(mouseAdapter);
            this.addMouseMotionListener(mouseAdapter);
            this.textComponent.addMouseListener(mouseAdapter);
            this.textComponent.addMouseMotionListener(mouseAdapter);
            this.adjustSize();
            eui.getComponent().addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                    this.adjustSize();
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentShown(ComponentEvent e) {
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                }
            });
        }

        private boolean canDrag(MouseEvent e) {
            return (e.getModifiersEx() & 0x23C0) == 0;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            if (this.minPreferredHeight == 0) {
                this.minPreferredHeight = Math.max(16, UIManager.getIcon("Tree.expandedIcon").getIconHeight()) + 2;
            }
            if (preferredSize.height < this.minPreferredHeight) {
                preferredSize.height = this.minPreferredHeight;
            }
            return preferredSize;
        }

        private void adjustSize() {
            JTextComponent component = this.eui.getComponent();
            if (component == null) {
                return;
            }
            int editorSize = component.getSize().width;
            int maxSize = editorSize - this.getLocation().x;
            Dimension prefSize = this.getPreferredSize();
            if (prefSize.width > maxSize) {
                int smallerBy = prefSize.width - maxSize;
                Dimension textSize = this.textComponent.getPreferredSize();
                int newTextSize = textSize.width - smallerBy;
                if (newTextSize < textSize.height) {
                    newTextSize = textSize.height;
                }
                textSize.width = newTextSize;
                this.textComponent.setSize(textSize);
                this.textComponent.setPreferredSize(textSize);
                Dimension size = this.getPreferredSize();
                Point loc = this.getLocation();
                if (loc.x + size.width > editorSize) {
                    loc.x = editorSize - size.width;
                    if (loc.x < 0) {
                        loc.x = 0;
                    }
                }
                this.setBounds(loc.x, loc.y, size.width, size.height);
                this.doRepaint();
            } else if (prefSize.width < maxSize) {
                if (this.textComponent.isPreferredSizeSet()) {
                    this.textComponent.setPreferredSize(null);
                    this.textComponent.setSize(this.textComponent.getPreferredSize());
                    this.adjustSize();
                    Dimension size = this.getPreferredSize();
                    Point loc = this.getLocation();
                    this.setBounds(loc.x, loc.y, size.width, size.height);
                    this.doRepaint();
                }
            } else if (this.textComponent.isPreferredSizeSet()) {
                Dimension preferredSize = this.textComponent.getPreferredSize();
                Dimension uiPreferredSize = this.textComponent.getUI().getPreferredSize(this.textComponent);
                if (uiPreferredSize.width < preferredSize.width) {
                    this.textComponent.setPreferredSize(null);
                    this.textComponent.setSize(this.textComponent.getPreferredSize());
                    Dimension size = this.getPreferredSize();
                    Point loc = this.getLocation();
                    this.setBounds(loc.x, loc.y, size.width, size.height);
                    this.doRepaint();
                }
            }
        }

        private void doRepaint() {
            this.revalidate();
            this.repaint();
        }

        @Override
        public void scrollRectToVisible(Rectangle aRect) {
        }

        private void hideValueField() {
            this.valueField.setVisible(false);
            Dimension size = this.getPreferredSize();
            Point loc = this.getLocation();
            this.setBounds(loc.x, loc.y, size.width, size.height);
            GridBagConstraints constraints = ((GridBagLayout)this.getLayout()).getConstraints(this.textComponent);
            constraints.insets = new Insets(0, 0, 0, 0);
            ((GridBagLayout)this.getLayout()).setConstraints(this.textComponent, constraints);
        }

        private static JToolBar createActionsToolbar() {
            JToolBar jt = new JToolBar(0);
            jt.setBorder(new EmptyBorder(0, 0, 0, 0));
            jt.setFloatable(false);
            jt.setRollover(false);
            return jt;
        }

        private void addActions(JToolBar tb, Action[] actions) {
            tb.removeAll();
            boolean visible = false;
            if (actions != null) {
                for (Action a : actions) {
                    if (a != null) {
                        JButton btn = tb.add(a);
                        btn.setBorder(new EmptyBorder(0, 2, 0, 2));
                        btn.setBorderPainted(false);
                        btn.setContentAreaFilled(false);
                        btn.setRolloverEnabled(false);
                        btn.setOpaque(false);
                        btn.setFocusable(false);
                        visible = true;
                        continue;
                    }
                    tb.add(new JSeparator(1));
                }
            }
            tb.setVisible(visible);
        }

        private void addCommentField(String text, int gridwidth) {
            this.commentField = new JTextField(text);
            this.commentField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.commentUpdated();
                }
            });
            GridBagConstraints gridConstraints = new GridBagConstraints();
            gridConstraints.gridy = 1;
            gridConstraints.gridwidth = gridwidth;
            gridConstraints.fill = 2;
            this.add((Component)this.commentField, gridConstraints);
        }

        private void addCommentListener(int gridwidth) {
            if (this.commentField == null) {
                this.addCommentField("", gridwidth);
                this.setSize(this.getPreferredSize());
                this.revalidate();
                this.repaint();
            } else {
                boolean visible = !this.commentField.isVisible();
                this.commentField.setVisible(visible);
                this.setSize(this.getPreferredSize());
                this.revalidate();
                this.repaint();
                if (visible) {
                    this.commentField.requestFocusInWindow();
                }
            }
        }

        @Override
        public void removeNotify() {
            this.valueProvider.unsetChangeListener(this.watch);
        }

        private void commentUpdated() {
            ((EditorPin)this.watch.getPin()).setComment(this.commentField.getText());
        }

        private String getWatchValueText(Watch watch, PinWatchUISupport.ValueProvider vp, boolean[] isEvaluating) {
            String s2;
            String s1;
            String value = vp.getValue(watch);
            if (value == this.evaluatingValue) {
                if (isEvaluating != null) {
                    isEvaluating[0] = true;
                }
                return "<html><font color=\"red\">" + value + "</font>" + "</html>";
            }
            boolean bold = false;
            boolean old = false;
            if (value != null) {
                bold = this.lastValue != null && !this.lastValue.equals(value);
                this.lastValue = value;
            } else {
                old = true;
                value = this.lastValue;
            }
            if (bold) {
                s1 = "<b>";
                s2 = "</b>";
            } else if (old) {
                s1 = "<font color=\"gray\">";
                s2 = "</font>";
            } else {
                s2 = "";
                s1 = "";
            }
            return "<html>" + s1 + value + s2 + "</html>";
        }

        private class TextKeysMouseListener
        implements KeyListener,
        MouseListener,
        FocusListener {
            private final Cursor selectCursor = Cursor.getPredefinedCursor(2);
            private Cursor lastCursor;
            private boolean lastCursorUnset;
            private final int expressionTextPositionEnd;
            private Component lastFocusOwner;

            TextKeysMouseListener(int expressionTextPositionEnd) {
                this.expressionTextPositionEnd = expressionTextPositionEnd;
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isAltDown() || e.isAltGraphDown() || e.isControlDown() || e.isMetaDown() || e.isShiftDown()) {
                    this.setSelectCursor();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!(e.isAltDown() || e.isAltGraphDown() || e.isControlDown() || e.isMetaDown() || e.isShiftDown())) {
                    this.unsetSelectCursor();
                }
            }

            private void setSelectCursor() {
                if (this.lastCursor == null && !this.lastCursorUnset) {
                    boolean bl = this.lastCursorUnset = !StickyPanel.this.textComponent.isCursorSet();
                    if (!this.lastCursorUnset) {
                        this.lastCursor = StickyPanel.this.textComponent.getCursor();
                    }
                    StickyPanel.this.textComponent.setCursor(this.selectCursor);
                }
            }

            private void unsetSelectCursor() {
                if (this.lastCursor != null || this.lastCursorUnset) {
                    StickyPanel.this.textComponent.setCursor(this.lastCursor);
                    this.lastCursor = null;
                    this.lastCursorUnset = false;
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                String editableValue = StickyPanel.this.valueProvider.getEditableValue(StickyPanel.this.watch);
                if (editableValue != null) {
                    if (e.getX() < this.expressionTextPositionEnd) {
                        return;
                    }
                    StickyPanel.this.valueField.setVisible(true);
                    StickyPanel.this.valueField.setPreferredSize(null);
                    StickyPanel.this.valueField.setText(editableValue);
                    Dimension fieldSize = StickyPanel.this.valueField.getPreferredSize();
                    fieldSize.width = ((StickyPanel)StickyPanel.this).textComponent.getSize().width - this.expressionTextPositionEnd;
                    int minWidth = 2 * fieldSize.height;
                    if (fieldSize.width < minWidth) {
                        int extendedBy = minWidth - fieldSize.width;
                        fieldSize.width = minWidth;
                        GridBagConstraints constraints = ((GridBagLayout)StickyPanel.this.getLayout()).getConstraints(StickyPanel.this.textComponent);
                        constraints.insets = new Insets(0, 0, 0, extendedBy);
                        ((GridBagLayout)StickyPanel.this.getLayout()).setConstraints(StickyPanel.this.textComponent, constraints);
                    }
                    StickyPanel.this.valueField.setPreferredSize(fieldSize);
                    StickyPanel.this.valueField.requestFocusInWindow();
                    Dimension size = StickyPanel.this.getPreferredSize();
                    Point loc = StickyPanel.this.getLocation();
                    StickyPanel.this.setBounds(loc.x, loc.y, size.width, size.height);
                    StickyPanel.this.doRepaint();
                    e.consume();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                this.lastFocusOwner = kfm.getFocusOwner();
                if (this.lastFocusOwner != null) {
                    this.lastFocusOwner.addKeyListener(this);
                }
                if (!StickyPanel.this.canDrag(e)) {
                    this.setSelectCursor();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (this.lastFocusOwner != null) {
                    this.lastFocusOwner.removeKeyListener(this);
                    this.lastFocusOwner = null;
                }
                this.unsetSelectCursor();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (this.lastFocusOwner != null) {
                    this.lastFocusOwner.removeKeyListener(this);
                    this.lastFocusOwner = null;
                }
                this.unsetSelectCursor();
            }
        }
    }
}

