/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.update;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.logging.Level;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.SvnModuleConfig;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.ui.update.FileUpdateInfo;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

class UpdateResultNode
extends AbstractNode {
    private final FileUpdateInfo info;
    static final String COLUMN_NAME_NAME = "name";
    static final String COLUMN_NAME_PATH = "path";
    static final String COLUMN_NAME_STATUS = "status";
    private final MessageFormat conflictFormat = new MessageFormat("<font color=\"#FF0000\">{0}</font>");
    private final MessageFormat mergedFormat = new MessageFormat("<font color=\"#0000FF\">{0}</font>");
    private final MessageFormat removedFormat = new MessageFormat("<font color=\"#999999\">{0}</font>");
    private final MessageFormat addedFormat = new MessageFormat("<font color=\"#008000\">{0}</font>");
    private String statusDisplayName;
    private String htmlDisplayName;
    private String relativePath;
    private final String[] zeros = new String[]{"", "00", "0", ""};

    public UpdateResultNode(FileUpdateInfo info) {
        super(Children.LEAF, Lookups.fixed((Object[])new Object[]{info}));
        assert (!EventQueue.isDispatchThread());
        this.info = info;
        this.initProperties();
        this.refreshHtmlDisplayName();
    }

    public FileUpdateInfo getInfo() {
        return this.info;
    }

    public String getName() {
        String name = this.info.getFile().getName() + ((this.info.getAction() & 2) != 0 ? " - Property" : "");
        return name;
    }

    public <T extends Node.Cookie> T getCookie(Class<T> klass) {
        FileObject fo = this.info.getFile().toFileObject();
        if (fo != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                if (fo.equals(dobj.getPrimaryFile())) {
                    return (T)((Node.Cookie)dobj.getLookup().lookup(klass));
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return (T)((Node.Cookie)super.getLookup().lookup(klass));
    }

    private void initProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = Sheet.createPropertiesSet();
        ps.put((Node.Property)new NameProperty());
        ps.put((Node.Property)new PathProperty());
        ps.put((Node.Property)new FileStatusProperty());
        sheet.put(ps);
        this.setSheet(sheet);
    }

    private void refreshHtmlDisplayName() {
        String name = this.getName();
        if ((this.info.getAction() & 4) != 0) {
            this.htmlDisplayName = this.addedFormat.format(new Object[]{name});
            this.statusDisplayName = NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Status_Added");
        } else if ((this.info.getAction() & 0x20) != 0) {
            this.htmlDisplayName = this.conflictFormat.format(new Object[]{name});
            this.statusDisplayName = NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Status_Conflict");
        } else if ((this.info.getAction() & 8) != 0) {
            this.htmlDisplayName = this.removedFormat.format(new Object[]{name});
            this.statusDisplayName = NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Status_Removed");
        } else if ((this.info.getAction() & 0x40) != 0) {
            this.htmlDisplayName = this.mergedFormat.format(new Object[]{name});
            this.statusDisplayName = NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Status_Merged");
        } else if ((this.info.getAction() & 0x10) != 0) {
            this.htmlDisplayName = name;
            this.statusDisplayName = NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Status_Updated");
        } else if ((this.info.getAction() & 0x80) != 0) {
            this.htmlDisplayName = name;
            this.statusDisplayName = NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Status_Conflict_Resolved");
        } else {
            throw new IllegalStateException("Unhandled update type: " + this.info.getAction());
        }
        this.fireDisplayNameChange(this.htmlDisplayName, this.htmlDisplayName);
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    public void refresh() {
        this.refreshHtmlDisplayName();
    }

    private String getLocation() {
        if (this.relativePath == null) {
            try {
                this.relativePath = SvnModuleConfig.getDefault(VCSFileProxySupport.getFileSystem((VCSFileProxy)this.info.getFile())).isRepositoryPathPrefixed() ? SvnUtils.decodeToString(SvnUtils.getRepositoryUrl(this.info.getFile())) : SvnUtils.getRelativePath(this.info.getFile());
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException(new Context(this.info.getFile()), ex, false, false);
                this.relativePath = "";
            }
        }
        return this.relativePath;
    }

    private class FileStatusProperty
    extends SyncFileProperty {
        private final String shortPath;

        public FileStatusProperty() {
            super(UpdateResultNode.COLUMN_NAME_STATUS, String.class, NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Status_Name"), NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Status_Desc"));
            this.shortPath = UpdateResultNode.this.getLocation();
            String sortable = Integer.toString(UpdateResultNode.this.info.getAction());
            this.setValue("sortkey", UpdateResultNode.this.zeros[sortable.length()] + sortable + "\t" + this.shortPath + "\t" + UpdateResultNode.this.getName());
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return UpdateResultNode.this.statusDisplayName;
        }
    }

    private class NameProperty
    extends SyncFileProperty {
        public NameProperty() {
            super(UpdateResultNode.COLUMN_NAME_NAME, String.class, NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Name_Name"), NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Name_Desc"));
            this.setValue("sortkey", UpdateResultNode.this.getName());
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return UpdateResultNode.this.getDisplayName();
        }
    }

    private class PathProperty
    extends SyncFileProperty {
        private final String shortPath;

        public PathProperty() {
            super(UpdateResultNode.COLUMN_NAME_PATH, String.class, NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Path_Name"), NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Path_Desc"));
            this.shortPath = UpdateResultNode.this.getLocation();
            this.setValue("sortkey", this.shortPath + "\t" + UpdateResultNode.this.getName());
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return this.shortPath;
        }
    }

    private abstract class SyncFileProperty
    extends PropertySupport.ReadOnly<String> {
        protected SyncFileProperty(String name, Class<String> type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public String toString() {
            try {
                return (String)this.getValue();
            }
            catch (Exception e) {
                Subversion.LOG.log(Level.INFO, null, e);
                return e.getLocalizedMessage();
            }
        }
    }
}

