/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.common;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.openide.util.Parameters;

public class Utilities {
    public static AnnotationMirror findAnnotation(Element element, String annotationClass) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationClass.equals(annotationMirror.getAnnotationType().toString())) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean hasAnnotation(Element element, String annClass) {
        AnnotationMirror annEntity = Utilities.findAnnotation(element, annClass);
        return annEntity != null;
    }

    public static AnnotationValue getAnnotationAttrValue(AnnotationMirror ann, String attrName) {
        if (ann != null) {
            for (ExecutableElement executableElement : ann.getElementValues().keySet()) {
                if (!attrName.equals(executableElement.getSimpleName().toString())) continue;
                return ann.getElementValues().get(executableElement);
            }
        }
        return null;
    }

    public static ExpressionTree getAnnotationArgumentTree(AnnotationTree annotationTree, String attrName) {
        for (ExpressionTree expressionTree : annotationTree.getArguments()) {
            ExpressionTree annVar;
            if (!(expressionTree instanceof AssignmentTree) || !((annVar = ((AssignmentTree)expressionTree).getVariable()) instanceof IdentifierTree) || !attrName.equals(((IdentifierTree)annVar).getName().toString())) continue;
            return expressionTree;
        }
        return null;
    }

    public static void addAnnotation(WorkingCopy workingCopy, ElementHandle<Element> handle, String annotationName) throws IOException {
        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
        Element element = handle.resolve((CompilationInfo)workingCopy);
        if (element == null) {
            return;
        }
        Utilities.addAnnotation(workingCopy, element, annotationName);
    }

    public static void addAnnotation(WorkingCopy workingCopy, ElementHandle<ExecutableElement> handle, int index, String annotationName) throws IOException {
        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
        ExecutableElement element = (ExecutableElement)handle.resolve((CompilationInfo)workingCopy);
        if (element == null) {
            return;
        }
        if (index < element.getParameters().size()) {
            VariableElement param = element.getParameters().get(index);
            Utilities.addAnnotation(workingCopy, param, annotationName);
        }
    }

    public static void removeAnnotation(WorkingCopy workingCopy, ElementHandle<Element> handle, String annotationFqn) throws IOException {
        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
        Element element = handle.resolve((CompilationInfo)workingCopy);
        if (element == null) {
            return;
        }
        Utilities.removeAnnotation(workingCopy, element, annotationFqn);
    }

    public static void removeAnnotation(WorkingCopy workingCopy, ElementHandle<ExecutableElement> handle, int index, String annotationFqn) throws IOException {
        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
        ExecutableElement element = (ExecutableElement)handle.resolve((CompilationInfo)workingCopy);
        if (element == null) {
            return;
        }
        if (index < element.getParameters().size()) {
            VariableElement param = element.getParameters().get(index);
            Utilities.removeAnnotation(workingCopy, param, annotationFqn);
        }
    }

    public static void removeAnnotationArgument(WorkingCopy workingCopy, ElementHandle<Element> handle, ElementHandle<Element> annotationHandle, String argumentName) throws IOException {
        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
        Element element = handle.resolve((CompilationInfo)workingCopy);
        if (element == null) {
            return;
        }
        Element annotationElement = annotationHandle.resolve((CompilationInfo)workingCopy);
        if (annotationElement == null) {
            return;
        }
        Utilities.removeAnnotationArgument(workingCopy, element, annotationElement, argumentName);
    }

    public static void removeAnnotationArgument(WorkingCopy workingCopy, ElementHandle<ExecutableElement> handle, int index, ElementHandle<Element> annotationHandle, String argumentName) throws IOException {
        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
        ExecutableElement element = (ExecutableElement)handle.resolve((CompilationInfo)workingCopy);
        if (element == null) {
            return;
        }
        Element annotationElement = annotationHandle.resolve((CompilationInfo)workingCopy);
        if (annotationElement == null) {
            return;
        }
        List<? extends VariableElement> parameters = element.getParameters();
        if (index < parameters.size()) {
            VariableElement param = parameters.get(index);
            Utilities.removeAnnotationArgument(workingCopy, param, annotationElement, argumentName);
        }
    }

    public static void addAnnotationArgument(WorkingCopy workingCopy, ElementHandle<Element> handle, ElementHandle<Element> annotationHandle, String argumentName, Object argumentValue) throws IOException {
        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
        Element element = handle.resolve((CompilationInfo)workingCopy);
        if (element == null) {
            return;
        }
        Element annotationElement = annotationHandle.resolve((CompilationInfo)workingCopy);
        if (annotationElement == null) {
            return;
        }
        Utilities.addAnnotationArgument(workingCopy, element, annotationElement, argumentName, argumentValue);
    }

    public static void addAnnotationArgument(WorkingCopy workingCopy, ElementHandle<ExecutableElement> handle, int index, ElementHandle<Element> annotationHandle, String argumentName, Object argumentValue) throws IOException {
        workingCopy.toPhase(JavaSource.Phase.RESOLVED);
        ExecutableElement element = (ExecutableElement)handle.resolve((CompilationInfo)workingCopy);
        if (element == null) {
            return;
        }
        Element annotationElement = annotationHandle.resolve((CompilationInfo)workingCopy);
        if (annotationElement == null) {
            return;
        }
        List<? extends VariableElement> parameters = element.getParameters();
        if (index < parameters.size()) {
            VariableElement param = parameters.get(index);
            Utilities.addAnnotationArgument(workingCopy, param, annotationElement, argumentName, argumentValue);
        }
    }

    public static TextSpan getUnderlineSpan(CompilationInfo info, Tree tree) {
        SourcePositions srcPos = info.getTrees().getSourcePositions();
        int startOffset = (int)srcPos.getStartPosition(info.getCompilationUnit(), tree);
        int endOffset = (int)srcPos.getEndPosition(info.getCompilationUnit(), tree);
        Tree startSearchingForNameIndentifierBehindThisTree = null;
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) {
            startSearchingForNameIndentifierBehindThisTree = ((ClassTree)tree).getModifiers();
        } else if (tree.getKind() == Tree.Kind.METHOD) {
            startSearchingForNameIndentifierBehindThisTree = ((MethodTree)tree).getReturnType();
        } else if (tree.getKind() == Tree.Kind.VARIABLE) {
            startSearchingForNameIndentifierBehindThisTree = ((VariableTree)tree).getType();
        }
        if (startSearchingForNameIndentifierBehindThisTree != null) {
            int searchStart = (int)srcPos.getEndPosition(info.getCompilationUnit(), startSearchingForNameIndentifierBehindThisTree);
            TokenSequence tokenSequence = info.getTreeUtilities().tokensFor(tree);
            if (tokenSequence != null) {
                boolean eob = false;
                tokenSequence.move(searchStart);
                do {
                    boolean bl = eob = !tokenSequence.moveNext();
                } while (!eob && tokenSequence.token().id() != JavaTokenId.IDENTIFIER);
                if (!eob) {
                    Token identifier = tokenSequence.token();
                    startOffset = identifier.offset(info.getTokenHierarchy());
                    endOffset = startOffset + identifier.length();
                }
            }
        }
        return new TextSpan(startOffset, endOffset);
    }

    private static void addAnnotationArgument(WorkingCopy workingCopy, Element element, Element annotationElement, String argumentName, Object argumentValue) throws IOException {
        Parameters.javaIdentifierOrNull((CharSequence)"argumentName", (CharSequence)argumentName);
        Parameters.notNull((CharSequence)"argumentValue", (Object)argumentValue);
        ModifiersTree oldTree = null;
        if (element instanceof TypeElement) {
            oldTree = workingCopy.getTrees().getTree((TypeElement)element).getModifiers();
        } else if (element instanceof ExecutableElement) {
            oldTree = workingCopy.getTrees().getTree((ExecutableElement)element).getModifiers();
        } else if (element instanceof VariableElement) {
            oldTree = ((VariableTree)workingCopy.getTrees().getTree(element)).getModifiers();
        }
        if (oldTree == null) {
            return;
        }
        AnnotationMirror annMirror = null;
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationElement.equals(annotationMirror.getAnnotationType().asElement())) continue;
            annMirror = annotationMirror;
        }
        if (annMirror == null) {
            return;
        }
        AnnotationTree annotation = (AnnotationTree)workingCopy.getTrees().getTree(element, annMirror);
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        ExpressionTree oldArgTree = Utilities.getAnnotationArgumentTree(annotation, argumentName);
        if (oldArgTree != null) {
            annotation = treeMaker.removeAnnotationAttrValue(annotation, oldArgTree);
        }
        ExpressionTree argumentValueTree = null;
        if (argumentValue instanceof Enum) {
            argumentValueTree = treeMaker.MemberSelect(treeMaker.QualIdent(argumentValue.getClass().getCanonicalName()), (CharSequence)((Enum)argumentValue).name());
        } else {
            try {
                argumentValueTree = treeMaker.Literal(argumentValue);
            }
            catch (IllegalArgumentException iae) {
                return;
            }
        }
        if (argumentName != null) {
            argumentValueTree = treeMaker.Assignment((ExpressionTree)treeMaker.Identifier((CharSequence)argumentName), argumentValueTree);
        }
        AnnotationTree modifiedAnnotation = treeMaker.addAnnotationAttrValue(annotation, argumentValueTree);
        workingCopy.rewrite((Tree)annotation, (Tree)modifiedAnnotation);
    }

    private static void removeAnnotationArgument(WorkingCopy workingCopy, Element element, Element annotationElement, String argumentName) throws IOException {
        Parameters.javaIdentifierOrNull((CharSequence)"argumentName", (CharSequence)argumentName);
        ModifiersTree oldTree = null;
        if (element instanceof TypeElement) {
            oldTree = workingCopy.getTrees().getTree((TypeElement)element).getModifiers();
        } else if (element instanceof ExecutableElement) {
            oldTree = workingCopy.getTrees().getTree((ExecutableElement)element).getModifiers();
        } else if (element instanceof VariableElement) {
            oldTree = ((VariableTree)workingCopy.getTrees().getTree(element)).getModifiers();
        }
        if (oldTree == null) {
            return;
        }
        AnnotationMirror annMirror = null;
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationElement.equals(annotationMirror.getAnnotationType().asElement())) continue;
            annMirror = annotationMirror;
        }
        if (annMirror == null) {
            return;
        }
        AnnotationTree annotation = (AnnotationTree)workingCopy.getTrees().getTree(element, annMirror);
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        ExpressionTree e = Utilities.getAnnotationArgumentTree(annotation, argumentName);
        AnnotationTree modifiedAnnotation = treeMaker.removeAnnotationAttrValue(annotation, e);
        workingCopy.rewrite((Tree)annotation, (Tree)modifiedAnnotation);
    }

    private static void addAnnotation(WorkingCopy workingCopy, Element element, String annotationName) throws IOException {
        ModifiersTree oldTree = null;
        if (element instanceof TypeElement) {
            oldTree = workingCopy.getTrees().getTree((TypeElement)element).getModifiers();
        } else if (element instanceof ExecutableElement) {
            oldTree = workingCopy.getTrees().getTree((ExecutableElement)element).getModifiers();
        } else if (element instanceof VariableElement) {
            oldTree = ((VariableTree)workingCopy.getTrees().getTree(element)).getModifiers();
        }
        if (oldTree == null) {
            return;
        }
        TreeMaker make = workingCopy.getTreeMaker();
        AnnotationTree annotationTree = make.Annotation((Tree)make.QualIdent(annotationName), Collections.emptyList());
        ModifiersTree newTree = make.addModifiersAnnotation(oldTree, annotationTree);
        workingCopy.rewrite((Tree)oldTree, (Tree)newTree);
    }

    private static void removeAnnotation(WorkingCopy workingCopy, Element element, String fqn) throws IOException {
        ModifiersTree oldTree = null;
        if (element instanceof TypeElement) {
            oldTree = workingCopy.getTrees().getTree((TypeElement)element).getModifiers();
        } else if (element instanceof ExecutableElement) {
            oldTree = workingCopy.getTrees().getTree((ExecutableElement)element).getModifiers();
        } else if (element instanceof VariableElement) {
            oldTree = ((VariableTree)workingCopy.getTrees().getTree(element)).getModifiers();
        }
        if (oldTree == null) {
            return;
        }
        AnnotationMirror annMirror = null;
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            Element annElement = annotationMirror.getAnnotationType().asElement();
            if (!(annElement instanceof TypeElement) || !fqn.contentEquals(((TypeElement)annElement).getQualifiedName())) continue;
            annMirror = annotationMirror;
        }
        if (annMirror == null) {
            return;
        }
        AnnotationTree annotation = (AnnotationTree)workingCopy.getTrees().getTree(element, annMirror);
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        ModifiersTree newTree = treeMaker.removeModifiersAnnotation(oldTree, annotation);
        workingCopy.rewrite((Tree)oldTree, (Tree)newTree);
    }

    public static class TextSpan {
        private int startOffset;
        private int endOffset;

        public TextSpan(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }
}

