/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.spi.remote.setup.support;

import java.util.Collection;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public abstract class RemoteSyncNotifier {
    private static final RemoteSyncNotifier INSTANCE = new FsSkewNotifierDefault();

    protected RemoteSyncNotifier() {
    }

    public static RemoteSyncNotifier getInstance() {
        if (CndUtils.isStandalone() || CndUtils.isUnitTestMode()) {
            return INSTANCE;
        }
        Collection notifiers = Lookup.getDefault().lookupAll(RemoteSyncNotifier.class);
        if (notifiers.isEmpty()) {
            return INSTANCE;
        }
        return (RemoteSyncNotifier)notifiers.iterator().next();
    }

    protected static CharSequence secondsToString(long skew) {
        long seconds = skew % 60L;
        long minutes = skew / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        StringBuilder sb = new StringBuilder();
        String[] unitNamesSingle = new String[]{NbBundle.getMessage(RemoteSyncNotifier.class, (String)"FS_Skew_Day"), NbBundle.getMessage(RemoteSyncNotifier.class, (String)"FS_Skew_Hour"), NbBundle.getMessage(RemoteSyncNotifier.class, (String)"FS_Skew_Minute"), NbBundle.getMessage(RemoteSyncNotifier.class, (String)"FS_Skew_Second")};
        String[] unitNamesPlural = new String[]{NbBundle.getMessage(RemoteSyncNotifier.class, (String)"FS_Skew_Days"), NbBundle.getMessage(RemoteSyncNotifier.class, (String)"FS_Skew_Hours"), NbBundle.getMessage(RemoteSyncNotifier.class, (String)"FS_Skew_Minutes"), NbBundle.getMessage(RemoteSyncNotifier.class, (String)"FS_Skew_Seconds")};
        long[] unitVlues = new long[]{days, hours %= 24L, minutes %= 60L, seconds};
        assert (unitNamesSingle.length == unitVlues.length);
        String comma = NbBundle.getMessage(RemoteSyncNotifier.class, (String)"FS_Skew_Comma");
        String and = NbBundle.getMessage(RemoteSyncNotifier.class, (String)"FS_Skew_And");
        for (int i = 0; i < unitVlues.length; ++i) {
            if (unitVlues[i] <= 0L) continue;
            if (sb.length() > 0) {
                if (i == unitVlues.length - 1) {
                    sb.append(' ');
                    sb.append(and);
                } else {
                    sb.append(comma);
                }
                sb.append(' ');
            }
            String unitName = unitVlues[i] > 1L ? unitNamesPlural[i] : unitNamesSingle[i];
            sb.append(unitVlues[i]).append(' ').append(unitName);
        }
        return sb;
    }

    public abstract void notify(ExecutionEnvironment var1, long var2);

    public abstract void warnDoubleRemote(ExecutionEnvironment var1, FileSystem var2);

    private static class FsSkewNotifierDefault
    extends RemoteSyncNotifier {
        @Override
        public void notify(ExecutionEnvironment env, long fsSkew) {
            CharSequence skewString = FsSkewNotifierDefault.secondsToString(fsSkew);
            skewString = fsSkew > 0L ? NbBundle.getMessage(RemoteSyncNotifier.class, (String)"FS_Skew_Faster", (Object)skewString) : NbBundle.getMessage(RemoteSyncNotifier.class, (String)"FS_Skew_Slower", (Object)skewString);
            System.err.println(skewString);
        }

        @Override
        public void warnDoubleRemote(ExecutionEnvironment buildEnv, FileSystem sourceFileSystem) {
            String message = NbBundle.getMessage(RemoteSyncNotifier.class, (String)"ErrorDoubleRemote", (Object)buildEnv, (Object)sourceFileSystem);
            System.err.println(message);
        }
    }
}

