/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.spi;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.AuthorTree;
import com.sun.source.doctree.CommentTree;
import com.sun.source.doctree.DeprecatedTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocRootTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.DocTreeVisitor;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.EntityTree;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.InheritDocTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.SeeTree;
import com.sun.source.doctree.SerialDataTree;
import com.sun.source.doctree.SerialFieldTree;
import com.sun.source.doctree.SerialTree;
import com.sun.source.doctree.SinceTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.doctree.UnknownInlineTagTree;
import com.sun.source.doctree.ValueTree;
import com.sun.source.doctree.VersionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import javax.lang.model.element.Element;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.openide.ErrorManager;

public class RefactoringVisitor
extends TreePathScanner<Tree, Element>
implements DocTreeVisitor<DocTree, Element> {
    protected WorkingCopy workingCopy;
    protected TreeMaker make;
    private final DocTreePathScannerImpl docScanner;

    public RefactoringVisitor() {
        this(false);
    }

    public RefactoringVisitor(boolean javadoc) {
        this.docScanner = javadoc ? new DocTreePathScannerImpl(this) : null;
    }

    public void setWorkingCopy(WorkingCopy workingCopy) throws ToPhaseException {
        this.workingCopy = workingCopy;
        try {
            if (this.workingCopy.toPhase(JavaSource.Phase.RESOLVED) != JavaSource.Phase.RESOLVED) {
                throw new ToPhaseException();
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
        }
        this.make = workingCopy.getTreeMaker();
    }

    protected void rewrite(Tree oldTree, Tree newTree) {
        TreePath tp;
        this.workingCopy.rewrite(oldTree, newTree);
        TreePath current = this.getCurrentPath();
        if (current.getLeaf() == oldTree) {
            JavaRefactoringUtils.cacheTreePathInfo(current, (CompilationInfo)this.workingCopy);
        } else if (oldTree != null && (tp = this.workingCopy.getTrees().getPath(current.getCompilationUnit(), oldTree)) != null) {
            JavaRefactoringUtils.cacheTreePathInfo(tp, (CompilationInfo)this.workingCopy);
        }
    }

    protected void rewrite(@NonNull Tree tree, @NullAllowed DocTree oldTree, @NonNull DocTree newTree) {
        TreePath tp;
        this.workingCopy.rewrite(tree, oldTree, newTree);
        TreePath current = this.getCurrentPath();
        if (current.getLeaf() == tree) {
            JavaRefactoringUtils.cacheTreePathInfo(current, (CompilationInfo)this.workingCopy);
        } else if (oldTree != null && (tp = this.workingCopy.getTrees().getPath(current.getCompilationUnit(), tree)) != null) {
            JavaRefactoringUtils.cacheTreePathInfo(tp, (CompilationInfo)this.workingCopy);
        }
    }

    @Override
    public Tree scan(Tree tree, Element p) {
        TreePath currentPath = this.getCurrentPath();
        if (this.docScanner != null && tree != null && currentPath != null) {
            switch (tree.getKind()) {
                case METHOD: 
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case VARIABLE: {
                    TreePath path = new TreePath(currentPath, tree);
                    this.scanJavadoc(path, p);
                }
            }
        }
        return (Tree)super.scan(tree, p);
    }

    @CheckForNull
    public DocTreePath getCurrentDocPath() {
        return this.docScanner.getCurrentPath();
    }

    @Override
    public DocTree visitAttribute(AttributeTree node, Element p) {
        return this.docScanner.visitAttribute(node, p, null);
    }

    @Override
    public DocTree visitAuthor(AuthorTree node, Element p) {
        return this.docScanner.visitAuthor(node, p, null);
    }

    @Override
    public DocTree visitComment(CommentTree node, Element p) {
        return this.docScanner.visitComment(node, p, null);
    }

    @Override
    public DocTree visitDeprecated(DeprecatedTree node, Element p) {
        return this.docScanner.visitDeprecated(node, p, null);
    }

    @Override
    public DocTree visitDocComment(DocCommentTree node, Element p) {
        return this.docScanner.visitDocComment(node, p, null);
    }

    @Override
    public DocTree visitDocRoot(DocRootTree node, Element p) {
        return this.docScanner.visitDocRoot(node, p, null);
    }

    @Override
    public DocTree visitEndElement(EndElementTree node, Element p) {
        return this.docScanner.visitEndElement(node, p, null);
    }

    @Override
    public DocTree visitEntity(EntityTree node, Element p) {
        return this.docScanner.visitEntity(node, p, null);
    }

    @Override
    public DocTree visitErroneous(ErroneousTree node, Element p) {
        return this.docScanner.visitErroneous(node, p, null);
    }

    @Override
    public DocTree visitIdentifier(IdentifierTree node, Element p) {
        return this.docScanner.visitIdentifier(node, p, null);
    }

    @Override
    public DocTree visitInheritDoc(InheritDocTree node, Element p) {
        return this.docScanner.visitInheritDoc(node, p, null);
    }

    @Override
    public DocTree visitLink(LinkTree node, Element p) {
        return this.docScanner.visitLink(node, p, null);
    }

    @Override
    public DocTree visitLiteral(LiteralTree node, Element p) {
        return this.docScanner.visitLiteral(node, p, null);
    }

    @Override
    public DocTree visitParam(ParamTree node, Element p) {
        return this.docScanner.visitParam(node, p, null);
    }

    @Override
    public DocTree visitReference(ReferenceTree node, Element p) {
        return this.docScanner.visitReference(node, p, null);
    }

    @Override
    public DocTree visitReturn(ReturnTree node, Element p) {
        return this.docScanner.visitReturn(node, p, null);
    }

    @Override
    public DocTree visitSee(SeeTree node, Element p) {
        return this.docScanner.visitSee(node, p, null);
    }

    @Override
    public DocTree visitSerial(SerialTree node, Element p) {
        return this.docScanner.visitSerial(node, p, null);
    }

    @Override
    public DocTree visitSerialData(SerialDataTree node, Element p) {
        return this.docScanner.visitSerialData(node, p, null);
    }

    @Override
    public DocTree visitSerialField(SerialFieldTree node, Element p) {
        return this.docScanner.visitSerialField(node, p, null);
    }

    @Override
    public DocTree visitSince(SinceTree node, Element p) {
        return this.docScanner.visitSince(node, p, null);
    }

    @Override
    public DocTree visitStartElement(StartElementTree node, Element p) {
        return this.docScanner.visitStartElement(node, p, null);
    }

    @Override
    public DocTree visitText(TextTree node, Element p) {
        return this.docScanner.visitText(node, p, null);
    }

    @Override
    public DocTree visitThrows(ThrowsTree node, Element p) {
        return this.docScanner.visitThrows(node, p, null);
    }

    @Override
    public DocTree visitUnknownBlockTag(UnknownBlockTagTree node, Element p) {
        return this.docScanner.visitUnknownBlockTag(node, p, null);
    }

    @Override
    public DocTree visitUnknownInlineTag(UnknownInlineTagTree node, Element p) {
        return this.docScanner.visitUnknownInlineTag(node, p, null);
    }

    @Override
    public DocTree visitValue(ValueTree node, Element p) {
        return this.docScanner.visitValue(node, p, null);
    }

    @Override
    public DocTree visitVersion(VersionTree node, Element p) {
        return this.docScanner.visitVersion(node, p, null);
    }

    @Override
    public DocTree visitOther(DocTree node, Element p) {
        return this.docScanner.visitOther(node, p, null);
    }

    private void scanJavadoc(TreePath path, Element p) {
        DocCommentTree docCommentTree = this.workingCopy.getDocTrees().getDocCommentTree(path);
        if (docCommentTree != null) {
            DocTreePath docTreePath = new DocTreePath(path, docCommentTree);
            this.docScanner.scan(docTreePath, p);
        }
    }

    private static class DocTreePathScannerImpl
    extends DocTreePathScanner<DocTree, Element> {
        private final RefactoringVisitor instance;

        public DocTreePathScannerImpl(RefactoringVisitor instance) {
            this.instance = instance;
        }

        @Override
        public DocTree visitAttribute(AttributeTree node, Element p) {
            return this.instance.visitAttribute(node, p);
        }

        @Override
        public DocTree visitAuthor(AuthorTree node, Element p) {
            return this.instance.visitAuthor(node, p);
        }

        @Override
        public DocTree visitComment(CommentTree node, Element p) {
            return this.instance.visitComment(node, p);
        }

        @Override
        public DocTree visitDeprecated(DeprecatedTree node, Element p) {
            return this.instance.visitDeprecated(node, p);
        }

        @Override
        public DocTree visitDocComment(DocCommentTree node, Element p) {
            return this.instance.visitDocComment(node, p);
        }

        @Override
        public DocTree visitDocRoot(DocRootTree node, Element p) {
            return this.instance.visitDocRoot(node, p);
        }

        @Override
        public DocTree visitEndElement(EndElementTree node, Element p) {
            return this.instance.visitEndElement(node, p);
        }

        @Override
        public DocTree visitEntity(EntityTree node, Element p) {
            return this.instance.visitEntity(node, p);
        }

        @Override
        public DocTree visitErroneous(ErroneousTree node, Element p) {
            return this.instance.visitErroneous(node, p);
        }

        @Override
        public DocTree visitIdentifier(IdentifierTree node, Element p) {
            return this.instance.visitIdentifier(node, p);
        }

        @Override
        public DocTree visitInheritDoc(InheritDocTree node, Element p) {
            return this.instance.visitInheritDoc(node, p);
        }

        @Override
        public DocTree visitLink(LinkTree node, Element p) {
            return this.instance.visitLink(node, p);
        }

        @Override
        public DocTree visitLiteral(LiteralTree node, Element p) {
            return this.instance.visitLiteral(node, p);
        }

        @Override
        public DocTree visitParam(ParamTree node, Element p) {
            return this.instance.visitParam(node, p);
        }

        @Override
        public DocTree visitReference(ReferenceTree node, Element p) {
            return this.instance.visitReference(node, p);
        }

        @Override
        public DocTree visitReturn(ReturnTree node, Element p) {
            return this.instance.visitReturn(node, p);
        }

        @Override
        public DocTree visitSee(SeeTree node, Element p) {
            return this.instance.visitSee(node, p);
        }

        @Override
        public DocTree visitSerial(SerialTree node, Element p) {
            return this.instance.visitSerial(node, p);
        }

        @Override
        public DocTree visitSerialData(SerialDataTree node, Element p) {
            return this.instance.visitSerialData(node, p);
        }

        @Override
        public DocTree visitSerialField(SerialFieldTree node, Element p) {
            return this.instance.visitSerialField(node, p);
        }

        @Override
        public DocTree visitSince(SinceTree node, Element p) {
            return this.instance.visitSince(node, p);
        }

        @Override
        public DocTree visitStartElement(StartElementTree node, Element p) {
            return this.instance.visitStartElement(node, p);
        }

        @Override
        public DocTree visitText(TextTree node, Element p) {
            return this.instance.visitText(node, p);
        }

        @Override
        public DocTree visitThrows(ThrowsTree node, Element p) {
            return this.instance.visitThrows(node, p);
        }

        @Override
        public DocTree visitUnknownBlockTag(UnknownBlockTagTree node, Element p) {
            return this.instance.visitUnknownBlockTag(node, p);
        }

        @Override
        public DocTree visitUnknownInlineTag(UnknownInlineTagTree node, Element p) {
            return this.instance.visitUnknownInlineTag(node, p);
        }

        @Override
        public DocTree visitValue(ValueTree node, Element p) {
            return this.instance.visitValue(node, p);
        }

        @Override
        public DocTree visitVersion(VersionTree node, Element p) {
            return this.instance.visitVersion(node, p);
        }

        @Override
        public DocTree visitOther(DocTree node, Element p) {
            return this.instance.visitOther(node, p);
        }

        public DocTree visitAttribute(AttributeTree node, Element p, Void ignore) {
            return (DocTree)super.visitAttribute(node, p);
        }

        public DocTree visitAuthor(AuthorTree node, Element p, Void ignore) {
            return (DocTree)super.visitAuthor(node, p);
        }

        public DocTree visitComment(CommentTree node, Element p, Void ignore) {
            return (DocTree)super.visitComment(node, p);
        }

        public DocTree visitDeprecated(DeprecatedTree node, Element p, Void ignore) {
            return (DocTree)super.visitDeprecated(node, p);
        }

        public DocTree visitDocComment(DocCommentTree node, Element p, Void ignore) {
            return (DocTree)super.visitDocComment(node, p);
        }

        public DocTree visitDocRoot(DocRootTree node, Element p, Void ignore) {
            return (DocTree)super.visitDocRoot(node, p);
        }

        public DocTree visitEndElement(EndElementTree node, Element p, Void ignore) {
            return (DocTree)super.visitEndElement(node, p);
        }

        public DocTree visitEntity(EntityTree node, Element p, Void ignore) {
            return (DocTree)super.visitEntity(node, p);
        }

        public DocTree visitErroneous(ErroneousTree node, Element p, Void ignore) {
            return (DocTree)super.visitErroneous(node, p);
        }

        public DocTree visitIdentifier(IdentifierTree node, Element p, Void ignore) {
            return (DocTree)super.visitIdentifier(node, p);
        }

        public DocTree visitInheritDoc(InheritDocTree node, Element p, Void ignore) {
            return (DocTree)super.visitInheritDoc(node, p);
        }

        public DocTree visitLink(LinkTree node, Element p, Void ignore) {
            return (DocTree)super.visitLink(node, p);
        }

        public DocTree visitLiteral(LiteralTree node, Element p, Void ignore) {
            return (DocTree)super.visitLiteral(node, p);
        }

        public DocTree visitParam(ParamTree node, Element p, Void ignore) {
            return (DocTree)super.visitParam(node, p);
        }

        public DocTree visitReference(ReferenceTree node, Element p, Void ignore) {
            return (DocTree)super.visitReference(node, p);
        }

        public DocTree visitReturn(ReturnTree node, Element p, Void ignore) {
            return (DocTree)super.visitReturn(node, p);
        }

        public DocTree visitSee(SeeTree node, Element p, Void ignore) {
            return (DocTree)super.visitSee(node, p);
        }

        public DocTree visitSerial(SerialTree node, Element p, Void ignore) {
            return (DocTree)super.visitSerial(node, p);
        }

        public DocTree visitSerialData(SerialDataTree node, Element p, Void ignore) {
            return (DocTree)super.visitSerialData(node, p);
        }

        public DocTree visitSerialField(SerialFieldTree node, Element p, Void ignore) {
            return (DocTree)super.visitSerialField(node, p);
        }

        public DocTree visitSince(SinceTree node, Element p, Void ignore) {
            return (DocTree)super.visitSince(node, p);
        }

        public DocTree visitStartElement(StartElementTree node, Element p, Void ignore) {
            return (DocTree)super.visitStartElement(node, p);
        }

        public DocTree visitText(TextTree node, Element p, Void ignore) {
            return (DocTree)super.visitText(node, p);
        }

        public DocTree visitThrows(ThrowsTree node, Element p, Void ignore) {
            return (DocTree)super.visitThrows(node, p);
        }

        public DocTree visitUnknownBlockTag(UnknownBlockTagTree node, Element p, Void ignore) {
            return (DocTree)super.visitUnknownBlockTag(node, p);
        }

        public DocTree visitUnknownInlineTag(UnknownInlineTagTree node, Element p, Void ignore) {
            return (DocTree)super.visitUnknownInlineTag(node, p);
        }

        public DocTree visitValue(ValueTree node, Element p, Void ignore) {
            return (DocTree)super.visitValue(node, p);
        }

        public DocTree visitVersion(VersionTree node, Element p, Void ignore) {
            return (DocTree)super.visitVersion(node, p);
        }

        public DocTree visitOther(DocTree node, Element p, Void ignore) {
            return (DocTree)super.visitOther(node, p);
        }
    }
}

