/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.hints.pom.spi.POMErrorFixProvider;
import org.netbeans.modules.maven.hints.pom.spi.SelectionPOMFixProvider;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMModelFactory;
import org.netbeans.modules.maven.model.pom.Parent;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.spi.editor.errorstripe.UpToDateStatus;
import org.netbeans.spi.editor.errorstripe.UpToDateStatusProvider;
import org.netbeans.spi.editor.errorstripe.UpToDateStatusProviderFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotation;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

public final class StatusProvider
implements UpToDateStatusProviderFactory {
    private static final String LAYER_POM = "pom";
    private static final String LAYER_POM_SELECTION = "pom-selection";
    private static final RequestProcessor RP = new RequestProcessor("StatusProvider");
    private static final Logger LOG = Logger.getLogger(StatusProvider.class.getName());

    public UpToDateStatusProvider createUpToDateStatusProvider(Document document) {
        return new StatusProviderImpl(document);
    }

    private static void runMavenValidation(POMModel model, List<ErrorDescription> err) {
        File pom = (File)model.getModelSource().getLookup().lookup(File.class);
        if (pom == null) {
            return;
        }
        List<ModelProblem> problems = StatusProvider.runMavenValidationImpl(pom);
        for (ModelProblem problem : problems) {
            if (!problem.getSource().equals(pom.getAbsolutePath())) {
                LOG.log(Level.FINE, "found problem not in {0}: {1}", new Object[]{pom, problem.getSource()});
                continue;
            }
            int line = problem.getLineNumber();
            if (line <= 0 || problem.getException() instanceof UnresolvableModelException) continue;
            try {
                err.add(ErrorDescriptionFactory.createErrorDescription((Severity)(problem.getSeverity() == ModelProblem.Severity.WARNING ? Severity.WARNING : Severity.ERROR), (String)problem.getMessage(), (Document)model.getBaseDocument(), (int)line));
            }
            catch (IndexOutOfBoundsException x) {
                LOG.log(Level.WARNING, "improper line number: {0}", problem);
            }
        }
    }

    static List<ModelProblem> runMavenValidationImpl(File pom) {
        List problems;
        block5: {
            MavenEmbedder embedder = EmbedderFactory.getProjectEmbedder();
            MavenExecutionRequest meReq = embedder.createMavenExecutionRequest();
            ProjectBuildingRequest req = meReq.getProjectBuildingRequest();
            req.setValidationLevel(30);
            req.setLocalRepository(embedder.getLocalRepository());
            List remoteRepos = RepositoryPreferences.getInstance().remoteRepositories(embedder);
            req.setRemoteRepositories(remoteRepos);
            req.setRepositorySession(((DefaultMaven)embedder.lookupComponent(Maven.class)).newRepositorySession(meReq));
            try {
                problems = ((ProjectBuilder)embedder.lookupComponent(ProjectBuilder.class)).build(pom, req).getProblems();
            }
            catch (ProjectBuildingException x) {
                problems = new ArrayList();
                List results = x.getResults();
                if (results != null) {
                    for (ProjectBuildingResult result : results) {
                        problems.addAll(result.getProblems());
                    }
                }
                Throwable cause = x.getCause();
                if (!(cause instanceof ModelBuildingException)) break block5;
                problems.addAll(((ModelBuildingException)cause).getProblems());
            }
        }
        LinkedList<ModelProblem> toRet = new LinkedList<ModelProblem>();
        for (ModelProblem problem : problems) {
            if (!ModelUtils.checkByCLIMavenValidationLevel((ModelProblem)problem)) continue;
            toRet.add(problem);
        }
        return toRet;
    }

    public static class ParentPomAnnotation
    extends Annotation {
        public String getAnnotationType() {
            return "org-netbeans-modules-editor-annotations-implements";
        }

        public String getShortDescription() {
            return "Go to parent POM declaration";
        }
    }

    static class StatusProviderImpl
    extends UpToDateStatusProvider {
        private final Document document;
        @NullAllowed
        private POMModel model;
        private Project project;
        private final FileChangeListener listener;
        private final PreferenceChangeListener prefListener;

        StatusProviderImpl(Document doc) {
            this.document = doc;
            this.listener = new FileChangeAdapter(){

                public void fileChanged(FileEvent fe) {
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            StatusProviderImpl.this.checkHints();
                        }
                    });
                }
            };
            this.prefListener = new PreferenceChangeListener(){

                @Override
                public void preferenceChange(PreferenceChangeEvent evt) {
                    if ("commandLineMavenPath".equals(evt.getKey())) {
                        StatusProviderImpl.this.checkHints();
                    }
                }
            };
            Preferences prefs = NbPreferences.root().node("org/netbeans/modules/maven");
            prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.prefListener, (Object)prefs));
            RP.post(new Runnable(){

                @Override
                public void run() {
                    StatusProviderImpl.this.initializeModel();
                    StatusProviderImpl.this.checkHints();
                }
            });
        }

        private void checkHints() {
            if (this.model == null) {
                return;
            }
            HintsController.setErrors((Document)this.document, (String)StatusProvider.LAYER_POM, StatusProviderImpl.findHints(this.model, this.project, -1, -1, -1));
        }

        static List<ErrorDescription> findHints(final @NonNull POMModel model, final Project project, final int selectionStart, final int selectionEnd, final int caretPosition) {
            final ArrayList<ErrorDescription> err = new ArrayList<ErrorDescription>();
            StatusProvider.runMavenValidation(model, err);
            if (!StatusProviderImpl.checkModelValid(model)) {
                return err;
            }
            return (List)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<List<ErrorDescription>>(){

                public List<ErrorDescription> run() {
                    Lookup lkp = Lookups.forPath((String)"org-netbeans-modules-maven-hints");
                    if (selectionStart == -1 && selectionEnd == -1) {
                        Lookup.Result res = lkp.lookupResult(POMErrorFixProvider.class);
                        for (POMErrorFixProvider prov : res.allInstances()) {
                            List<ErrorDescription> lst;
                            if (!prov.getConfiguration().isEnabled(prov.getConfiguration().getPreferences()) || (lst = prov.getErrorsForDocument(model, project)) == null) continue;
                            err.addAll(lst);
                        }
                    } else {
                        Lookup.Result res = lkp.lookupResult(SelectionPOMFixProvider.class);
                        for (SelectionPOMFixProvider prov : res.allInstances()) {
                            List<ErrorDescription> lst;
                            if (!prov.getConfiguration().isEnabled(prov.getConfiguration().getPreferences()) || (lst = prov.getErrorsForDocument(model, project, selectionStart, selectionEnd, caretPosition)) == null) continue;
                            err.addAll(lst);
                        }
                    }
                    return err;
                }
            });
        }

        private static boolean checkModelValid(POMModel model) {
            assert (model != null);
            if (!model.getModelSource().isEditable()) {
                return false;
            }
            try {
                model.getBaseDocument();
                model.sync();
            }
            catch (IOException ex) {
                LOG.log(Level.FINE, "Error while syncing pom model.", ex);
            }
            if (!model.getState().equals((Object)Model.State.VALID)) {
                LOG.log(Level.FINE, "Pom model document is not valid, is {0}", model.getState());
                return false;
            }
            if (model.getProject() == null) {
                LOG.log(Level.FINE, "Pom model root element missing");
                return false;
            }
            return true;
        }

        private void initializeModel() {
            FileObject fo = NbEditorUtilities.getFileObject((Document)this.document);
            if (fo != null) {
                ModelSource ms = Utilities.createModelSource((FileObject)fo, null, this.document instanceof BaseDocument ? (BaseDocument)this.document : null);
                this.model = (POMModel)POMModelFactory.getDefault().createFreshModel(ms);
                this.project = FileOwnerQuery.getOwner((FileObject)fo);
                fo.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.listener, (Object)fo));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UpToDateStatus getUpToDate() {
            if (this.model == null) {
                return UpToDateStatus.UP_TO_DATE_OK;
            }
            FileObject fo = NbEditorUtilities.getFileObject((Document)this.document);
            boolean ok = false;
            try {
                JEditorPane[] panes;
                DataObject dobj;
                EditorCookie ed;
                if (fo.isValid() && (ed = (EditorCookie)(dobj = DataObject.find((FileObject)fo)).getLookup().lookup(EditorCookie.class)) != null && (panes = ed.getOpenedPanes()) != null && panes.length > 0) {
                    JEditorPane pane = panes[0];
                    if (panes.length > 1) {
                        for (JEditorPane p : panes) {
                            if (!p.isFocusOwner()) continue;
                            pane = p;
                            break;
                        }
                    }
                    final int selectionStart = pane.getSelectionStart();
                    final int selectionEnd = pane.getSelectionEnd();
                    final int caretPosition = pane.getCaretPosition();
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            StatusProviderImpl.this.refreshLinkAnnotations(StatusProviderImpl.this.document, StatusProviderImpl.this.model, selectionStart, selectionEnd);
                        }
                    });
                    if (selectionStart != selectionEnd) {
                        RP.post(new Runnable(){

                            @Override
                            public void run() {
                                if (!StatusProviderImpl.this.model.isIntransaction()) {
                                    HintsController.setErrors((Document)StatusProviderImpl.this.document, (String)StatusProvider.LAYER_POM_SELECTION, StatusProviderImpl.findHints(StatusProviderImpl.this.model, StatusProviderImpl.this.project, selectionStart, selectionEnd, caretPosition));
                                } else {
                                    HintsController.setErrors((Document)StatusProviderImpl.this.document, (String)StatusProvider.LAYER_POM_SELECTION, Collections.emptyList());
                                }
                            }
                        });
                        ok = true;
                        UpToDateStatus upToDateStatus = UpToDateStatus.UP_TO_DATE_PROCESSING;
                        return upToDateStatus;
                    }
                }
            }
            catch (DataObjectNotFoundException ex) {
                LOG.log(Level.INFO, "Touched somehow invalidated FileObject", ex);
            }
            finally {
                if (!ok) {
                    HintsController.setErrors((Document)this.document, (String)StatusProvider.LAYER_POM_SELECTION, Collections.emptyList());
                }
            }
            return UpToDateStatus.UP_TO_DATE_OK;
        }

        private void refreshLinkAnnotations(Document document, POMModel model, int selectionStart, int selectionEnd) {
            if (document instanceof StyledDocument) {
                StyledDocument styled = (StyledDocument)document;
                Annotation[] old = (Annotation[])styled.getProperty("maven_annot");
                if (old != null) {
                    for (Annotation ann : old) {
                        NbDocument.removeAnnotation((StyledDocument)styled, (Annotation)ann);
                    }
                    styled.putProperty("maven_annot", null);
                }
                if (StatusProviderImpl.checkModelValid(model)) {
                    try {
                        ArrayList<ParentPomAnnotation> anns = new ArrayList<ParentPomAnnotation>();
                        Parent p = (Parent)model.findComponent(selectionStart, Parent.class, true);
                        if (p != null && p.getArtifactId() != null && p.getGroupId() != null && p.getVersion() != null) {
                            ParentPomAnnotation ann = new ParentPomAnnotation();
                            anns.add(ann);
                            Position position = NbDocument.createPosition((Document)document, (int)selectionStart, (Position.Bias)Position.Bias.Forward);
                            NbDocument.addAnnotation((StyledDocument)styled, (Position)position, (int)(selectionEnd - selectionStart), (Annotation)ann);
                        }
                        styled.putProperty("maven_annot", anns.toArray(new Annotation[0]));
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
    }
}

